/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.api.Oidable;

public interface IVariant
extends Oidable {
    public static final String _NBT_VARIANT = LibInfo.cc("VariantID");
    public static final BiFunction<ItemStack, String, String> BYNAME_LOOKUP = (item, defaultIfMissing) -> {
        String v = defaultIfMissing;
        if (!item.func_190926_b()) {
            if (ItemStacks.hasData(item, _NBT_VARIANT, 8)) {
                v = ItemStacks.getString(item, _NBT_VARIANT);
            } else if (ItemStacks.hasData(item, _NBT_VARIANT, 99)) {
                v = String.valueOf(ItemStacks.getInt(item, _NBT_VARIANT));
            }
        }
        return v;
    };
    public static final BiConsumer<ItemStack, String> BYNAME_STORAGE = (item, valu) -> {
        if (!item.func_190926_b()) {
            ItemStacks.setString(item, _NBT_VARIANT, valu);
        }
    };
    public static final BiFunction<ItemStack, Integer, Integer> BYMETA_LOOKUP = (item, defaultIfMissing) -> {
        Integer v = defaultIfMissing;
        if (!item.func_190926_b() && ItemStacks.hasData(item, _NBT_VARIANT, 99)) {
            v = ItemStacks.getInt(item, _NBT_VARIANT);
        }
        return v;
    };
    public static final BiConsumer<ItemStack, Integer> BYMETA_STORAGE = (item, meta) -> {
        if (!item.func_190926_b()) {
            ItemStacks.setInt(item, _NBT_VARIANT, meta);
        }
    };

    @Nonnull
    default public String varid() {
        return "";
    }

    @Nonnull
    public List<ItemStack> copyOfAllVariantMembers();

    default public ItemStack randomPick(@Nonnull ItemStack base, @Nullable Predicate<Item> filter, @Nonnull Random rng) {
        List<ItemStack> all = this.copyOfAllVariantMembers();
        if (all.isEmpty()) {
            return base;
        }
        if (all.size() > 3) {
            Collections.shuffle(all, rng);
        }
        if (filter == null) {
            return all.get(rng.nextInt(all.size()));
        }
        ListIterator<ItemStack> litr = all.listIterator();
        while (litr.hasNext()) {
            if (!filter.test(litr.next().func_77973_b())) continue;
            litr.remove();
        }
        return all.isEmpty() ? base : all.get(rng.nextInt(all.size()));
    }
}

