/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.capability;

import java.util.List;
import java.util.Optional;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jwaresoftware.mcmods.lib.capability.IDye;

public interface IDyeable {
    public boolean isDyed(ItemStack var1);

    public int getDyedColorRGB(ItemStack var1);

    public void setDyedColorRGB(ItemStack var1, int var2);

    public boolean removeDyedColor(ItemStack var1);

    public static Optional<IDyeable> get(ItemStack stack) {
        if (stack != null && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof IDyeable) {
                return Optional.of((IDyeable)stack.func_77973_b());
            }
            if (stack.func_77973_b() instanceof IDyeableArmorItem) {
                return Optional.of(ArmorWrapper.INSTANCE);
            }
        }
        return Optional.empty();
    }

    public static ItemStack applyDyes(ItemStack original, List<ItemStack> dyes) {
        MutableObject dyed = new MutableObject((Object)ItemStack.field_190927_a);
        IDyeable.get(original).ifPresent(spi -> {
            int[] rgb_new = new int[3];
            int i = 0;
            int num_appl = 0;
            if (spi.isDyed(original)) {
                int rgb_cur = spi.getDyedColorRGB(original);
                float r = (float)(rgb_cur >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb_cur >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb_cur & 0xFF) / 255.0f;
                i = (int)((float)i + Math.max(r, Math.max(g, b)) * 255.0f);
                rgb_new[0] = (int)((float)rgb_new[0] + r * 255.0f);
                rgb_new[1] = (int)((float)rgb_new[1] + g * 255.0f);
                rgb_new[2] = (int)((float)rgb_new[2] + b * 255.0f);
                ++num_appl;
            }
            for (ItemStack dyeitem : dyes) {
                Optional<IDye> dye = IDye.get(dyeitem);
                if (!dye.isPresent()) continue;
                float[] rgb_dye = dye.get().getDyeColorComponentValues(dyeitem);
                int r_dye = (int)(rgb_dye[0] * 255.0f);
                int g_dye = (int)(rgb_dye[1] * 255.0f);
                int b_dye = (int)(rgb_dye[2] * 255.0f);
                i += Math.max(r_dye, Math.max(g_dye, b_dye));
                rgb_new[0] = rgb_new[0] + r_dye;
                rgb_new[1] = rgb_new[1] + g_dye;
                rgb_new[2] = rgb_new[2] + b_dye;
                ++num_appl;
            }
            int j1 = rgb_new[0] / num_appl;
            int k1 = rgb_new[1] / num_appl;
            int l1 = rgb_new[2] / num_appl;
            float f3 = (float)i / (float)num_appl;
            float f4 = Math.max(j1, Math.max(k1, l1));
            j1 = (int)((float)j1 * f3 / f4);
            k1 = (int)((float)k1 * f3 / f4);
            l1 = (int)((float)l1 * f3 / f4);
            int j2 = (j1 << 8) + k1;
            j2 = (j2 << 8) + l1;
            ItemStack out = original.func_77946_l();
            out.func_190920_e(1);
            spi.setDyedColorRGB(out, j2);
            dyed.setValue((Object)out);
        });
        return (ItemStack)dyed.getValue();
    }

    public static final class ArmorWrapper
    implements IDyeable {
        public static final IDyeable INSTANCE = new ArmorWrapper();

        @Override
        public boolean isDyed(ItemStack a) {
            return ((IDyeableArmorItem)a.func_77973_b()).func_200883_f_(a);
        }

        @Override
        public int getDyedColorRGB(ItemStack a) {
            return ((IDyeableArmorItem)a.func_77973_b()).func_200886_f(a);
        }

        @Override
        public void setDyedColorRGB(ItemStack a, int rgb) {
            ((IDyeableArmorItem)a.func_77973_b()).func_200885_a(a, rgb);
        }

        @Override
        public boolean removeDyedColor(ItemStack a) {
            boolean had = this.isDyed(a);
            ((IDyeableArmorItem)a.func_77973_b()).func_200884_g(a);
            return had;
        }

        ArmorWrapper() {
        }
    }
}

