/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.capability;

import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;

public interface IGradeable {
    public static final String PROPERTY_QGRADE = "qgrade";
    public static final String NBT_QGRADE = LibInfo.rstring("QGrade");

    @Nonnull
    default public QualityGrade getQualityGrade(ItemStack source) {
        return QualityGradePropertyGetter.getFromTag(source);
    }

    public static final class QualityGradePropertyGetter
    implements IItemPropertyGetter {
        public static final IItemPropertyGetter INSTANCE = new QualityGradePropertyGetter();

        @OnlyIn(value=Dist.CLIENT)
        public float call(ItemStack stack, World world, LivingEntity unused) {
            QualityGrade out;
            if (stack.func_77973_b() instanceof IGradeable) {
                IGradeable cap = (IGradeable)stack.func_77973_b();
                out = cap.getQualityGrade(stack);
            } else {
                out = QualityGradePropertyGetter.getFromTag(stack);
            }
            return out.value();
        }

        private QualityGradePropertyGetter() {
        }

        public static final void addTo(@Nonnull Item item) {
            item.func_185043_a(new ResourceLocation(IGradeable.PROPERTY_QGRADE), INSTANCE);
        }

        @Nonnull
        public static final QualityGrade getFromTag(ItemStack stack) {
            QualityGrade out = QualityGrade.UNKNOWN;
            if (ItemStacks.hasData(stack, NBT_QGRADE, 8)) {
                String s = ItemStacks.getString(stack, NBT_QGRADE);
                out = QualityGrade.findOrUnknown(s);
            }
            return out;
        }
    }
}

