/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICompostable;
import org.jwaresoftware.mcmods.lib.impl.ItemBase;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;

public class FoodItemBase
extends ItemBase
implements ICompostable {
    @Nonnull
    public static Item.Properties foodproperties(@Nullable Item.Properties ip, boolean hidden) {
        return ip != null ? ip : new Item.Properties().func_200916_a(hidden ? null : SharedGlue.CreativeTabs_food);
    }

    @Nonnull
    public static Item.Properties foodproperties(@Nullable Item.Properties ip, int foodPoints, float saturationFactor, boolean isWolfFood, boolean hidden) {
        return FoodItemBase.foodproperties(ip, hidden).func_221540_a(ItemSupport.foodFrom(foodPoints, saturationFactor, isWolfFood).func_221453_d());
    }

    protected FoodItemBase(String gid, String oid, boolean hidden, Item.Properties ip) {
        super(gid, oid, hidden, FoodItemBase.foodproperties(ip, true));
    }

    protected FoodItemBase(String oid, boolean hidden, Item.Properties ip) {
        this("", oid, hidden, ip);
    }

    protected FoodItemBase(String gid, String oid, int foodPoints, float saturationFactor, boolean isWolfFood, boolean hidden) {
        this(gid, oid, hidden, FoodItemBase.foodproperties(null, foodPoints, saturationFactor, isWolfFood, hidden));
    }

    protected FoodItemBase(String oid, int foodPoints, float saturationFactor, boolean isWolfFood, boolean hidden) {
        this("", oid, foodPoints, saturationFactor, isWolfFood, hidden);
    }

    public FoodItemBase(String oid, int foodPoints, float saturationFactor) {
        this("", oid, foodPoints, saturationFactor, false, false);
    }

    public FoodItemBase(String gid, String oid, int foodPoints, float saturationFactor) {
        this(gid, oid, foodPoints, saturationFactor, false, false);
    }

    public final <T extends FoodItemBase> T setAlwaysEdible() {
        return (T)ItemSupport.setAlwaysEdible(this);
    }

    protected boolean isInstaConsume(ItemStack stack) {
        return false;
    }

    public int getHealAmount(ItemStack stack) {
        Food f = this.func_219967_s();
        return f != null ? f.func_221466_a() : 0;
    }

    public int getUseHealAmount(ItemStack consumed, int foodPoints) {
        return foodPoints;
    }

    public float getSaturationModifier(ItemStack stack) {
        Food f = this.func_219967_s();
        return f != null ? f.func_221469_b() : 0.0f;
    }

    public float getUseSaturationModifier(ItemStack consumed, float foodSaturation) {
        return foodSaturation;
    }

    @Override
    public float getCompostChance() {
        return this.getCompostChance(this);
    }

    public static final ItemStack returnOrDropContainer(ItemStack remaining, PlayerEntity player, @Nonnull ItemStack emptyContainerOrRemains) {
        if (SharedGlue.getPlayerInSurvival(player)) {
            if (ItemStacks.isEmpty(remaining)) {
                return emptyContainerOrRemains;
            }
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)emptyContainerOrRemains);
        }
        return remaining;
    }
}

