/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.stats.Stats;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.IModItem;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;

public class ItemBase
extends Item
implements IModItem {
    @Nonnull
    protected final String _oid;
    protected String _gid;
    protected boolean _hidden = false;
    @Nullable
    protected Rarity _rarity = null;
    @Nullable
    protected Boolean _glimmer = null;
    @Nonnull
    protected String _i18n = "";

    @Nonnull
    public static Item.Properties defaultproperties(@Nullable Item.Properties ip, boolean hidden) {
        return ip != null ? ip : new Item.Properties().func_200916_a(hidden ? null : SharedGlue.CreativeTabs_misc);
    }

    protected ItemBase(@Nonnull String gid, @Nonnull String oid, boolean hidden, @Nullable Item.Properties ip) {
        super(ItemBase.defaultproperties(ip, hidden));
        this._oid = Objects.requireNonNull(oid, "Non-null oid required");
        this._gid = gid == null ? "" : gid;
        this._hidden = hidden;
    }

    protected ItemBase(@Nonnull String oid, boolean hidden, Item.Properties ip) {
        this("", oid, hidden, ip);
    }

    public ItemBase(String oid) {
        this(oid, false, null);
    }

    public ItemBase(String gid, String oid) {
        this(gid, oid, false, null);
    }

    @Override
    public String oid() {
        return this._oid;
    }

    @Override
    public String gid(Object unused) {
        return this._gid;
    }

    @Override
    public <T> T inGroup(@Nullable String gid) {
        this._gid = gid == null ? "" : gid;
        return (T)this;
    }

    public boolean func_219971_r() {
        return this.func_219967_s() != null;
    }

    @Nullable
    public final Food getBaseFood() {
        return super.func_219967_s();
    }

    protected String func_195935_o() {
        if (this._i18n.isEmpty()) {
            this._i18n = ItemSupport.defaultTranslationKey(this);
        }
        return this._i18n;
    }

    public int getColorFrom(ItemStack stack, int tintIndex) {
        return -1;
    }

    @Override
    public int getBurnTime(ItemStack stack) {
        return IModItem.super.getBurnTime(stack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        Rarity r = super.func_77613_e(stack);
        return this._rarity != null && this._rarity.ordinal() > r.ordinal() ? this._rarity : r;
    }

    public final ItemBase setRarity(@Nullable Rarity rarity) {
        this._rarity = rarity;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this._glimmer != null ? this._glimmer.booleanValue() : super.func_77636_d(stack);
    }

    public final ItemBase setGlimmerEffect(boolean setting) {
        this._glimmer = setting;
        return this;
    }

    @Override
    public boolean isHiddenByDefault() {
        return this._hidden;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.isHiddenByDefault() && this.func_194125_a(tab)) {
            items.add((Object)this.createInstance(this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (this.isShowingUiTips(stack)) {
            Tooltips.addDocTipDefault(stack, tooltip);
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    protected void addUsedStat(@Nonnull PlayerEntity player) {
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
    }

    protected void addBrokenStat(@Nonnull PlayerEntity player) {
        player.func_71029_a(Stats.field_199088_e.func_199076_b((Object)this));
    }

    public final <T extends ItemBase> T setMaxStackSize(int count) {
        return (T)ItemSupport.setMaxStackSize(this, count);
    }

    public final <T extends ItemBase> T setContainerItem(@Nullable Item container) {
        return (T)ItemSupport.setContainerItem(this, container);
    }

    public final <T extends ItemBase> T setMaxDamage(int amount) {
        return (T)ItemSupport.setMaxDamage(this, amount);
    }
}

