/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import net.thirdparty.silentchaos512.utils.config.ConfigSpecWrapper;
import net.thirdparty.silentchaos512.utils.config.ConfigValue;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.mod.IModConfig;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;

public abstract class ModConfigBase
implements IModConfig {
    public String I18N = "gui.config.";
    protected static final ResourceLocation[] _NO_RESOURCE_IDS = new ResourceLocation[0];
    protected final IModInfo _modinfo;
    protected boolean _loaded = false;
    protected ConfigSpecWrapper _spec;
    protected final Map<String, Object> _cache = new HashMap<String, Object>(71);
    private final Map<String, Object> _builderContext = new HashMap<String, Object>();

    private void setUiLang(IModInfo modinfo) {
        String mnemonic = modinfo.itemid_prefix();
        if (mnemonic.isEmpty()) {
            mnemonic = modinfo.mod_id();
        } else if (mnemonic.endsWith("_")) {
            mnemonic = mnemonic.substring(0, mnemonic.length() - 1);
        }
        this.I18N = "gui." + mnemonic + ".config.";
    }

    public static final Path getDefaultFile(IModInfo modinfo) {
        return FMLPaths.CONFIGDIR.get().resolve("wabbity_" + modinfo.mod_id() + ".toml");
    }

    protected ModConfigBase(@Nonnull IModInfo modinfo) {
        this._modinfo = modinfo;
        this.setUiLang(modinfo);
        ConfigSpecWrapper wrapper = ConfigSpecWrapper.create(ModConfigBase.getDefaultFile(modinfo));
        this.fullyDefine(modinfo.config_version(), wrapper);
        this.validateVersion(modinfo);
        this._loaded = true;
    }

    @Override
    public boolean isLoaded() {
        return this._loaded;
    }

    @Override
    public void changed() {
    }

    public final boolean isUpsizerPresent() {
        return ModIntegration.UPSIZER.isLoaded();
    }

    public final boolean isVanillaFoodPantryPresent() {
        return ModIntegration.VANILLA_FOODPANTRY.isLoaded();
    }

    public final boolean isExtendedFoodPantryPresent() {
        return ModIntegration.EXTENDED_FOODPANTRY.isLoaded();
    }

    public final boolean isSuperBlocksPresent() {
        return ModIntegration.SUPERBLOCKS.isLoaded();
    }

    public final boolean isSmartHoppersPresent() {
        return ModIntegration.SMARTHOPPERS.isLoaded();
    }

    public final boolean isArmorUnderwearPresent() {
        return ModIntegration.ARMOR_UNDERWEAR.isLoaded();
    }

    public final boolean isPinklySheepPresent() {
        return ModIntegration.PINKLYSHEEP.isLoaded();
    }

    protected final String i18n(Option option) {
        return this.I18N + option.NAME;
    }

    protected static final boolean _getBooleanOrDefault(@Nullable String config_value, boolean default_value) {
        Boolean b = null;
        if (Strings.isDefaultValue(config_value)) {
            b = default_value;
        } else {
            b = BooleanUtils.toBooleanObject((String)config_value);
            if (b == null) {
                b = default_value;
            }
        }
        return b;
    }

    protected static final int _getIntegerOrDefault(@Nullable String config_value, int default_value) {
        Integer i = null;
        i = Strings.isDefaultValue(config_value) ? Integer.valueOf(default_value) : Integer.valueOf(NumberUtils.toInt((String)config_value, (int)default_value));
        return i;
    }

    protected static final ResourceLocation[] _asResourceLocations(@Nonnull String[] config_values) {
        ArrayList<ResourceLocation> values = new ArrayList<ResourceLocation>();
        for (String id : config_values) {
            ResourceLocation r;
            String s = StringUtils.trimToNull((String)id);
            if (s == null || (r = ResourceLocation.func_208304_a((String)s)) == null) continue;
            values.add(r);
        }
        return values.isEmpty() ? _NO_RESOURCE_IDS : values.toArray(_NO_RESOURCE_IDS);
    }

    protected static final Set<ResourceLocation> _asResourceLocations(@Nonnull Collection<? extends String> config_values) {
        return config_values.stream().map(s -> ResourceLocation.func_208304_a((String)s)).filter(r -> r != null).collect(Collectors.toSet());
    }

    public final Map<String, Object> builderContext() {
        return this._builderContext;
    }

    @Override
    public boolean isAllowed(@Nonnull String option, boolean defaultValue) {
        Boolean placeholder = BooleanUtils.toBooleanObject((String)option);
        return placeholder != null ? placeholder : defaultValue;
    }

    @Override
    public boolean isPresent(@Nonnull String feature) {
        return Boolean.TRUE.equals(this._builderContext.get(feature + ".present"));
    }

    public void setPresent(@Nonnull String feature) {
        if (StringUtils.trimToNull((String)feature) != null) {
            this._builderContext.put(feature + ".present", true);
        }
    }

    public void setNotPresent(@Nonnull String feature) {
        this._builderContext.remove(feature + ".present");
        this._builderContext.remove(feature + ".tag");
    }

    @Nullable
    public String getPresentAs(@Nonnull String feature) {
        Object value = this._builderContext.get(feature + ".tag");
        return value == null ? null : String.valueOf(value);
    }

    public void setPresentAs(String feature, String as) {
        this._builderContext.put(feature + ".present", true);
        this._builderContext.put(feature + ".tag", as);
    }

    protected final void setRecipeFlag(boolean b, String recipe_id) {
        if (b) {
            this.setPresent(recipe_id);
        } else {
            this.setNotPresent(recipe_id);
        }
    }

    public final void captureContextTags() {
        List tags = ItemTags.func_199903_a().func_199908_a().stream().collect(Collectors.mapping(t -> t.toString(), Collectors.toList()));
        this._builderContext.put("__tags", tags);
    }

    public final List<String> capturedContextTags() {
        List tags = (List)List.class.cast(this._builderContext.get("__tags"));
        return tags != null ? tags : Collections.EMPTY_LIST;
    }

    protected final boolean isDefined(ConfigValue<?> cv) {
        try {
            return cv != null && cv.get() != null;
        }
        catch (Throwable igX) {
            return false;
        }
    }

    protected void fullyDefineInternal() {
    }

    public void setRecipeFlagsEarly() {
        this.setRecipeFlag(this.isDebugMode(), "debug_mode");
        this.setRecipeFlag(this.isSuperCompatibilityMode(), "compat_mode");
    }

    protected void fullyDefine(String currentVersion, @Nonnull ConfigSpecWrapper wrapper) {
        LibInfo.LOG.debug("Config definition (S) for {}", (Object)this._modinfo.mod_id());
        this._spec = wrapper;
        this._cache.clear();
        try {
            this.fullyDefineInternal();
            wrapper.doublevalidate();
        }
        finally {
            this._spec = null;
        }
        LibInfo.LOG.debug("Config definition (E) for {}", (Object)this._modinfo.mod_id());
    }

    protected void validateVersion(IModInfo mod) {
    }

    public static class Option<T, CV extends ConfigValue<T>> {
        public final String NAME;
        public final String PROPERTY;
        public final T DFLT;
        public CV val = null;

        public Option(@Nonnull String n, @Nonnull String prefix, @Nonnull T ini) {
            this.NAME = n;
            this.PROPERTY = prefix + n;
            this.DFLT = ini;
        }

        public final T value() {
            return (T)(this.val != null ? ((ConfigValue)this.val).get() : this.DFLT);
        }
    }
}

