/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.recipes.JR;

public final class TagSupport {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<ResourceLocation, Collection<String>> BLOCKS = new ConcurrentHashMap<ResourceLocation, Collection<String>>();
    private static final Map<ResourceLocation, Collection<String>> ITEMS = new ConcurrentHashMap<ResourceLocation, Collection<String>>();
    private static final File TAGS_DIR = new File("C:/Temp/JT");

    public static Tag<Block> block(ResourceLocation tag, Block block) {
        return TagSupport.block(tag, Objects.requireNonNull(block.getRegistryName()).toString());
    }

    public static Tag<Block> block(ResourceLocation tag, String value) {
        Collection<String> blocks = TagSupport.getBlocks(tag);
        blocks.add(value);
        return new BlockTags.Wrapper(tag);
    }

    public static Tag<Block> block(ResourceLocation tag, String first, String ... rest) {
        Collection<String> blocks = TagSupport.getBlocks(tag);
        blocks.add(first);
        blocks.addAll(Arrays.asList(rest));
        return new BlockTags.Wrapper(tag);
    }

    public static Tag<Item> item(ResourceLocation tag, Item item) {
        return TagSupport.item(tag, Objects.requireNonNull(item.getRegistryName()).toString());
    }

    public static Tag<Item> item(ResourceLocation tag, String value) {
        Collection<String> items = TagSupport.getItems(tag);
        items.add(value);
        return new ItemTags.Wrapper(tag);
    }

    public static Tag<Item> item(ResourceLocation tag, String first, String ... rest) {
        Collection<String> items = TagSupport.getItems(tag);
        items.add(first);
        items.addAll(Arrays.asList(rest));
        return new ItemTags.Wrapper(tag);
    }

    private static Collection<String> getBlocks(ResourceLocation tag) {
        if (!BLOCKS.containsKey(tag)) {
            BLOCKS.put(tag, new HashSet());
        }
        return BLOCKS.get(tag);
    }

    private static Collection<String> getItems(ResourceLocation tag) {
        if (!ITEMS.containsKey(tag)) {
            ITEMS.put(tag, new HashSet());
        }
        return ITEMS.get(tag);
    }

    private static File getModDir(JR.ModDef mod) {
        File modDir = new File(new File(TAGS_DIR, mod.modid), mod.stamp);
        if (!modDir.exists() && !modDir.mkdirs()) {
            throw new RuntimeException("Cannot mkdir " + modDir);
        }
        return modDir;
    }

    public static void generateFiles(JR.ModDef mod) {
        File directory = TagSupport.getModDir(mod);
        BLOCKS.forEach((tag, blocks) -> TagSupport.writeFile(directory, tag, "blocks", blocks));
        ITEMS.forEach((tag, items) -> TagSupport.writeFile(directory, tag, "items", items));
        TagSupport.clear(mod.modid);
    }

    public static void generateFiles(String modid) {
        JR.ModDef mod = JR.setCurrentMod(modid);
        try {
            TagSupport.generateFiles(mod);
        }
        finally {
            JR.clrCurrentMod();
        }
    }

    public static void clear(String modid) {
        BLOCKS.clear();
        ITEMS.clear();
    }

    private static JsonObject getJson(Iterable<String> values) {
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(false));
        JsonArray array = new JsonArray();
        values.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add("values", (JsonElement)array);
        return json;
    }

    private static void writeFile(File topdir, ResourceLocation tag, String subDir, Collection<String> things) {
        String subdir = "data/" + tag.func_110624_b() + "/tags/" + subDir + "/" + tag.func_110623_a() + ".json";
        File output = new File(topdir, subdir);
        File in = output.getParentFile();
        if (!in.exists() && !in.mkdirs()) {
            System.err.println("Could not create directory: " + in.getAbsolutePath());
            return;
        }
        Collection sorted_things = things.stream().sorted().collect(Collectors.toList());
        try (FileWriter writer = new FileWriter(output);){
            JsonObject json = TagSupport.getJson(sorted_things);
            JsonWriter w = GSON.newJsonWriter(Streams.writerForAppendable((Appendable)writer));
            w.setIndent(" ");
            GSON.toJson((JsonElement)json, w);
            System.out.println("Wrote tag file " + output.getAbsolutePath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

