/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.ToolItem;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.IModItem;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;

public abstract class ToolItemBase
extends ToolItem
implements IModItem {
    protected static final Set<Block> _NO_TARGET_BLOCKS = Collections.EMPTY_SET;
    @Nonnull
    protected final String _oid;
    protected String _gid = "";
    protected boolean _hidden = false;
    @Nullable
    protected Rarity _rarity = null;
    private String _i18n;

    @Nonnull
    public static Item.Properties defaultproperties(@Nullable Item.Properties ip, boolean hidden) {
        return ip != null ? ip : new Item.Properties().func_200916_a(hidden ? null : ItemGroup.field_78040_i);
    }

    protected ToolItemBase(String oid, float toolDamage, float toolSpeed, IItemTier material, boolean hidden, Set<Block> naturalTargetBlocks, Item.Properties ip) {
        super(toolDamage, toolSpeed, material, naturalTargetBlocks, ToolItemBase.defaultproperties(ip, hidden));
        this._oid = Objects.requireNonNull(oid, "Non-null oid required");
        this._hidden = hidden;
    }

    protected ToolItemBase(String oid, IItemTier material, Item.Properties ip) {
        this(oid, 0.5f, -2.0f, material, false, _NO_TARGET_BLOCKS, ip);
    }

    @Override
    public String oid() {
        return this._oid;
    }

    @Override
    public String gid(Object unused) {
        return this._gid;
    }

    @Override
    public <T> T inGroup(@Nullable String gid) {
        this._gid = gid == null ? "" : gid;
        return (T)this;
    }

    public final int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    protected String func_195935_o() {
        if (this._i18n == null) {
            this._i18n = ItemSupport.defaultTranslationKey((Item)this);
        }
        return this._i18n;
    }

    @Override
    public int getBurnTime(ItemStack stack) {
        return IModItem.super.getBurnTime(stack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        Rarity r = super.func_77613_e(stack);
        return this._rarity != null && this._rarity.ordinal() > r.ordinal() ? this._rarity : r;
    }

    public final ToolItemBase setRarity(@Nullable Rarity rarity) {
        this._rarity = rarity;
        return this;
    }

    protected final void setUsed(ItemStack stack, int count) {
        super.setDamage(stack, count);
    }

    protected static final boolean isPristine(ItemStack stack, Item reference) {
        return ItemSupport.isPristine(stack, reference);
    }

    protected void addEndemicEnchantments(ItemStack tool) {
    }

    @Override
    public ItemStack createInstance(Item item, int amount) {
        ItemStack tool = IModItem.super.createInstance(item, amount);
        this.addEndemicEnchantments(tool);
        return tool;
    }

    public void func_77622_d(ItemStack tool, World world, PlayerEntity player) {
        Item item = tool.func_77973_b();
        if (item == this && !tool.func_77948_v()) {
            this.addEndemicEnchantments(tool);
        }
    }

    protected boolean canCraftWith(ItemStack tool) {
        return false;
    }

    public boolean hasContainerItem(ItemStack tool) {
        return this.canCraftWith(tool);
    }

    public ItemStack getContainerItem(ItemStack original) {
        int damage;
        ItemStack output = ItemStack.field_190927_a;
        if (this.canCraftWith(original) && (damage = original.func_77952_i()) < original.func_77958_k()) {
            output = ItemStacks.copy1(original);
            output.func_196085_b(damage + 1);
        }
        return output;
    }

    @Override
    public boolean isHiddenByDefault() {
        return this._hidden;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.isHiddenByDefault() && this.func_194125_a(tab)) {
            items.add((Object)this.createInstance((Item)this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (this.isShowingUiTips(stack)) {
            Tooltips.addDocTipDefault(stack, tooltip);
        }
        super.func_77624_a(stack, world, tooltip, flags);
    }
}

