/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.block;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.ILuckAffected;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.api.LightLevel;
import org.jwaresoftware.mcmods.lib.api.LightLevelProperty;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.loot.Loot;

public class BlockSupport {
    private static Field _hardnessField = null;
    private static Field _resistanceField = null;
    private static Field _soundTypeField = null;
    private static Method _validGroundMethod = null;
    public static final IntegerProperty PLUS_LIGHTING_NUM;
    public static final LightLevelProperty PLUS_LIGHTING;
    private static final int _RADIUS = 3;

    protected BlockSupport() {
    }

    public static LootContext lootcontext(BlockState state, LootContext.Builder builder) {
        return builder.func_216015_a(LootParameters.field_216287_g, (Object)state).func_216022_a(LootParameterSets.field_216267_h);
    }

    public static final Block.Properties blockproperties(Material m, @Nullable MaterialColor c) {
        return Block.Properties.func_200949_a((Material)(m == null ? SharedGlue.Material_rock : m), (MaterialColor)(c == null ? (m != null ? m.func_151565_r() : SharedGlue.Material_rock.func_151565_r()) : c));
    }

    public static final Block.Properties blockproperties(Block likeBlock, Material withMaterial) {
        Builder bb = new Builder(likeBlock);
        return bb.material(withMaterial).build();
    }

    public static final Block.Properties blockproperties(Block likeBlock) {
        Builder bb = new Builder(likeBlock);
        return bb.build();
    }

    public static final void initAmendmentSupport() {
    }

    public static final <T extends Block> T setHardness(@Nonnull T block, float value) {
        if (_hardnessField != null) {
            try {
                _hardnessField.setFloat(block, value);
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Could not set block hardness of {} to {}", (Object)Strings.safe(block, "u/d"), (Object)Float.valueOf(value));
            }
        }
        return block;
    }

    public static final float getHardness(@Nonnull Block block, float fallback) {
        if (_hardnessField != null) {
            try {
                return _hardnessField.getFloat(block);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return fallback;
    }

    public static final <T extends Block> T setResistance(@Nonnull T block, float value) {
        if (_resistanceField != null) {
            try {
                _resistanceField.setFloat(block, value);
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Could not set resistance of {} to {}", (Object)Strings.safe(block, "u/d"), (Object)Float.valueOf(value));
            }
        }
        return block;
    }

    public static final float getResistance(@Nonnull Block block, float fallback) {
        if (_resistanceField != null) {
            try {
                return _resistanceField.getFloat(block);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return fallback;
    }

    public static final <T extends Block> T setSoundType(@Nonnull T block, SoundType value) {
        if (_soundTypeField != null) {
            try {
                _soundTypeField.set(block, value);
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Could not set soundType of {} to {}", (Object)Strings.safe(block, "u/d"), (Object)value);
            }
        }
        return block;
    }

    public static final boolean isSideSolid(BlockXyz xyz, Direction direction) {
        return xyz.state.func_224755_d((IBlockReader)xyz.worldr, xyz.pos, direction);
    }

    @Nullable
    public static final Boolean isValidGround(BushBlock target, BlockState state, IBlockReader worldr, BlockPos pos) {
        if (_validGroundMethod != null) {
            try {
                return (Boolean)_validGroundMethod.invoke((Object)target, state, worldr, pos);
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Could not call isValidGround for {} at {}", (Object)state, (Object)pos);
            }
        }
        return null;
    }

    public static final int clampLightLevel(int ll) {
        return ll < 0 ? 0 : (ll > SharedGlue.MAX_LIGHT_LEVEL() ? SharedGlue.MAX_LIGHT_LEVEL() : ll);
    }

    @ParametersAreNonnullByDefault
    public static final boolean onApplyPlusLighting(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, @Nonnull Item giveback) {
        boolean processed = false;
        if (state.func_196959_b((IProperty)PLUS_LIGHTING)) {
            ItemStack heldItem = player.func_184586_b(hand);
            LightLevel ll = (LightLevel)((Object)state.func_177229_b((IProperty)PLUS_LIGHTING));
            if (heldItem.func_190926_b()) {
                if (player.func_70093_af() && ll != LightLevel.OFF) {
                    player.func_184609_a(hand);
                    if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                        world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)PLUS_LIGHTING, (Comparable)((Object)ll.decrease())));
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)ItemStacks.create(giveback), (int)player.field_71071_by.field_70461_c);
                    }
                    processed = true;
                }
            } else if (state.func_177230_c().getLightValue(state, (IEnviromentBlockReader)world, pos) < SharedGlue.MAX_LIGHT_LEVEL() && heldItem.func_77973_b() == giveback) {
                player.func_184609_a(hand);
                if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                    world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)PLUS_LIGHTING, (Comparable)((Object)ll.increase())));
                    ItemSupport.addUsedStat(player, heldItem);
                    if (SharedGlue.getPlayerInSurvival(player)) {
                        SharedGlue.usedItem(player, heldItem);
                    }
                }
                processed = true;
            }
        }
        return processed;
    }

    @ParametersAreNonnullByDefault
    public static final boolean onApplyPlusLighting(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand) {
        return BlockSupport.onApplyPlusLighting(state, world, pos, player, hand, Items.field_151114_aO);
    }

    public static final boolean checkSomethingThatICantFigureOut(IWorldReader worldr, BlockPos at, BlockState state) {
        BlockPos up = at.func_177984_a();
        BlockState above = worldr.func_180495_p(up);
        if (above.func_177230_c() == Blocks.field_150433_aE && (Integer)above.func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        int i = LightEngine.func_215613_a((IBlockReader)worldr, (BlockState)state, (BlockPos)at, (BlockState)above, (BlockPos)up, (Direction)Direction.UP, (int)above.func_200016_a((IBlockReader)worldr, up));
        return i < worldr.func_201572_C();
    }

    public static boolean spreadConditionally(World world, BlockPos pos, BlockState state, int minLightLevel, Random rand, BlockXyz.Supplier<BlockState> block_selector) {
        int spread = 0;
        if (world.isAreaLoaded(pos, 3) && world.func_201696_r(pos.func_177984_a()) >= minLightLevel) {
            if (rand == null) {
                rand = world.func_201674_k();
            }
            BlockXyz xyz = new BlockXyz((IWorldReader)world);
            for (int i = 0; i < 4; ++i) {
                BlockPos checkpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                xyz.set(checkpos);
                BlockState current = xyz.state;
                BlockState to_spread = block_selector.get(xyz);
                if (to_spread == null || to_spread == current || !BlockSupport.checkSomethingThatICantFigureOut((IWorldReader)world, checkpos, to_spread)) continue;
                world.func_175656_a(checkpos, to_spread);
                ++spread;
            }
        }
        return spread > 0;
    }

    @Nonnull
    public static final List<ItemStack> getBlockDrops(BlockState state, LootContext.Builder builder, boolean allowFortune) {
        ItemStack drop;
        Validate.validState((boolean)(state.func_177230_c() instanceof IModBlock), (String)"IModBlock is required - given %s", (Object[])new Object[]{state});
        IModBlock block = (IModBlock)state.func_177230_c();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(3);
        LootContext lc = builder.func_216015_a(LootParameters.field_216287_g, (Object)state).func_216022_a(LootParameterSets.field_216267_h);
        if (Loot.isSilkTouched(lc)) {
            drop = block.createInstance(state);
        } else {
            int fortune = 0;
            if (block instanceof ILuckAffected) {
                fortune = ((ILuckAffected)((Object)block)).getBetterFortuneOrLuck(lc);
            } else if (allowFortune) {
                fortune = Loot.getBonus(lc, SharedGlue.Enchantment_fortune, null);
            }
            drop = ItemStacks.safe(block.getItemDropped(state, lc.func_216032_b(), fortune));
        }
        Loot.applyExplosion(drop, lc);
        if (!drop.func_190926_b()) {
            drops.add(drop);
        }
        return drops;
    }

    static {
        try {
            _hardnessField = ObfuscationReflectionHelper.findField(Block.class, (String)"field_149782_v");
            _resistanceField = ObfuscationReflectionHelper.findField(Block.class, (String)"field_149781_w");
            _soundTypeField = ObfuscationReflectionHelper.findField(Block.class, (String)"field_149762_H");
        }
        catch (Throwable igX) {
            LibInfo.LOG.error("Unable to init BlockSupport field setters for hardness,resistance,sound?");
        }
        try {
            _validGroundMethod = ObfuscationReflectionHelper.findMethod(BushBlock.class, (String)"func_200014_a_", (Class[])new Class[]{BlockState.class, IBlockReader.class, BlockPos.class});
        }
        catch (Throwable igX) {
            LibInfo.LOG.error("Unable to init BlockSupport method invokers for BushBlock.isValidGround?");
        }
        PLUS_LIGHTING_NUM = IntegerProperty.func_177719_a((String)"lightplus", (int)0, (int)SharedGlue.MAX_LIGHT_LEVEL());
        PLUS_LIGHTING = LightLevelProperty.create("lightplus", LightLevel.OFF, LightLevel.LOW, LightLevel.MEDIUM, LightLevel.FULL);
    }

    public static final class Builder {
        private final Block.Properties _bp;
        private Material _material = null;
        private MaterialColor _map_color = null;
        private Float _hardness = null;
        private Float _resistance = null;
        private Boolean _blocks_movement = null;

        public Builder(Block like) {
            this._bp = Block.Properties.func_200950_a((Block)like);
        }

        public Builder(@Nonnull Block.Properties base) {
            this._bp = base;
        }

        public Builder(Material m, @Nullable MaterialColor c) {
            this._bp = BlockSupport.blockproperties(m, c);
        }

        public Builder material(Material m) {
            this._material = m;
            return this;
        }

        public Builder mapColor(MaterialColor c) {
            this._map_color = c;
            return this;
        }

        public Builder hardnessAndResistance(float hr) {
            this._bp.func_200943_b(hr);
            return this;
        }

        public Builder hardness(float hardness) {
            this._hardness = Float.valueOf(hardness);
            return this;
        }

        public Builder resistance(float resistance) {
            this._resistance = Float.valueOf(resistance);
            return this;
        }

        public Builder blocksMovement(boolean b) {
            this._blocks_movement = b;
            return this;
        }

        public Builder harvestLevel(int harvestLevel) {
            this._bp.harvestLevel(harvestLevel);
            return this;
        }

        public Builder harvestTool(ToolType harvestTool) {
            this._bp.harvestTool(harvestTool);
            return this;
        }

        public final Block.Properties build() {
            this.chg_material();
            this.chg_map_color();
            this.chg_blocks_movement();
            this.chg_hardnessOrResistance();
            return this._bp;
        }

        private void chg_material() {
            if (this._material != null) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Block.Properties.class, (Object)this._bp, (Object)this._material, (String)"field_200953_a");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void chg_map_color() {
            if (this._map_color != null) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Block.Properties.class, (Object)this._bp, (Object)this._map_color, (String)"field_200954_b");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void chg_hardnessOrResistance() {
            if (this._hardness != null) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Block.Properties.class, (Object)this._bp, (Object)this._hardness, (String)"field_200959_g");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this._resistance != null) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Block.Properties.class, (Object)this._bp, (Object)this._resistance, (String)"field_200958_f");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void chg_blocks_movement() {
            if (this._blocks_movement != null) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Block.Properties.class, (Object)this._bp, (Object)this._blocks_movement, (String)"field_200955_c");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

