/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.block;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.block.ItemBlockBase;

public class StairsBlockBase
extends StairsBlock
implements IModBlock {
    protected final String _oid;
    protected boolean _hidden;
    private String _i18n = "";

    public StairsBlockBase(@Nonnull String oid, @Nonnull BlockState like, @Nullable Block.Properties p, boolean hidden) {
        super(like, p != null ? p : Block.Properties.func_200950_a((Block)like.func_177230_c()));
        this._oid = Objects.requireNonNull(oid, "Non-null oid required");
        this._hidden = hidden;
    }

    public StairsBlockBase(@Nonnull String oid, @Nonnull Block like, boolean hidden) {
        this(oid, like.func_176223_P(), Block.Properties.func_200950_a((Block)like), hidden);
    }

    @Override
    @Nonnull
    public final String oid() {
        return this._oid;
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        if (this._i18n.isEmpty()) {
            this._i18n = ItemSupport.defaultTranslationKey((Block)this);
        }
        return this._i18n;
    }

    public final String func_149739_a() {
        return this.getTranslationKey(ItemStack.field_190927_a);
    }

    @Override
    public BlockItem makeItemBlock(@Nonnull Block thisblock, @Nullable Item.Properties ip) {
        return new ItemBlockBase(thisblock, ip);
    }

    public boolean isHiddenByDefault() {
        return this._hidden;
    }

    public void func_149666_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (!this.isHiddenByDefault() || tab == SharedGlue.CreativeTabs_search) {
            super.func_149666_a(tab, list);
        }
    }
}

