/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jwaresoftware.mcmods.lib.Fluids;

public final class MilkBucketWrapper
extends FluidBucketWrapper {
    public MilkBucketWrapper(@Nonnull ItemStack bucket) {
        super(bucket);
    }

    public FluidStack getFluid() {
        Item item = this.container.func_77973_b();
        return item == Items.field_151117_aB && Fluids.MILK != null ? Fluids.bucketOf((Fluid)Fluids.MILK) : FluidStack.EMPTY;
    }

    protected void setFluid(@Nonnull FluidStack fluid) {
        this.container = !Fluids.isCowMilk(fluid) ? new ItemStack((IItemProvider)Items.field_151133_ar) : new ItemStack((IItemProvider)Items.field_151117_aB);
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return Fluids.MILK != null && Fluids.isCowMilk(fluid);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack fluid) {
        return Fluids.isCowMilk(fluid);
    }

    public int fill(FluidStack supplied, IFluidHandler.FluidAction action) {
        if (this.container.func_190916_E() != 1 || supplied.getAmount() < 1000 || !this.getFluid().isEmpty() || !this.canFillFluidType(supplied)) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(supplied);
        }
        return 1000;
    }
}

