/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.impl.ItemBase;
import org.jwaresoftware.mcmods.lib.impl.fluid.BucketProperties;
import org.jwaresoftware.mcmods.lib.impl.fluid.PortionedItemStackFluidHandler;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalBucketItem;

public class UniversalBottleItem
extends ItemBase
implements IMultiColored {
    @Nonnull
    protected final Predicate<FluidStack> _allowFluid;
    private Supplier<Item> _fliptBottle;
    private Supplier<ItemStack> _emptyBottle;

    public UniversalBottleItem(String oid, boolean hidden, @Nonnull BucketProperties bp) {
        super(oid, hidden, bp);
        this._allowFluid = bp._allowFluid != null ? bp._allowFluid : PortionedItemStackFluidHandler.IS_JARABLE_FLUID;
        this._fliptBottle = bp._fliptBucket != null ? bp._fliptBucket : () -> this;
        this._emptyBottle = bp._emptyBucket != null ? bp._emptyBucket : () -> new ItemStack((IItemProvider)this);
    }

    @Nonnull
    public static final Fluid getFluidHeld(ItemStack container) {
        Fluid f = Fluids.NO_FLUID;
        if (!container.func_190926_b() && container.func_77973_b() instanceof UniversalBottleItem) {
            UniversalBottleItem ub = (UniversalBottleItem)container.func_77973_b();
            f = ub.getFluid(container).getFluid();
        }
        return f;
    }

    public final int getCapacity() {
        return 250;
    }

    @Nonnull
    public FluidStack getFluid(@Nonnull ItemStack bottle) {
        return ItemStacks.isEmpty(bottle) ? FluidStack.EMPTY : Fluids.getBucketFluid(bottle);
    }

    @Nonnull
    public ItemStack getEmptyContainer() {
        return this._emptyBottle.get();
    }

    public final boolean isFull(ItemStack bottle) {
        return this.getFluid(bottle).getAmount() > 0;
    }

    public final boolean isEmpty(ItemStack bottle) {
        return this.getEmptyContainer().func_190926_b() || !this.isFull(bottle);
    }

    public boolean hasContainerItem(ItemStack bottle) {
        return !this.isEmpty(bottle);
    }

    @Nonnull
    public ItemStack getContainerItem(ItemStack bottle) {
        return this.isEmpty(bottle) ? ItemStack.field_190927_a : ItemStacks.copy1(this.getEmptyContainer());
    }

    @Override
    public int getColorFrom(ItemStack bottle, int tintIndex) {
        return tintIndex <= 0 ? UniversalBucketItem.getColorFrom(this.getFluid(bottle)) : 0xFFFFFF;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack bottle, CompoundNBT nbt) {
        return new PortionedItemStackFluidHandler(bottle, this._fliptBottle.get(), 250, 250, this.isEmpty(bottle), this._allowFluid);
    }

    @Nullable
    protected ItemStack getWaterFilledContainerItem(World world, BlockPos blockpos, PlayerEntity player, ItemStack held) {
        if (this.isEmpty(held)) {
            IFluidHandlerItem fH = ItemStacks.getFluidHandler(held);
            FluidStack water = new FluidStack((Fluid)Fluids.water(), this.getCapacity());
            if (fH != null && fH.fill(water, IFluidHandler.FluidAction.EXECUTE) == this.getCapacity()) {
                Effects.playBottleOfWaterScoopedUp(world, player);
                return fH.getContainer();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        ActionResult result = ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)held);
        if (ItemStacks.isEmpty(held) || held.func_77973_b() != this || !this.isEmpty(held)) {
            return result;
        }
        RayTraceResult hit = UniversalBottleItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (hit != null && hit.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockhit = (BlockRayTraceResult)hit;
            BlockPos blockpos = blockhit.func_216350_a();
            if (!world.func_175660_a(player, blockpos)) {
                return result;
            }
            if (Fluids.IsWater.source_block(world.func_180495_p(blockpos))) {
                ItemStack filledItem = this.getWaterFilledContainerItem(world, blockpos, player, held);
                if (ItemStacks.isEmpty(filledItem)) {
                    return ActionResult.newResult((ActionResultType)ActionResultType.FAIL, (Object)held);
                }
                this.addUsedStat(player);
                if (ItemStacks.decrBy(held, 1)) {
                    return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)filledItem);
                }
                if (!player.field_71071_by.func_70441_a(filledItem)) {
                    player.func_71019_a(filledItem, false);
                }
            }
        }
        return result;
    }
}

