/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.jwaresoftware.mcmods.lib.Enchants;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.loot.EnchantCompatibleFunction;

public final class EnchantRandomFunction
extends EnchantCompatibleFunction {
    @Nullable
    final EnchantCompatibleFunction.Profile _profile;
    final boolean _stripCurses;
    final boolean _allowTreasure;
    final boolean _sillyFlag;
    final boolean _reTitle;
    final Float _luckMultiplier;

    public EnchantRandomFunction(ILootCondition[] conditions, @Nullable EnchantCompatibleFunction.Profile profile, boolean strip, boolean treasure, boolean retitle, boolean silly, Float luckmultiplier) {
        super(conditions);
        this._profile = profile;
        this._stripCurses = strip;
        this._allowTreasure = treasure;
        this._reTitle = retitle;
        this._sillyFlag = silly;
        this._luckMultiplier = luckmultiplier;
    }

    private void adjustForLuck(EnchantmentData pick, @Nonnull Random rand, LootContext context) {
        Enchantment e;
        if (pick != null && this._luckMultiplier != null && (e = pick.field_76302_b).func_77319_d() < e.func_77325_b()) {
            int l;
            int delta;
            float luck = context.func_186491_f();
            int n = luck > 0.0f ? 1 : (delta = luck < 0.0f ? -1 : 0);
            if (delta != 0 && rand.nextFloat() < 0.1f + Math.abs(luck) * this._luckMultiplier.floatValue() && (l = pick.field_76303_c + delta) >= pick.field_76302_b.func_77319_d() && l <= pick.field_76302_b.func_77325_b()) {
                pick = new EnchantmentData(pick.field_76302_b, l);
            }
        }
    }

    @Nullable
    private EnchantmentData nextEnchantment(ItemStack in, boolean isBook, @Nonnull Random rand, LootContext context) {
        EnchantmentData pick = null;
        ItemStack use = in;
        if (isBook) {
            use = this._profile != null ? EnchantCompatibleFunction.Profile.example(this._profile, rand) : new ItemStack((IItemProvider)Items.field_151122_aG);
            pick = Enchants.getRandom(use, !this._stripCurses, this._allowTreasure, rand, this._stripCurses, 3);
        } else {
            List<Enchantment> alt;
            pick = Enchants.getRandom(use, !this._stripCurses, this._allowTreasure, rand, true, -1);
            if (pick == null && (alt = EnchantRandomFunction.getSpecialItemsEnchantments(in, this._sillyFlag)) != null) {
                pick = Enchants.getRandom(alt.get(rand.nextInt(alt.size())), rand);
            }
        }
        this.adjustForLuck(pick, rand, context);
        return pick;
    }

    public ItemStack func_215859_a(ItemStack in, LootContext context) {
        ItemStack out = in;
        boolean isBook = Whatis.isBlankBook(in.func_77973_b());
        EnchantmentData edata = this.nextEnchantment(in, isBook, context.func_216032_b(), context);
        if (edata != null) {
            if (isBook) {
                out = new ItemStack((IItemProvider)Items.field_151134_bR);
                EnchantedBookItem.func_92115_a((ItemStack)out, (EnchantmentData)edata);
                if (this._reTitle) {
                    EnchantCompatibleFunction.Profile.reTitle(out, this._profile);
                }
            } else {
                out.func_77966_a(edata.field_76302_b, edata.field_76303_c);
            }
        }
        return out;
    }

    public static class Serializer
    extends EnchantCompatibleFunction.Serializer<EnchantRandomFunction> {
        private static final String _LUCK_MULT = "luck_multiplier";

        public Serializer() {
            super(new ResourceLocation(LibInfo.MOD_ID(), "random_enchant"), EnchantRandomFunction.class);
        }

        public EnchantRandomFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            EnchantCompatibleFunction.Profile profile = EnchantCompatibleFunction.Profile.fromLString(JSONUtils.func_151219_a((JsonObject)object, (String)"profile", null));
            boolean retitleFlag = JSONUtils.func_151209_a((JsonObject)object, (String)"retitle", (boolean)false);
            boolean stripFlag = JSONUtils.func_151209_a((JsonObject)object, (String)"varnish", (boolean)false);
            boolean treasureFlag = JSONUtils.func_151209_a((JsonObject)object, (String)"treasure", (boolean)true);
            boolean silly_stick = JSONUtils.func_151209_a((JsonObject)object, (String)"silly", (boolean)false);
            Float lm = null;
            if (object.has(_LUCK_MULT)) {
                lm = Float.valueOf(JSONUtils.func_151217_k((JsonObject)object, (String)_LUCK_MULT));
            }
            return new EnchantRandomFunction(conditions, profile, stripFlag, treasureFlag, retitleFlag, silly_stick, lm);
        }

        public void serialize(JsonObject object, EnchantRandomFunction lfunction, JsonSerializationContext serializationContext) {
            if (lfunction._profile != null && lfunction._profile != EnchantCompatibleFunction.Profile.BOOK) {
                String profile = EnchantCompatibleFunction.Profile.toLString(lfunction._profile);
                object.add("profile", serializationContext.serialize((Object)profile));
            }
            if (lfunction._sillyFlag) {
                object.add("silly", serializationContext.serialize((Object)true));
            }
            if (!lfunction._allowTreasure) {
                object.add("treasure", serializationContext.serialize((Object)false));
            }
            if (lfunction._stripCurses) {
                object.add("varnish", serializationContext.serialize((Object)true));
            }
            if (lfunction._reTitle) {
                object.add("retitle", serializationContext.serialize((Object)true));
            }
            if (lfunction._luckMultiplier != null) {
                object.addProperty(_LUCK_MULT, (Number)Float.valueOf(lfunction._luckMultiplier.floatValue()));
            }
        }
    }
}

