/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.BiomeDictionary;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Locations;

public final class IfEntityInBiomeOfTypeCondition
implements ILootCondition {
    @Nonnull
    final LootContext.EntityTarget _target_locked;
    @Nonnull
    final BiomeDictionary.Type[] _biomeTypes;

    public IfEntityInBiomeOfTypeCondition(@Nullable LootContext.EntityTarget target, @Nonnull String[] typeids) {
        Collection ALL = BiomeDictionary.Type.getAll();
        this._target_locked = target != null ? target : LootContext.EntityTarget.THIS;
        this._biomeTypes = new BiomeDictionary.Type[typeids.length];
        for (int i = 0; i < typeids.length; ++i) {
            BiomeDictionary.Type match = null;
            String name = typeids[i].toUpperCase(Locale.ROOT);
            for (BiomeDictionary.Type t : ALL) {
                if (!Objects.equals(t.getName(), name)) continue;
                match = t;
                break;
            }
            if (match == null) {
                throw new JsonSyntaxException("Unable to find biome type: '" + typeids[i] + "'");
            }
            this._biomeTypes[i] = match;
        }
    }

    public IfEntityInBiomeOfTypeCondition(String ... typeids) {
        this((LootContext.EntityTarget)null, typeids);
    }

    public boolean test(LootContext context) {
        Biome biome;
        Entity target = (Entity)context.func_216031_c(this._target_locked.func_216029_a());
        return target != null && (biome = target.func_130014_f_().func_180494_b(target.func_180425_c())) != null && Locations.isBiomeLike(biome, this._biomeTypes);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<IfEntityInBiomeOfTypeCondition> {
        private static final String _ERR_MSG = "Invalid or missing biome type(s); must be either string or array of strings.";
        private static final String _FROM = "entity";
        private static final String _TYPE = "type";

        public Serializer() {
            super(new ResourceLocation(LibInfo.MOD_ID(), "in_biome_type"), IfEntityInBiomeOfTypeCondition.class);
        }

        public IfEntityInBiomeOfTypeCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            LootContext.EntityTarget target = null;
            if (json.has(_FROM)) {
                target = (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)_FROM, (JsonDeserializationContext)context, LootContext.EntityTarget.class);
            }
            String[] typeids = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)_TYPE)) {
                if (JSONUtils.func_151205_a((JsonObject)json, (String)_TYPE)) {
                    String key = JSONUtils.func_151200_h((JsonObject)json, (String)_TYPE);
                    typeids = new String[]{key};
                } else {
                    if (!JSONUtils.func_151202_d((JsonObject)json, (String)_TYPE)) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)_TYPE);
                    typeids = new String[jsonarray.size()];
                    int j = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        typeids[j++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)_TYPE);
                    }
                    if (typeids.length == 0) {
                        throw new JsonSyntaxException("Invalid biome type array; must contain at least one biome type.");
                    }
                }
            }
            if (typeids == null) {
                throw new JsonSyntaxException(_ERR_MSG);
            }
            return new IfEntityInBiomeOfTypeCondition(target, typeids);
        }

        public void serialize(JsonObject json, IfEntityInBiomeOfTypeCondition lcond, JsonSerializationContext context) {
            json.add(_FROM, context.serialize((Object)lcond._target_locked));
            if (lcond._biomeTypes.length == 1) {
                json.add(_TYPE, context.serialize((Object)lcond._biomeTypes[0].getName()));
            } else {
                JsonArray jsonarray = new JsonArray();
                for (BiomeDictionary.Type type : lcond._biomeTypes) {
                    jsonarray.add(context.serialize((Object)type.getName()));
                }
                json.add(_TYPE, (JsonElement)jsonarray);
            }
        }
    }
}

