/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.barter.Bartering;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;
import org.jwaresoftware.mcmods.lib.loot.Loot;

public final class IfPresentUseFunction
extends LootFunction {
    @Nullable
    public final String _itemid;
    @Nullable
    public final Type _itemtype;
    @Nullable
    public final String _modid;
    @Nullable
    final String _dictkey;

    public IfPresentUseFunction(ILootCondition[] conditions, @Nullable String identifier, @Nullable Type type, @Nullable String modid, @Nullable String dictid) {
        super(conditions);
        this._itemid = identifier;
        this._itemtype = type;
        this._modid = StringUtils.trimToNull((String)modid);
        this._dictkey = StringUtils.trimToNull((String)dictid);
    }

    public ItemStack func_215859_a(ItemStack in, LootContext context) {
        ItemStack out = in;
        if (this._itemid != null) {
            if (this._modid != null && !ModIntegration.isPresent(this._modid)) {
                return in;
            }
            if (this._dictkey != null && !SharedGlue.ingredientDefined(this._dictkey)) {
                return in;
            }
            if (this._itemtype == Type.LOOT_TABLE) {
                out = this.fromOptionalLootTable(in, context);
            } else if (this._itemtype == Type.BARTER_TOKEN) {
                out = this.fromBarterTokenSource(in, context);
            } else {
                ItemStack preference;
                ResourceLocation r;
                String rstring = this._itemid;
                int i = this._itemid.lastIndexOf(35);
                if (i > 0) {
                    rstring = rstring.substring(0, i);
                }
                if (ModIntegration.isPresent((r = new ResourceLocation(rstring)).func_110624_b()) && !(preference = ModIntegration.itemstack(r.func_110624_b(), r.func_110623_a())).func_190926_b()) {
                    out = Loot.resized(preference, in.func_190916_E());
                }
            }
        }
        return out;
    }

    private ItemStack fromOptionalLootTable(ItemStack in, LootContext context) {
        LootTable lT;
        ItemStack out = in;
        ResourceLocation r = new ResourceLocation(this._itemid);
        if (ModIntegration.isPresent(r.func_110624_b()) && (lT = context.func_186497_e().func_186521_a(r)) != LootTable.field_186464_a) {
            try {
                List hits = lT.func_216113_a(context);
                for (ItemStack hit : hits) {
                    if (hit.func_190926_b()) continue;
                    out = hit;
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return out;
    }

    private ItemStack fromBarterTokenSource(ItemStack in, LootContext context) {
        String rmodid;
        ModIntegration mod;
        ItemStack out = in;
        QualityGrade qg = QualityGrade.findOrUnknown(this._itemid);
        if (qg.isKnown() && Bartering.isEnabled(mod = ModIntegration.get(rmodid = this._modid != null ? this._modid : LibInfo.MOD_ID()))) {
            out = Bartering.getTokenFactory(mod).apply(qg);
        }
        return out;
    }

    public static class Serializer
    extends LootFunction.Serializer<IfPresentUseFunction> {
        public Serializer() {
            super(new ResourceLocation(LibInfo.MOD_ID(), "ifpresent"), IfPresentUseFunction.class);
        }

        public IfPresentUseFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            String req_dictentry;
            String itemid = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)object, (String)"prefer", null));
            Type type = Type.fromLString(JSONUtils.func_151219_a((JsonObject)object, (String)"type", null));
            String req_modid = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)object, (String)"modid", null));
            if (LibInfo.MOD_ID().equals(req_modid)) {
                req_modid = null;
            }
            if ((req_dictentry = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)object, (String)"tag", null))) == null) {
                req_dictentry = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)object, (String)"dict", null));
            }
            return new IfPresentUseFunction(conditions, itemid, type, req_modid, req_dictentry);
        }

        public void serialize(JsonObject object, IfPresentUseFunction lfunction, JsonSerializationContext serializationContext) {
            String type;
            if (lfunction._modid != null) {
                object.add("modid", serializationContext.serialize((Object)lfunction._modid));
            }
            if (lfunction._dictkey != null) {
                object.add("tag", serializationContext.serialize((Object)lfunction._dictkey));
            }
            if (lfunction._itemid != null) {
                object.add("prefer", serializationContext.serialize((Object)lfunction._itemid));
            }
            if ((type = Type.toLString(lfunction._itemtype)) != null) {
                object.add("type", serializationContext.serialize((Object)type));
            }
        }
    }

    public static enum Type {
        ITEM,
        LOOT_TABLE,
        BARTER_TOKEN;


        @Nullable
        public static final Type fromLString(@Nullable String s) {
            if ("item".equals(s)) {
                return ITEM;
            }
            if ("loot_table".equals(s)) {
                return LOOT_TABLE;
            }
            if ("barter_token".equals(s)) {
                return BARTER_TOKEN;
            }
            return null;
        }

        @Nullable
        public static final String toLString(@Nullable Type type) {
            return type == null || type == ITEM ? null : (type == BARTER_TOKEN ? "barter_token" : "loot_table");
        }
    }
}

