/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.EmptyLootEntry;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.lib.ItemStackArray;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ILootedListener;
import org.jwaresoftware.mcmods.lib.loot.ApplyClampedBonusFunction;
import org.jwaresoftware.mcmods.lib.loot.EnchantCompatibleFunction;
import org.jwaresoftware.mcmods.lib.loot.EnchantCompatibleWithLevelsFunction;
import org.jwaresoftware.mcmods.lib.loot.EnchantRandomFunction;
import org.jwaresoftware.mcmods.lib.loot.FalseCondition;
import org.jwaresoftware.mcmods.lib.loot.IfBarteringCondition;
import org.jwaresoftware.mcmods.lib.loot.IfEntityInBiomeCondition;
import org.jwaresoftware.mcmods.lib.loot.IfEntityInBiomeOfTypeCondition;
import org.jwaresoftware.mcmods.lib.loot.IfPresentUseFunction;
import org.jwaresoftware.mcmods.lib.loot.IsSilkTouchToolCondition;
import org.jwaresoftware.mcmods.lib.loot.KilledByRealPlayerCondition;
import org.jwaresoftware.mcmods.lib.loot.RandomChanceWithLuckCondition;
import org.jwaresoftware.mcmods.lib.loot.RandomPickFromSharedDictFunction;
import org.jwaresoftware.mcmods.lib.loot.RandomPickFromVariantSetFunction;
import org.jwaresoftware.mcmods.lib.loot.RandomPotionFunction;
import org.jwaresoftware.mcmods.lib.loot.SetUnbreakableFunction;

public final class Loot {
    public static final String MINECRAFT_POOLNAME = Loot.asMinecraftPool(-1);
    public static final String DEFAULT_EXTENSION_POOLNAME = LibInfo.cc("xlootpool");
    static final Map<String, ConcurrentMap<ResourceLocation, Map<String, List<LootEntry.Builder<?>>>>> lootDefsINSTANCE = new ConcurrentHashMap();
    private static Field _LOOT_TABLE_POOLS_LIST = null;
    private static Field _LOOT_POOL_ENTRIES_LIST = null;
    private static final String _BUILTIN_MARKER_PREFIX = "___builtin_";
    public static final String DEFAULT_BARTERING_POOLNAME = LibInfo.cc("bartering");
    static final Map<ResourceLocation, LootTable> xlootTablesINSTANCE = new ConcurrentHashMap<ResourceLocation, LootTable>();
    private static boolean _DEFAULTS_INITED = false;

    public static final LootTableManager getLTM() {
        return ServerLifecycleHooks.getCurrentServer().func_200249_aQ();
    }

    public static final boolean isEnabled(String modid) {
        return modid != null && lootDefsINSTANCE.containsKey(modid);
    }

    public static final void clearAll(String modid) {
        if (modid != null) {
            lootDefsINSTANCE.remove(modid);
        } else {
            lootDefsINSTANCE.clear();
        }
    }

    static final ConcurrentMap<ResourceLocation, Map<String, List<LootEntry.Builder<?>>>> getModDefs(@Nonnull String modid) {
        ConcurrentMap<ResourceLocation, Map<String, List<LootEntry.Builder<?>>>> modDefs = lootDefsINSTANCE.get(modid);
        if (modDefs == null) {
            modDefs = new ConcurrentHashMap();
            lootDefsINSTANCE.put(modid, modDefs);
        }
        return modDefs;
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, Item item, ILootFunction.IBuilder amendDropsHandler) {
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(10).func_216085_b(0).func_212841_b_(amendDropsHandler);
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, Item item, int weight, int quality) {
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight).func_216085_b(quality < 0 ? 0 : quality);
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, Item item, int count, int weight, int quality) {
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight).func_216085_b(quality < 0 ? 0 : quality).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)count)));
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, Item item, int min, int max, int weight, int quality) {
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight).func_216085_b(quality < 0 ? 0 : quality).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)min, (float)max)));
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, ItemStack item, int weight, int quality, float chance) {
        StandaloneLootEntry.Builder ib = ItemLootEntry.func_216168_a((IItemProvider)item.func_77973_b()).func_216086_a(weight).func_216085_b(quality < 0 ? 0 : quality);
        if (item.func_190916_E() > 1) {
            ib.func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)item.func_190916_E())));
        }
        if (ItemStacks.hasNonEmptyData(item)) {
            ib.func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)item.func_77978_p().func_74737_b()));
        }
        if (chance > 0.0f) {
            ib.func_212840_b_(RandomChance.func_216004_a((float)chance));
        }
        return ib;
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, ItemStack item, int weight) {
        return Loot.createEntryItem(oid, item, weight, -1, 0.0f);
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, ItemStack item, int min, int max, int weight, int quality, float chance) {
        return Loot.createEntryItem(oid, ItemStacks.copy1(item), weight, quality, chance).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)min, (float)max)));
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, ItemStack item, int min, int max, int weight) {
        return Loot.createEntryItem(oid, item, min, max, weight, -1, 0.0f);
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, Item item, int weight, int quality, LootFunction.Builder ... functions) {
        StandaloneLootEntry.Builder ib = ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight).func_216085_b(quality < 0 ? 0 : quality);
        for (LootFunction.Builder fb : functions) {
            ib.func_212841_b_((ILootFunction.IBuilder)fb);
        }
        return ib;
    }

    public static final StandaloneLootEntry.Builder<?> createEntryItem(String oid, Item item, int weight, int quality, ILootCondition.IBuilder[] conditions, LootFunction.Builder ... functions) {
        StandaloneLootEntry.Builder<?> ib = Loot.createEntryItem(oid, item, weight, quality, functions);
        for (ILootCondition.IBuilder cb : conditions) {
            ib.func_212840_b_(cb);
        }
        return ib;
    }

    public static final StandaloneLootEntry.Builder<?> createDamagedItem(String oid, Item item, float min_damage, float max_damage, int weight, int quality) {
        float min_durability = 1.0f - max_damage;
        float max_durability = 1.0f - min_damage;
        return Loot.createEntryItem(oid, item, weight, quality).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)new RandomValueRange(min_durability, max_durability)));
    }

    public static final StandaloneLootEntry.Builder<?> createDamagedItem(String oid, Item item, float min_damage, float max_damage, int min_elvl, int max_elvl, int weight, int quality) {
        EnchantWithLevels.Builder enchantwithlevels = EnchantWithLevels.func_215895_a((IRandomRange)new RandomValueRange((float)min_elvl, (float)max_elvl));
        if (min_elvl > 19) {
            enchantwithlevels.func_216059_e();
        }
        return Loot.createDamagedItem(oid, item, min_damage, max_damage, weight, quality).func_212841_b_((ILootFunction.IBuilder)enchantwithlevels);
    }

    public static final void addLootEntry(String modid, ResourceLocation tableid, String poolid, LootEntry.Builder<?> e) {
        ArrayList loot;
        ConcurrentMap<ResourceLocation, Map<String, List<LootEntry.Builder<?>>>> modDefs = Loot.getModDefs(modid);
        HashMap poolDefs = (HashMap)modDefs.get(tableid);
        if (poolDefs == null) {
            poolDefs = new HashMap();
            modDefs.put(tableid, poolDefs);
        }
        if (StringUtils.isEmpty((CharSequence)poolid)) {
            poolid = MINECRAFT_POOLNAME;
        }
        if ((loot = (ArrayList)poolDefs.get(poolid)) == null) {
            loot = new ArrayList();
            poolDefs.put(poolid, loot);
        }
        loot.add(e);
    }

    public static final void addLootEntryIfPresent(String modid, ResourceLocation tableid, String poolid, LootEntry.Builder<?> e) {
        if (!LootTables.field_186419_a.equals((Object)tableid)) {
            Loot.addLootEntry(modid, tableid, poolid, e);
        }
    }

    public static final void addFiller(String modid, ResourceLocation tableid, String poolid, int weight) {
        StandaloneLootEntry.Builder lb = EmptyLootEntry.func_216167_a().func_216086_a(weight);
        Loot.addLootEntry(modid, tableid, poolid, lb);
    }

    public static final void addFiller(String modid, ResourceLocation tableid, String poolid, int weight, int n) {
        StandaloneLootEntry.Builder lb = EmptyLootEntry.func_216167_a().func_216086_a(weight);
        Loot.addLootEntry(modid, tableid, poolid, lb);
    }

    public static final void addFishedUpJunk(String modid, String oid, Item item) {
        Loot.addLootEntry(modid, LootTables.field_186388_am, null, Loot.createEntryItem(oid, item, SharedGlue.JUNK_WEIGHT(), -1));
    }

    public static final void addFishedUpJunk(String modid, String oid, ItemStack item) {
        Loot.addLootEntry(modid, LootTables.field_186388_am, null, Loot.createEntryItem(oid, item, SharedGlue.JUNK_WEIGHT()));
    }

    public static final void addFishedUpJunk(String modid, String oid, Item item, float min_damage, float max_damage) {
        Loot.addLootEntry(modid, LootTables.field_186388_am, null, Loot.createDamagedItem(oid, item, min_damage, max_damage, SharedGlue.JUNK_WEIGHT() - 2, -1));
    }

    public static final void addFishedUpJunk(String modid, String oid, Item item, float min_damage, float max_damage, int min_elvl, int max_elvl) {
        Loot.addLootEntry(modid, LootTables.field_186388_am, null, Loot.createDamagedItem(oid, item, min_damage, max_damage, min_elvl, max_elvl, SharedGlue.JUNK_WEIGHT() - 2, -1));
    }

    public static final void addFishedUpUncommon(String modid, String oid, Item item) {
        Loot.addLootEntry(modid, LootTables.field_186388_am, null, Loot.createEntryItem(oid, item, SharedGlue.UNCOMMON_WEIGHT(), -1));
    }

    public static final void addFishedUpUncommon(String modid, String oid, ItemStack item) {
        Loot.addLootEntry(modid, LootTables.field_186388_am, null, Loot.createEntryItem(oid, item, SharedGlue.UNCOMMON_WEIGHT()));
    }

    public static final void addFishedUpUncommon(String modid, String oid, Item item, float min_damage, float max_damage) {
        Loot.addLootEntry(modid, LootTables.field_186388_am, null, Loot.createDamagedItem(oid, item, min_damage, max_damage, SharedGlue.UNCOMMON_WEIGHT(), -1));
    }

    public static final void addFishedUpTreasure(String modid, String oid, Item item) {
        Loot.addLootEntry(modid, LootTables.field_186389_an, null, Loot.createEntryItem(oid, item, SharedGlue.TREASURE_WEIGHT(), -1));
    }

    public static final void addFishedUpTreasure(String modid, String oid, ItemStack item) {
        Loot.addLootEntry(modid, LootTables.field_186389_an, null, Loot.createEntryItem(oid, item, SharedGlue.TREASURE_WEIGHT()));
    }

    public static final void initAmendmentSupport() {
        try {
            _LOOT_TABLE_POOLS_LIST = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");
        }
        catch (Throwable igX) {
            LibInfo.LOG.error("Unable to initialize loot TABLE lookup hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
        try {
            _LOOT_POOL_ENTRIES_LIST = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
        }
        catch (Throwable igX) {
            LibInfo.LOG.error("Unable to initialize loot POOL amendment hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
    }

    @Nullable
    private static List<LootPool> readPools_(@Nonnull LootTable table) {
        List out = null;
        try {
            out = _LOOT_TABLE_POOLS_LIST != null ? (List)_LOOT_TABLE_POOLS_LIST.get(table) : (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"field_186466_c");
        }
        catch (Throwable igX) {
            LibInfo.LOG.warn("Unable to retrieve loot pool list from table, ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
        return out;
    }

    @Nullable
    private static List<LootEntry> readEntries_(@Nonnull LootPool pool) {
        List out = null;
        try {
            out = _LOOT_POOL_ENTRIES_LIST != null ? (List)_LOOT_POOL_ENTRIES_LIST.get(pool) : (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186453_a");
        }
        catch (Throwable igX) {
            String name = (String)StringUtils.defaultIfBlank((CharSequence)pool.getName(), (CharSequence)"__builtin");
            LibInfo.LOG.warn("Unable to retrieve loot pool entries from {}, ({})", (Object)name, (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
        return out;
    }

    public static final void merge(String modid, Logger feedback, LootTableLoadEvent event) {
        ConcurrentMap<ResourceLocation, Map<String, List<LootEntry.Builder<?>>>> modDefs;
        Map poolDefs;
        if (Loot.isEnabled(modid) && (poolDefs = (Map)(modDefs = Loot.getModDefs(modid)).get(event.getName())) != null) {
            for (String poolid : poolDefs.keySet()) {
                LootPool pool = event.getTable().getPool(poolid);
                int index = Loot.getMinecraftPoolIndex(poolid);
                if (pool == null) {
                    List<LootPool> pools = Loot.readPools_(event.getTable());
                    if (index >= 0) {
                        if (pools == null || index >= pools.size()) {
                            feedback.error("Unable to modify loot pool {}/[{}] for mod {}. Pool list inaccessible or no such pool found in table {}!", (Object)poolid, (Object)index, (Object)modid, (Object)event.getName());
                            return;
                        }
                        pool = pools.get(index);
                    }
                } else if (index >= 0) {
                    feedback.error("Unable to modify loot pool {} for mod {}. Pool name is ambiguous (reserved prefix)", (Object)poolid, (Object)modid);
                    return;
                }
                if (pool == null) {
                    LootPool.Builder poolb = new LootPool.Builder().name(poolid).func_216046_a((IRandomRange)new RandomValueRange(1.0f)).bonusRolls(0.0f, 0.0f);
                    for (LootEntry.Builder entryb : (List)poolDefs.get(poolid)) {
                        poolb.func_216045_a(entryb);
                    }
                    event.getTable().addPool(poolb.func_216044_b());
                    continue;
                }
                boolean altered = false;
                List<LootEntry> lootEntries = Loot.readEntries_(pool);
                if (lootEntries != null) {
                    for (LootEntry.Builder entryb : (List)poolDefs.get(poolid)) {
                        lootEntries.add(entryb.func_216081_b());
                    }
                    altered = true;
                }
                if (altered) continue;
                feedback.warn("Unable to amend loot pool {} for mod {}. Entries list inaccessible.", (Object)poolid, (Object)modid);
            }
        }
    }

    public static final boolean isMainExtensionPool(String poolid) {
        return DEFAULT_EXTENSION_POOLNAME.equals(poolid);
    }

    public static final boolean isExtensionPool(String poolid) {
        return poolid != null && poolid.startsWith(DEFAULT_EXTENSION_POOLNAME);
    }

    public static final String asExtensionPool(@Nonnull String suffix) {
        return DEFAULT_EXTENSION_POOLNAME + "_" + suffix;
    }

    public static final boolean isMinecraftPool(@Nullable String poolid) {
        return StringUtils.isEmpty((CharSequence)poolid) || poolid.startsWith(_BUILTIN_MARKER_PREFIX);
    }

    public static final String asMinecraftPool(int index) {
        index = Math.max(0, index);
        return _BUILTIN_MARKER_PREFIX + index;
    }

    private static final int getMinecraftPoolIndex(@Nullable String poolid) {
        int index = -1;
        if (Loot.isMinecraftPool(poolid)) {
            if (StringUtils.isEmpty((CharSequence)poolid)) {
                index = 0;
            } else {
                String numstring = poolid.substring(_BUILTIN_MARKER_PREFIX.length());
                index = NumberUtils.toInt((String)numstring, (int)index);
            }
        }
        return index;
    }

    public static final boolean isKnownTable(@Nonnull World in, @Nonnull ResourceLocation tableid) {
        if (in != null && tableid != null) {
            try {
                LootTable lt = Loot.getLTM().func_186521_a(tableid);
                return lt != null && lt != LootTable.field_186464_a;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static final ResourceLocation asAdvancementRewardPool(String modid, String tablename) {
        return new ResourceLocation(modid, "gameplay/rewards/adv/" + tablename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final LootTable getModdedLootTable(@Nonnull ResourceLocation tableLoc, @Nonnull LootTableManager ltm) {
        if (tableLoc.func_110623_a().startsWith("*RANDOM") || tableLoc.func_110623_a().startsWith("*random")) {
            return LootTable.field_186464_a;
        }
        if ("minecraft".equals(tableLoc.func_110624_b())) {
            LootTable loottable_minecraft = ltm.func_186521_a(tableLoc);
            return loottable_minecraft != null ? loottable_minecraft : LootTable.field_186464_a;
        }
        Map<ResourceLocation, LootTable> map = xlootTablesINSTANCE;
        synchronized (map) {
            LootTable loottable = xlootTablesINSTANCE.get(tableLoc);
            if (loottable == null) {
                loottable = ltm.func_186521_a(tableLoc);
                if (!loottable.isFrozen()) {
                    LootTable loottable_modded = ForgeEventFactory.loadLootTable((ResourceLocation)tableLoc, (LootTable)loottable, (LootTableManager)ltm);
                    if (loottable_modded == null) {
                        loottable_modded = LootTable.field_186464_a;
                    }
                    if (loottable_modded != LootTable.field_186464_a && !loottable_modded.isFrozen()) {
                        loottable_modded.freeze();
                    }
                    loottable = loottable_modded;
                }
                xlootTablesINSTANCE.put(tableLoc, loottable);
            }
            return loottable;
        }
    }

    @Nonnull
    public static final List<Integer> getEmptySlotsRandomized(IItemHandler inventory, Random rand) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int n = inventory.getSlots();
        for (int i = 0; i < n; ++i) {
            if (!inventory.getStackInSlot(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static final boolean hasTopLevelLootTable(@Nonnull ItemStack from) {
        boolean has = false;
        if (from.func_77942_o()) {
            CompoundNBT itemdata = from.func_77978_p();
            String rstring = null;
            if (itemdata.func_150297_b(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME(), 8)) {
                rstring = itemdata.func_74779_i(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME());
            } else if (itemdata.func_150297_b("withLoot", 8)) {
                rstring = itemdata.func_74779_i("withLoot");
            }
            if (StringUtils.trimToNull((String)rstring) != null) {
                has = true;
            }
        }
        return has;
    }

    @Nullable
    public static final ResourceLocation getTopLevelLootTable(@Nonnull ItemStack from) {
        if (from.func_77942_o()) {
            CompoundNBT itemdata = from.func_77978_p();
            String rstring = null;
            if (itemdata.func_150297_b(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME(), 8)) {
                rstring = itemdata.func_74779_i(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME());
            } else if (itemdata.func_150297_b("withLoot", 8)) {
                rstring = itemdata.func_74779_i("withLoot");
            }
            rstring = StringUtils.trimToNull((String)rstring);
            if (rstring != null) {
                return ResourceLocation.func_208304_a((String)rstring);
            }
        }
        return null;
    }

    public static final void clearTopLevelLootTable(@Nonnull ItemStack from) {
        if (from.func_77942_o()) {
            CompoundNBT itemdata = from.func_77978_p();
            itemdata.func_82580_o(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME());
            itemdata.func_82580_o(SharedGlue.DEFAULT_LOOT_TABLE_SEED_TAGNAME());
            itemdata.func_82580_o("withLoot");
        }
    }

    static final ItemStack resized(ItemStack loot, int m) {
        if (m <= 0) {
            m = 1;
        }
        m = Math.min(m, loot.func_77976_d());
        loot.func_190920_e(m);
        return loot;
    }

    static final PlayerEntity playerFrom(LootContext context) {
        Entity e = (Entity)context.func_216031_c(LootContext.EntityTarget.KILLER_PLAYER.func_216029_a());
        if (e == null) {
            e = (Entity)context.func_216031_c(LootContext.EntityTarget.THIS.func_216029_a());
        }
        Object player = e instanceof PlayerEntity ? (PlayerEntity)e : FakePlayerFactory.getMinecraft((ServerWorld)context.func_202879_g());
        return player;
    }

    public static final boolean hasExplosion(@Nonnull LootContext context) {
        return context.func_216033_a(LootParameters.field_216290_j) && ((Float)context.func_216031_c(LootParameters.field_216290_j)).floatValue() > 0.0f;
    }

    public static final ItemStack applyExplosion(ItemStack drop, @Nonnull LootContext context) {
        Float explosion_r;
        if (!drop.func_190926_b() && (explosion_r = (Float)context.func_216031_c(LootParameters.field_216290_j)) != null) {
            Random random = context.func_216032_b();
            float chance = 1.0f / explosion_r.floatValue();
            int N = drop.func_190916_E();
            int survive_count = 0;
            for (int i = 0; i < N; ++i) {
                if (!(random.nextFloat() <= chance)) continue;
                ++survive_count;
            }
            drop.func_190920_e(survive_count);
        }
        return drop;
    }

    public static final List<ItemStack> mergeExplosion(@Nonnull LootContext lc, @Nullable List<ItemStack> main, List<ItemStack> additional) {
        if (Loot.hasExplosion(lc)) {
            ListIterator<ItemStack> litr = additional.listIterator();
            while (litr.hasNext()) {
                ItemStack dropdrop = Loot.applyExplosion(litr.next(), lc);
                if (dropdrop.func_190926_b()) {
                    litr.remove();
                    continue;
                }
                litr.set(dropdrop);
            }
        }
        if (main == null) {
            main = additional;
        } else if (main != additional) {
            main.addAll(additional);
        }
        return main;
    }

    public static final int getBonus(ItemStack held, @Nonnull LivingEntity actor, @Nullable Enchantment e, @Nullable IAttribute a) {
        int val;
        int lvl;
        int out = 0;
        if (e != null && !ItemStacks.isEmpty(held) && (lvl = EnchantmentHelper.func_77506_a((Enchantment)e, (ItemStack)held)) > out) {
            out = lvl;
        }
        if (a != null && actor.func_110148_a(a) != null && (val = MathHelper.func_76140_b((double)actor.func_110148_a(a).func_111126_e())) > out) {
            out = val;
        }
        return out;
    }

    public static final int getBetterFortuneOrLuck(@Nonnull LivingEntity actor, ItemStack held) {
        return Loot.getBonus(held, actor, SharedGlue.Enchantment_fortune, SharedMonsterAttributes.field_188792_h);
    }

    public static final int getBetterLootingOrLuck(@Nonnull LivingEntity actor, ItemStack held) {
        return Loot.getBonus(held, actor, SharedGlue.Enchantment_looting, SharedMonsterAttributes.field_188792_h);
    }

    public static final int getBonus(@Nonnull LootContext context, @Nullable Enchantment e, @Nullable IAttribute a) {
        int val;
        LivingEntity actor;
        Entity what;
        int lvl;
        ItemStack held;
        int out = 0;
        if (e != null && !ItemStacks.isEmpty(held = (ItemStack)context.func_216031_c(LootParameters.field_216289_i)) && (lvl = EnchantmentHelper.func_77506_a((Enchantment)e, (ItemStack)held)) > out) {
            out = lvl;
        }
        if (a != null && (what = (Entity)context.func_216031_c(LootParameters.field_216281_a)) instanceof LivingEntity && (actor = (LivingEntity)what).func_110148_a(a) != null && (val = MathHelper.func_76140_b((double)actor.func_110148_a(a).func_111126_e())) > out) {
            out = val;
        }
        if (context.func_186491_f() > (float)out) {
            out = MathHelper.func_76123_f((float)context.func_186491_f());
        }
        return out;
    }

    public static final int getBetterFortuneOrLuck(@Nonnull LootContext context) {
        return Loot.getBonus(context, SharedGlue.Enchantment_fortune, SharedMonsterAttributes.field_188792_h);
    }

    public static final int getBetterLootingOrLuck(@Nonnull LootContext context) {
        return Loot.getBonus(context, SharedGlue.Enchantment_looting, SharedMonsterAttributes.field_188792_h);
    }

    public static final boolean isSilkTouched(@Nonnull LootContext context) {
        boolean is = false;
        ItemStack held = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (!ItemStacks.isEmpty(held)) {
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)SharedGlue.Enchantment_silkTouch, (ItemStack)held);
            is = lvl > 0;
        }
        return is;
    }

    public static final ItemStack[] newStackArray(int slotCount) {
        return ItemStackArray.create(slotCount);
    }

    public static void dropLoot(LivingDropsEvent event, ItemStack stack) {
        if (event.getDrops() == null) {
            return;
        }
        LivingEntity e = event.getEntityLiving();
        ItemEntity drop = new ItemEntity(e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v, stack);
        drop.func_174869_p();
        event.getDrops().add(drop);
    }

    public static final void replaceLoot(LivingDropsEvent event, Item current, @Nullable Item alternate, ItemStack with, boolean count_match) {
        if (event.getDrops() == null) {
            return;
        }
        MutableInt r = new MutableInt(0);
        event.getDrops().removeIf(ie -> {
            int _n = 0;
            if (ie.func_92059_d().func_77973_b() == current || alternate != null && ie.func_92059_d().func_77973_b() == alternate) {
                _n = ie.func_92059_d().func_190916_E();
                r.add(_n);
            }
            return _n > 0;
        });
        if (r.intValue() > 0) {
            ItemStack replacement = ItemStacks.copy(with, count_match ? r.intValue() : with.func_190916_E());
            Loot.dropLoot(event, replacement);
        }
    }

    public static final void replaceLoot(LivingDropsEvent event, Item current, @Nullable Item alternate, Item with) {
        Loot.replaceLoot(event, current, alternate, ItemStacks.create(with), true);
    }

    public static final void replaceLoot(LivingDropsEvent event, Item current, Item with) {
        Loot.replaceLoot(event, current, null, ItemStacks.create(with), true);
    }

    public static final List<Integer> getEmptySlots(IInventory inventory, Random rand) {
        ArrayList<Integer> empty_slots = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!ItemStacks.isEmpty(inventory.func_70301_a(i))) continue;
            empty_slots.add(i);
        }
        if (rand != null) {
            Collections.shuffle(empty_slots, rand);
        }
        return empty_slots;
    }

    public static final ItemStack createShulkerbox(DyeColor color) {
        return ShulkerBoxBlock.func_190953_b((DyeColor)(color == null ? DyeColor.WHITE : color));
    }

    public static final ItemStack createUndyedShulkerbox() {
        return new ItemStack((IItemProvider)Blocks.field_204409_il);
    }

    protected Loot() {
    }

    public static final void init0() {
    }

    public static final void initDefaults() {
        if (_DEFAULTS_INITED) {
            return;
        }
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new FalseCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new RandomChanceWithLuckCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new KilledByRealPlayerCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new IfEntityInBiomeCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new IfEntityInBiomeOfTypeCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new IfBarteringCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new IsSilkTouchToolCondition.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new OnCreatedFunction.BaseSerializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new OnLootedFunction.BaseSerializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new SetUnbreakableFunction.Serializer(true));
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new IfPresentUseFunction.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new EnchantRandomFunction.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new EnchantCompatibleWithLevelsFunction.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new RandomPickFromSharedDictFunction.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new RandomPickFromVariantSetFunction.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new RandomPotionFunction.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new ApplyClampedBonusFunction.Serializer());
        _DEFAULTS_INITED = true;
    }

    public static final void initFinalize() {
        Loot.initDefaults();
        RandomPotionFunction.initFinalize();
    }

    public static final void tagsFinalize() {
        EnchantCompatibleFunction.Profile.addTaggedProfileSamples();
    }

    public static class OnLootedFunction
    extends LootFunction {
        @Nullable
        protected final String _selector;

        public OnLootedFunction(ILootCondition[] conditions, @Nullable String selector) {
            super(conditions);
            this._selector = selector;
        }

        public OnLootedFunction(ILootCondition[] conditions) {
            this(conditions, null);
        }

        public ItemStack func_215859_a(ItemStack stack, LootContext context) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ILootedListener) {
                PlayerEntity player = Loot.playerFrom(context);
                try {
                    ((ILootedListener)stack.func_77973_b()).notifyLooted(stack, (World)context.func_202879_g(), player, context.func_186491_f(), this._selector);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return stack;
        }

        public static final class BaseSerializer
        extends LootFunction.Serializer<OnLootedFunction> {
            public BaseSerializer() {
                super(new ResourceLocation(LibInfo.MOD_ID(), "on_looted"), OnLootedFunction.class);
            }

            public OnLootedFunction deserialize(JsonObject json, JsonDeserializationContext d_context, ILootCondition[] conditions) {
                String selector = JSONUtils.func_151219_a((JsonObject)json, (String)"context", null);
                return new OnLootedFunction(conditions, selector);
            }

            public void serialize(JsonObject json, OnLootedFunction lfunction, JsonSerializationContext s_context) {
                if (lfunction._selector != null && !lfunction._selector.isEmpty()) {
                    json.add("context", s_context.serialize((Object)lfunction._selector));
                }
            }
        }
    }

    public static class OnCreatedFunction
    extends LootFunction {
        public OnCreatedFunction(ILootCondition[] conditions) {
            super(conditions);
        }

        public ItemStack func_215859_a(ItemStack stack, LootContext context) {
            if (!stack.func_190926_b()) {
                PlayerEntity player = Loot.playerFrom(context);
                try {
                    stack.func_77973_b().func_77622_d(stack, (World)context.func_202879_g(), player);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return stack;
        }

        public static final class BaseSerializer
        extends LootFunction.Serializer<OnCreatedFunction> {
            public BaseSerializer() {
                super(new ResourceLocation(LibInfo.MOD_ID(), "on_created"), OnCreatedFunction.class);
            }

            public void serialize(JsonObject object, OnCreatedFunction f, JsonSerializationContext sc) {
            }

            public OnCreatedFunction deserialize(JsonObject json, JsonDeserializationContext dc, ILootCondition[] conditions) {
                return new OnCreatedFunction(conditions);
            }
        }
    }

    public static final class LootTableDef {
        public ResourceLocation resource = null;
        public long seed = -1L;

        public LootTableDef() {
        }

        public LootTableDef(ResourceLocation r) {
            this.resource = r;
        }
    }
}

