/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModItem;
import org.jwaresoftware.mcmods.lib.recipes.AllTagsPresentCondition;
import org.jwaresoftware.mcmods.lib.recipes.CampfireRecipeWrapping;
import org.jwaresoftware.mcmods.lib.recipes.DyeableDyeRecipe;
import org.jwaresoftware.mcmods.lib.recipes.MultiItemBlastFurnaceRecipe;
import org.jwaresoftware.mcmods.lib.recipes.MultiItemCookingRecipeSerializer;
import org.jwaresoftware.mcmods.lib.recipes.MultiItemFurnaceRecipe;
import org.jwaresoftware.mcmods.lib.recipes.MultiItemSmokerRecipe;
import org.jwaresoftware.mcmods.lib.recipes.ShapedRecipeWrapping;
import org.jwaresoftware.mcmods.lib.recipes.ShapelessRecipeWrapping;
import org.jwaresoftware.mcmods.lib.recipes.TagIsPresentCondition;

public final class JR {
    public static final int C_TBD = 1;
    public static final int C_VFP = 2;
    public static final int C_HCB = 4;
    public static final int C_SMH = 8;
    public static final int C_ORE = 16;
    private static final Gson GSON_out = new GsonBuilder().setPrettyPrinting().create();
    static final FastDateFormat STAMP_FORMAT = FastDateFormat.getInstance((String)"yyyyMMdd'T'HHmmss.SSZ");
    private static final ThreadLocal<ModDef> _current_modDef = new ThreadLocal();
    private static final File RECIPES_DIR = new File("C:/Temp/JR");
    static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static MultiItemCookingRecipeSerializer<MultiItemFurnaceRecipe> SMELTING_RECIPE_SERIALIZER;
    public static MultiItemCookingRecipeSerializer<MultiItemSmokerRecipe> SMOKER_RECIPE_SERIALIZER;
    public static MultiItemCookingRecipeSerializer<MultiItemBlastFurnaceRecipe> BLASTING_RECIPE_SERIALIZER;
    static final IIngredientSerializer<BucketTaggedFluidIngredient> INGREDIENT_TAGGED_FLUID_BUCKET_SERIALIZER;
    public static final IIngredientSerializer<BucketFluidIngredient> INGREDIENT_FLUID_BUCKET_SERIALIZER;
    public static final IIngredientSerializer<Ingredient> INGREDIENT_FILLED_UNIVERSAL_BUCKET_SERIALIZER;
    public static final IIngredientSerializer<FillableTankIngredient> INGREDIENT_FILLABLE_BUCKET_SERIALIZER;
    public static final IIngredientSerializer<Ingredient> INGREDIENT_FILLABLE_BUCKET_OR_TANK_SERIALIZER;

    public static final ModDef setCurrentMod(@Nonnull String modid) {
        _current_modDef.set(new ModDef(modid));
        return _current_modDef.get();
    }

    public static final void setCurrentMod(@Nonnull String modid, @Nonnull Map<String, String> rmap) {
        _current_modDef.set(new ModDef(modid));
        JR._current_modDef.get().rconstants = rmap;
    }

    public static final void disableLegacyMode() {
        JR._current_modDef.get().legacymode = false;
    }

    public static final void clrCurrentMod() {
        _current_modDef.set(null);
    }

    private static File getModDir(ModDef mod) {
        File modDir = new File(new File(RECIPES_DIR, mod.modid), mod.stamp);
        if (!modDir.exists() && !modDir.mkdirs()) {
            throw new RuntimeException("Cannot mkdir " + modDir);
        }
        return modDir;
    }

    private static final File getOutFile(File modDir, ResourceLocation rid) {
        File f;
        if (!rid.func_110623_a().contains("/")) {
            f = new File(modDir, rid.func_110623_a() + ".json");
        } else {
            int j = rid.func_110623_a().lastIndexOf(47);
            f = new File(modDir, rid.func_110623_a().substring(0, j));
            try {
                FileUtils.forceMkdir((File)f);
            }
            catch (IOException ioX) {
                throw new RuntimeException(ioX);
            }
            f = new File(f, rid.func_110623_a().substring(j + 1) + ".json");
        }
        return f;
    }

    public static final void newShapedOreRecipe(@Nonnull ResourceLocation rid, int flags, @Nonnull ItemStack result, Object ... recipe) {
        Validate.notNull((Object)rid, (String)"Non-null recipe id required", (Object[])new Object[0]);
        ModDef mod = _current_modDef.get();
        if (mod != null) {
            File modDir = JR.getModDir(mod);
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            JR.conditions(mod, flags, json);
            json.put("result", JR.serialize(mod, result, 1));
            json.put("type", "crafting_shaped");
            int keych0 = 0;
            ArrayList<String> pattern = new ArrayList<String>();
            for (Object ro : recipe) {
                if (!(ro instanceof String)) break;
                pattern.add(ro.toString());
                ++keych0;
            }
            json.put("pattern", pattern);
            LinkedHashMap<String, Map<String, Object>> keymap = new LinkedHashMap<String, Map<String, Object>>();
            for (int i = keych0; i < recipe.length; i += 2) {
                keymap.put(recipe[i].toString(), JR.serialize(mod, recipe[i + 1], 0));
            }
            json.put("key", keymap);
            File f = JR.getOutFile(modDir, rid);
            try (FileWriter w = new FileWriter(f);){
                JsonWriter jw = GSON_out.newJsonWriter(Streams.writerForAppendable((Appendable)w));
                jw.setIndent(" ");
                GSON_out.toJson(json, json.getClass(), jw);
            }
            catch (IOException ioX) {
                throw new RuntimeException(ioX);
            }
        }
    }

    public static final void newShapedOreRecipe(@Nonnull ResourceLocation rid, @Nonnull ItemStack result, Object ... recipe) {
        JR.newShapedOreRecipe(rid, 0, result, recipe);
    }

    public static final void newShapelessOreRecipe(@Nonnull ResourceLocation rid, int flags, @Nonnull ItemStack result, Object ... recipe) {
        Validate.notNull((Object)rid, (String)"Non-null recipe id required", (Object[])new Object[0]);
        ModDef mod = _current_modDef.get();
        if (mod != null) {
            File modDir = JR.getModDir(mod);
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            JR.conditions(mod, flags, json);
            json.put("result", JR.serialize(mod, result, 1));
            json.put("type", "crafting_shapeless");
            ArrayList<Map<String, Object>> inglist = new ArrayList<Map<String, Object>>();
            for (Object ro : recipe) {
                inglist.add(JR.serialize(mod, ro, 0));
            }
            json.put("ingredients", inglist);
            File f = JR.getOutFile(modDir, rid);
            try (FileWriter w = new FileWriter(f);){
                JsonWriter jw = GSON_out.newJsonWriter(Streams.writerForAppendable((Appendable)w));
                jw.setIndent(" ");
                GSON_out.toJson(json, json.getClass(), jw);
            }
            catch (IOException ioX) {
                throw new RuntimeException(ioX);
            }
        }
    }

    public static final void newShapelessOreRecipe(@Nonnull ResourceLocation rid, @Nonnull ItemStack result, Object ... recipe) {
        JR.newShapelessOreRecipe(rid, 0, result, recipe);
    }

    private static Map<String, Object> serialize(ModDef mod, Object o, int flags) {
        if (o instanceof Block) {
            return JR.serialize(mod, new ItemStack((IItemProvider)((Block)o)), flags);
        }
        if (o instanceof Item) {
            return JR.serialize(mod, new ItemStack((IItemProvider)((Item)o)), flags);
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77952_i() > 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (flags > 0 && stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (flags > 0 && stack.func_77942_o()) {
                ret.put("nbt", String.valueOf(stack.func_77978_p()));
            }
            return ret;
        }
        if (o instanceof String) {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            String tag = o.toString();
            String alt = mod.rconstant(tag);
            if (alt != null) {
                ret.put("tag", alt);
            } else {
                ret.put("tag", RID._s(tag));
            }
            return ret;
        }
        throw new IllegalArgumentException("Object not a block, item, stack, or tag name: " + o);
    }

    private static void conditions(ModDef mod, int flags, Map<String, Object> json) {
        if (flags > 0) {
            ArrayList conditions = new ArrayList();
            LinkedHashMap<String, String> c = new LinkedHashMap<String, String>();
            c.put("type", "forge:mod_loaded");
            if ((flags & 2) == 2) {
                c.put("modid", "vanillafoodpantry");
            } else if ((flags & 4) == 4) {
                c.put("modid", "superblocks");
            } else if ((flags & 8) == 8) {
                c.put("modid", "smarthoppers");
            } else if ((flags & 0x10) == 16) {
                c.put("type", "forge:item_exists");
                c.put("item", "*FIXME*");
            } else {
                c.put("modid", "*FIXME*");
            }
            conditions.add(c);
            json.put("conditions", conditions);
        }
    }

    public static ShapelessRecipe readShapeless(ResourceLocation rid, JsonObject json) {
        return (ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199425_a_(rid, json);
    }

    public static void writeShapeless(PacketBuffer to, ShapelessRecipe recipe) {
        IRecipeSerializer.field_222158_b.func_199427_a_(to, (IRecipe)recipe);
    }

    public static ShapelessRecipe readShapeless(ResourceLocation rid, PacketBuffer from) {
        return (ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199426_a_(rid, from);
    }

    public static ShapedRecipe readShaped(ResourceLocation rid, JsonObject json) {
        return (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(rid, json);
    }

    public static void writeShaped(PacketBuffer to, ShapedRecipe recipe) {
        IRecipeSerializer.field_222157_a.func_199427_a_(to, (IRecipe)recipe);
    }

    public static ShapedRecipe readShaped(ResourceLocation rid, PacketBuffer from) {
        return (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(rid, from);
    }

    public static CampfireCookingRecipe readCampfire(ResourceLocation rid, JsonObject json) {
        return (CampfireCookingRecipe)IRecipeSerializer.field_222174_r.func_199425_a_(rid, json);
    }

    public static void writeCampfire(PacketBuffer to, CampfireCookingRecipe recipe) {
        IRecipeSerializer.field_222174_r.func_199427_a_(to, (AbstractCookingRecipe)recipe);
    }

    public static CampfireCookingRecipe readCampfire(ResourceLocation rid, PacketBuffer from) {
        return (CampfireCookingRecipe)IRecipeSerializer.field_222174_r.func_199426_a_(rid, from);
    }

    @Nullable
    static final Ingredient readFallbackBucket(JsonObject json) {
        IngredientNBTSensitive fallback_bucket = null;
        if (json.has("mod_bucket")) {
            JsonElement e = json.get("mod_bucket");
            if (e.isJsonObject()) {
                ItemStack owned_bucket = CraftingHelper.getItemStack((JsonObject)e.getAsJsonObject(), (boolean)true);
                if (!owned_bucket.func_190926_b()) {
                    fallback_bucket = new IngredientNBTSensitive(owned_bucket);
                }
            } else {
                String descriptor = e.getAsString();
                if (descriptor.charAt(0) == '#') {
                    Tag<Item> tag = RID.getTag(descriptor.substring(1));
                    if (tag != null) {
                        fallback_bucket = Ingredient.func_199805_a(tag);
                    }
                } else {
                    ItemStack owned_bucket;
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(descriptor));
                    ItemStack itemStack = owned_bucket = SharedGlue.isDefined(item) ? ItemStacks.create(item) : ItemStack.field_190927_a;
                    if (!owned_bucket.func_190926_b()) {
                        fallback_bucket = new IngredientNBTSensitive(owned_bucket);
                    }
                }
            }
        }
        return fallback_bucket;
    }

    @Nonnull
    public static final Ingredient readFullBucketIngredient(JsonObject json, @Nonnull IIngredientSerializer<? extends Ingredient> serializer) throws JsonSyntaxException {
        ItemStack filled_bucket;
        Ingredient fallback_bucket = JR.readFallbackBucket(json);
        String fluidName = JSONUtils.func_151219_a((JsonObject)json, (String)"fluid", null);
        String tag = JSONUtils.func_151219_a((JsonObject)json, (String)"fluid_tag", (String)fluidName);
        Fluid fluid = Fluids.getFluidOrNull(fluidName);
        if (fluid == null && tag == null) {
            if (fallback_bucket != null) {
                return fallback_bucket;
            }
            throw new JsonSyntaxException("Unregistered fluid '" + fluidName + "' and no fluid tag given");
        }
        if (fluid == null) {
            Object out = null;
            if (fallback_bucket != null) {
                NonNullList both = NonNullList.func_191196_a();
                both.add((Object)fallback_bucket);
                both.add((Object)new BucketTaggedFluidIngredient(tag));
                out = new CompoundIngredientNBTSensitive((List<Ingredient>)both);
            } else {
                out = new BucketTaggedFluidIngredient(tag);
            }
            return out;
        }
        FluidStack contents = new FluidStack(fluid, 1000);
        if (json.has("nbt")) {
            try {
                JsonElement e = json.get("nbt");
                CompoundNBT nbt = e.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(e)) : JsonToNBT.func_180713_a((String)e.getAsString());
                contents = new FluidStack(fluid, 1000, nbt);
            }
            catch (Throwable malformX) {
                malformX.printStackTrace();
                throw new JsonSyntaxException("Unable to read fluid NBT because '" + malformX.getMessage() + "'");
            }
        }
        if ((filled_bucket = FluidUtil.getFilledBucket((FluidStack)contents)).func_190926_b()) {
            if (fallback_bucket != null) {
                return fallback_bucket;
            }
            throw new JsonSyntaxException("No bucket found for fluid '" + fluidName + "'");
        }
        Object out = null;
        if (fallback_bucket != null) {
            NonNullList both = NonNullList.func_191196_a();
            both.add((Object)fallback_bucket);
            both.add((Object)new BucketFluidIngredient(filled_bucket, contents, tag));
            out = new CompoundIngredientNBTSensitive((List<Ingredient>)both);
        } else {
            out = new BucketFluidIngredient(filled_bucket, contents, tag, serializer);
        }
        return out;
    }

    @Nonnull
    public static final Ingredient readFillableBucketOrTank(JsonObject json) {
        Ingredient fallback_bucket = JR.readFallbackBucket(json);
        Object out = null;
        if (fallback_bucket != null) {
            NonNullList both = NonNullList.func_191196_a();
            both.add((Object)fallback_bucket);
            both.add((Object)INGREDIENT_FILLABLE_BUCKET_SERIALIZER.parse(json));
            out = new CompoundIngredientNBTSensitive((List<Ingredient>)both);
        } else {
            out = INGREDIENT_FILLABLE_BUCKET_SERIALIZER.parse(json);
        }
        return out;
    }

    public static final void initRecipeSupport() {
        CraftingHelper.register((IConditionSerializer)TagIsPresentCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)AllTagsPresentCondition.Serializer.INSTANCE);
        SMELTING_RECIPE_SERIALIZER = (MultiItemCookingRecipeSerializer)IRecipeSerializer.func_222156_a((String)LibInfo.rstring("smelting"), new MultiItemCookingRecipeSerializer<AbstractCookingRecipe>(MultiItemFurnaceRecipe::new, 200));
        SMOKER_RECIPE_SERIALIZER = (MultiItemCookingRecipeSerializer)IRecipeSerializer.func_222156_a((String)LibInfo.rstring("smoking"), new MultiItemCookingRecipeSerializer<AbstractCookingRecipe>(MultiItemSmokerRecipe::new, 100));
        BLASTING_RECIPE_SERIALIZER = (MultiItemCookingRecipeSerializer)IRecipeSerializer.func_222156_a((String)LibInfo.rstring("blasting"), new MultiItemCookingRecipeSerializer<AbstractCookingRecipe>(MultiItemBlastFurnaceRecipe::new, 100));
        IRecipeSerializer.func_222156_a((String)LibInfo.rstring("crafting_shapeless"), MultiuseShapelessRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)LibInfo.rstring("crafting_shaped"), MultiuseShapedRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)LibInfo.rstring("campfire_cooking"), NBTSensitiveCampfireRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)LibInfo.rstring("cleanwipe_shapeless"), NoLeftoversShapelessRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)LibInfo.rstring("cleanwipe_shaped"), NoLeftoversShapedRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)LibInfo.rstring("crafting_special_dyeable"), (IRecipeSerializer)DyeableDyeRecipe.Serializer.INSTANCE);
        IRecipeSerializer.func_222156_a((String)LibInfo.rstring("sampling_shapeless"), ExampleShapelessRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)LibInfo.rstring("sampling_shaped"), ExampleShapedRecipe.SERIALIZER);
    }

    static final ItemStack safeNotifyCookedOrCrafted(ItemStack output) {
        try {
            if (!output.func_190926_b() && output.func_77973_b() instanceof IModItem) {
                ((IModItem)output.func_77973_b()).onCookedOrCrafted(output);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return output;
    }

    public static NonNullList<ItemStack> defaultRecipeGetRemainingItems(@Nonnull CraftingInventory grid) {
        NonNullList leftovers = NonNullList.func_191197_a((int)grid.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < leftovers.size(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (next.func_190926_b()) continue;
            leftovers.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)next));
        }
        return leftovers;
    }

    static {
        INGREDIENT_TAGGED_FLUID_BUCKET_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("tagged_fluid_bucket"), (IIngredientSerializer)new BucketTaggedFluidIngredient.Serializer());
        INGREDIENT_FLUID_BUCKET_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("fluid_bucket"), (IIngredientSerializer)new BucketFluidIngredient.Serializer());
        INGREDIENT_FILLED_UNIVERSAL_BUCKET_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("filled_bucket"), (IIngredientSerializer)new FilledUniversalBucketIngredientSerializer());
        INGREDIENT_FILLABLE_BUCKET_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("fillable_bucket"), (IIngredientSerializer)new FillableTankIngredient.Serializer());
        INGREDIENT_FILLABLE_BUCKET_OR_TANK_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("fillable_tank"), (IIngredientSerializer)new FillableBucketOrTankIngredientSerializer());
    }

    static final class FillableBucketOrTankIngredientSerializer
    implements IIngredientSerializer<Ingredient> {
        FillableBucketOrTankIngredientSerializer() {
        }

        public Ingredient parse(JsonObject json) {
            return JR.readFillableBucketOrTank(json);
        }

        public void write(PacketBuffer to, Ingredient ingredient) {
            CraftingHelper.write((PacketBuffer)to, (Ingredient)ingredient);
        }

        public Ingredient parse(PacketBuffer from) {
            return Ingredient.func_199566_b((PacketBuffer)from);
        }
    }

    static final class FilledUniversalBucketIngredientSerializer
    implements IIngredientSerializer<Ingredient> {
        FilledUniversalBucketIngredientSerializer() {
        }

        public Ingredient parse(JsonObject json) {
            return JR.readFullBucketIngredient(json, INGREDIENT_FLUID_BUCKET_SERIALIZER);
        }

        public void write(PacketBuffer to, Ingredient ingredient) {
            CraftingHelper.write((PacketBuffer)to, (Ingredient)ingredient);
        }

        public Ingredient parse(PacketBuffer from) {
            return Ingredient.func_199566_b((PacketBuffer)from);
        }
    }

    public static final class ExampleShapedRecipe
    extends ShapedRecipeWrapping {
        public static final ShapedRecipeWrapping.Serializer<ExampleShapedRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer<ExampleShapedRecipe>(ExampleShapedRecipe::new);

        ExampleShapedRecipe(ShapedRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }

        @Override
        public ItemStack func_77572_b(CraftingInventory grid) {
            return ItemStack.field_190927_a;
        }

        public boolean func_77569_a(CraftingInventory grid, World unused) {
            return false;
        }
    }

    public static final class ExampleShapelessRecipe
    extends NoLeftoversShapelessRecipe {
        public static final ShapelessRecipeWrapping.Serializer<ExampleShapelessRecipe> SERIALIZER = new ShapelessRecipeWrapping.Serializer<ExampleShapelessRecipe>(ExampleShapelessRecipe::new);

        ExampleShapelessRecipe(ShapelessRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }

        @Override
        public ItemStack func_77572_b(CraftingInventory grid) {
            return ItemStack.field_190927_a;
        }

        public boolean func_77569_a(CraftingInventory grid, World unused) {
            return false;
        }
    }

    public static class NoLeftoversShapedRecipe
    extends ShapedRecipeWrapping {
        public static final ShapedRecipeWrapping.Serializer<NoLeftoversShapedRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer<NoLeftoversShapedRecipe>(NoLeftoversShapedRecipe::new);

        NoLeftoversShapedRecipe(ShapedRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }

        public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
            return SharedGlue.emptyNonNullItemStackList(grid.func_70302_i_());
        }
    }

    public static class NoLeftoversShapelessRecipe
    extends ShapelessRecipeWrapping {
        public static final ShapelessRecipeWrapping.Serializer<NoLeftoversShapelessRecipe> SERIALIZER = new ShapelessRecipeWrapping.Serializer<NoLeftoversShapelessRecipe>(NoLeftoversShapelessRecipe::new);

        NoLeftoversShapelessRecipe(ShapelessRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }

        public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
            return SharedGlue.emptyNonNullItemStackList(grid.func_70302_i_());
        }
    }

    public static class MultiuseShapedRecipe
    extends ShapedRecipeWrapping {
        public static final ShapedRecipeWrapping.Serializer<MultiuseShapedRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer<MultiuseShapedRecipe>(MultiuseShapedRecipe::new);

        MultiuseShapedRecipe(ShapedRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }
    }

    public static class MultiuseShapelessRecipe
    extends ShapelessRecipeWrapping {
        public static final ShapelessRecipeWrapping.Serializer<MultiuseShapelessRecipe> SERIALIZER = new ShapelessRecipeWrapping.Serializer<MultiuseShapelessRecipe>(MultiuseShapelessRecipe::new);

        MultiuseShapelessRecipe(ShapelessRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }
    }

    public static class NBTSensitiveCampfireRecipe
    extends CampfireRecipeWrapping {
        public static final CampfireRecipeWrapping.Serializer<NBTSensitiveCampfireRecipe> SERIALIZER = new CampfireRecipeWrapping.Serializer<NBTSensitiveCampfireRecipe>(NBTSensitiveCampfireRecipe::new);

        NBTSensitiveCampfireRecipe(CampfireCookingRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }
    }

    public static final class FillableTankIngredient
    extends Ingredient {
        final int _min_mB;
        final boolean _want_empty;
        public static final Ingredient ForEmptyBucket = new FillableTankIngredient(1000, true);
        public static final Ingredient ForBucket = new FillableTankIngredient(1000, false);

        public FillableTankIngredient(int mB, boolean empty) {
            super(Stream.empty());
            this._min_mB = mB;
            this._want_empty = empty;
        }

        public boolean test(@Nullable ItemStack input) {
            boolean match = false;
            IFluidHandlerItem fspi = ItemStacks.getFluidHandler(input);
            if (fspi != null) {
                for (int i = 0; i < fspi.getTanks(); ++i) {
                    FluidStack contents;
                    int cap = fspi.getTankCapacity(i);
                    if (cap < this._min_mB || !(contents = fspi.getFluidInTank(i)).isEmpty() && cap - contents.getAmount() < this._min_mB) continue;
                    match = !this._want_empty || this._want_empty && (contents.isEmpty() || contents.getAmount() == 0);
                    break;
                }
            }
            return match;
        }

        public boolean isSimple() {
            return false;
        }

        public boolean func_203189_d() {
            return false;
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return INGREDIENT_FILLABLE_BUCKET_SERIALIZER;
        }

        public static final class Serializer
        implements IIngredientSerializer<FillableTankIngredient> {
            public void write(PacketBuffer to, FillableTankIngredient ingredient) {
                to.writeBoolean(ingredient._want_empty);
                to.func_150787_b(ingredient._min_mB);
            }

            public FillableTankIngredient parse(PacketBuffer from) {
                boolean empty = from.readBoolean();
                int mB = from.func_150792_a();
                return new FillableTankIngredient(mB, empty);
            }

            public FillableTankIngredient parse(JsonObject json) {
                int min_mB = 1000;
                int fillAmount = JSONUtils.func_151208_a((JsonObject)json, (String)"min_capacity", (int)-1);
                if (fillAmount > 0) {
                    min_mB = fillAmount;
                }
                boolean empty = JSONUtils.func_151209_a((JsonObject)json, (String)"empty", (boolean)false);
                return new FillableTankIngredient(min_mB, empty);
            }
        }
    }

    public static final class BucketFluidIngredient
    extends IngredientNBT {
        final FluidStack _match;
        @Nonnull
        final String _match_tag;
        final boolean _distinct;
        final IIngredientSerializer<? extends Ingredient> _serializer;

        BucketFluidIngredient(ItemStack bucket_sample, @Nonnull IIngredientSerializer<? extends Ingredient> serializer) {
            super(bucket_sample);
            Validate.isTrue((!bucket_sample.func_190926_b() ? 1 : 0) != 0);
            FluidStack f = (FluidStack)FluidUtil.getFluidContained((ItemStack)bucket_sample).orElse(null);
            if (f == null) {
                throw new IllegalArgumentException("Unable to find fluid from input stack: " + bucket_sample);
            }
            this._match = f;
            this._distinct = false;
            this._match_tag = "";
            this._serializer = Objects.requireNonNull(serializer);
        }

        public BucketFluidIngredient(ItemStack bucket_sample) {
            this(bucket_sample, INGREDIENT_FLUID_BUCKET_SERIALIZER);
        }

        BucketFluidIngredient(ItemStack mod_bucket, @Nonnull FluidStack f, @Nullable String tag, @Nonnull IIngredientSerializer<? extends Ingredient> serializer) {
            super(mod_bucket);
            Validate.isTrue((!mod_bucket.func_190926_b() ? 1 : 0) != 0);
            Validate.notNull((Object)f, (String)"A non-null fluid stack is required (use EMPTY for tag only matching)", (Object[])new Object[0]);
            this._match = f;
            this._distinct = !f.isEmpty();
            this._match_tag = StringUtils.trimToEmpty((String)tag);
            this._serializer = Objects.requireNonNull(serializer);
        }

        public BucketFluidIngredient(ItemStack mod_bucket, @Nonnull FluidStack f, @Nullable String tag) {
            this(mod_bucket, f, tag, INGREDIENT_FLUID_BUCKET_SERIALIZER);
        }

        public boolean test(@Nullable ItemStack input) {
            if (Fluids.isBucketOf(input, this._match, this._match_tag)) {
                return true;
            }
            return super.test(input);
        }

        public boolean isSimple() {
            return false;
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return this._serializer;
        }

        public static final class Serializer
        implements IIngredientSerializer<BucketFluidIngredient> {
            @Nullable
            static final FluidStack readFluidOrNull(PacketBuffer from) {
                try {
                    FluidStack fs = FluidStack.readFromPacket((PacketBuffer)from);
                    return fs.isEmpty() ? null : fs;
                }
                catch (Throwable t) {
                    return null;
                }
            }

            public void write(PacketBuffer to, BucketFluidIngredient ingredient) {
                to.writeBoolean(ingredient._distinct);
                IngredientNBT.Serializer.INSTANCE.write(to, (IngredientNBT)ingredient);
                to.func_180714_a(ingredient._match_tag);
                if (ingredient._distinct) {
                    ingredient._match.writeToPacket(to);
                }
            }

            public BucketFluidIngredient parse(PacketBuffer from) {
                boolean distinct = from.readBoolean();
                ItemStack mod_bucket = from.func_150791_c();
                String tag = from.func_218666_n();
                FluidStack fs = null;
                if (distinct) {
                    fs = Serializer.readFluidOrNull(from);
                }
                if (fs == null && !tag.isEmpty()) {
                    fs = FluidStack.EMPTY;
                }
                return fs == null ? new BucketFluidIngredient(mod_bucket, this) : new BucketFluidIngredient(mod_bucket, fs, tag, this);
            }

            public BucketFluidIngredient parse(JsonObject json) {
                String tag = JSONUtils.func_151219_a((JsonObject)json, (String)"fluid_tag", (String)"");
                FluidStack fs = null;
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"fluid")) {
                    CompoundNBT fluidnbt = JsonUtils.readNBT((JsonObject)json, (String)"fluid");
                    fs = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidnbt);
                    if (fs.isEmpty() && tag.isEmpty()) {
                        fs = null;
                    }
                } else if (!tag.isEmpty()) {
                    fs = FluidStack.EMPTY;
                }
                ItemStack mod_bucket = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
                return fs == null ? new BucketFluidIngredient(mod_bucket, this) : new BucketFluidIngredient(mod_bucket, fs, tag, this);
            }
        }
    }

    public static final class BucketTaggedFluidIngredient
    extends Ingredient {
        @Nonnull
        final String _match_tag;

        public BucketTaggedFluidIngredient(String tag) {
            super(Stream.empty());
            this._match_tag = Objects.requireNonNull(tag);
        }

        public boolean test(@Nullable ItemStack input) {
            return Fluids.isBucketOf(input, FluidStack.EMPTY, this._match_tag);
        }

        public boolean isSimple() {
            return false;
        }

        public boolean func_203189_d() {
            return false;
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return INGREDIENT_TAGGED_FLUID_BUCKET_SERIALIZER;
        }

        public static final class Serializer
        implements IIngredientSerializer<BucketTaggedFluidIngredient> {
            public void write(PacketBuffer to, BucketTaggedFluidIngredient ingredient) {
                to.func_180714_a(ingredient._match_tag);
            }

            public BucketTaggedFluidIngredient parse(PacketBuffer from) {
                return new BucketTaggedFluidIngredient(from.func_218666_n());
            }

            public BucketTaggedFluidIngredient parse(JsonObject json) {
                return new BucketTaggedFluidIngredient(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid_tag"));
            }
        }
    }

    public static final class CompoundIngredientNBTSensitive
    extends CompoundIngredient {
        public CompoundIngredientNBTSensitive(List<Ingredient> children) {
            super(children);
        }

        public boolean func_203189_d() {
            return this.getChildren().isEmpty();
        }
    }

    public static final class IngredientNBTSensitive
    extends IngredientNBT {
        public IngredientNBTSensitive(ItemStack stack) {
            super(stack);
        }
    }

    public static final class ModDef {
        public final String modid;
        public final String stamp;
        public boolean legacymode = true;
        public Map<String, String> rconstants = Collections.emptyMap();

        ModDef(String id) {
            this.modid = id;
            this.stamp = STAMP_FORMAT.format(System.currentTimeMillis());
        }

        @Nullable
        String rconstant(String oreid) {
            return this.rconstants.get(oreid);
        }
    }
}

