/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.worldgen;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.Tags;
import org.jwaresoftware.mcmods.lib.BlockXyz;

public class OpenOreFeatureConfig
implements IFeatureConfig {
    public static final Predicate<BlockXyz> IS_STONE = xyz -> xyz.state.func_177230_c() == Blocks.field_150348_b;
    public static final Predicate<BlockXyz> IS_CLAY = xyz -> xyz.state.func_177230_c() == Blocks.field_150435_aG;
    public static final Predicate<BlockXyz> IS_NETHERRACK = xyz -> xyz.state.func_177230_c() == Blocks.field_150424_aL;
    public static final Predicate<BlockXyz> IS_ENDSTONE = xyz -> xyz.state.func_177230_c() == Blocks.field_150377_bs;
    private static final HashBiMap<Predicate<BlockXyz>, String> _BUILTINS = HashBiMap.create();
    public final Predicate<BlockXyz> match;
    public final int veinsize;
    public final BlockState replacement;
    private Tag<Block> _in;

    public OpenOreFeatureConfig(BlockState repl, int veinsize, @Nonnull Predicate<BlockXyz> test) {
        this.replacement = repl;
        this.veinsize = veinsize;
        this.match = Objects.requireNonNull(test);
    }

    public OpenOreFeatureConfig(BlockState replacement, int veinsize, Tag<Block> in) {
        this(replacement, veinsize, (BlockXyz xyz) -> xyz.state.func_177230_c().func_203417_a(in));
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        String tagid = (String)_BUILTINS.getOrDefault(this.match, (Object)(this._in != null ? this._in.func_199886_b().toString() : ""));
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("size"), (Object)ops.createInt(this.veinsize), (Object)ops.createString("tag"), (Object)ops.createString(tagid), (Object)ops.createString("repl"), (Object)BlockState.func_215689_a(ops, (BlockState)this.replacement).getValue())));
    }

    public static OpenOreFeatureConfig deserialize(Dynamic<?> dynamic) {
        int vsize = dynamic.get("size").asInt(0);
        String rid = dynamic.get("tag").asString("");
        BlockState repl = dynamic.get("repl").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
        Tag target = null;
        if (!rid.isEmpty()) {
            Predicate builtin = (Predicate)_BUILTINS.inverse().get((Object)rid);
            if (builtin != null) {
                return new OpenOreFeatureConfig(repl, vsize, builtin);
            }
            ResourceLocation r = ResourceLocation.func_208304_a((String)rid);
            if (r != null) {
                target = BlockTags.func_199896_a().func_199910_a(r);
            }
        }
        if (target == null) {
            target = Tags.Blocks.STONE;
        }
        return new OpenOreFeatureConfig(repl, vsize, (Tag<Block>)target);
    }

    static {
        _BUILTINS.put(IS_STONE, (Object)"!1");
        _BUILTINS.put(IS_CLAY, (Object)"!2");
        _BUILTINS.put(IS_NETHERRACK, (Object)"!3");
        _BUILTINS.put(IS_ENDSTONE, (Object)"!4");
    }
}

