/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.vfp.agents.CarbonationBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.agents.LavaSandFuelHandler;
import org.jwaresoftware.mcmods.vfp.agents.RennetBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.SaltBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.StarterYeast;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.milk.MilkPortion;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelper;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;
import org.jwaresoftware.mcmods.vfp.water.BucketOfPotableWater;
import org.jwaresoftware.mcmods.vfp.water.WaterBottlesBuildHelper;

public final class AgentsBuildHelper
extends VfpBuildHelperSupport {
    private WaterBottlesBuildHelper _waterHelper = new WaterBottlesBuildHelper();
    private RennetBuildHelper _rennetHelper = new RennetBuildHelper();
    private SaltBuildHelper _saltHelper = new SaltBuildHelper();
    private CarbonationBuildHelper _carbHelper = new CarbonationBuildHelper();
    private JuJuExtensions _jujuHelper = new JuJuExtensions();
    private final VfpBuildHelper[] _subBuilders = new VfpBuildHelper[5];

    public AgentsBuildHelper() {
        this._subBuilders[0] = this._waterHelper;
        this._subBuilders[1] = this._saltHelper;
        this._subBuilders[2] = this._carbHelper;
        this._subBuilders[3] = this._rennetHelper;
        this._subBuilders[4] = this._jujuHelper;
    }

    @Override
    protected String categoryName() {
        return "Additives";
    }

    @Override
    public void installEventBusHandlers(IModRuntime runtime) {
        MinecraftForge.EVENT_BUS.register((Object)new LavaSandFuelHandler());
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.installEventBusHandlers(runtime);
        }
    }

    @Override
    public void makeObjects(IModRuntime runtime) {
        VfpObj.Bit_Pipette_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Bit_Pipette);
        VfpObj.Water_Portion_obj = VfpBuilder.newAdditive(VfpOid.Portion_Water, SharedGlue.CreativeTabs_materials);
        VfpObj.Portion_Sugar_obj = VfpBuilder.newAdditive(VfpOid.Portion_Sugar);
        VfpObj.Dried_Seeds_obj = VfpBuilder.newCompostableItem(VfpOid.Dried_Seeds, 0.25f);
        VfpObj.Starter_Yeast_obj = new StarterYeast();
        VfpObj.Leavening_Agent_obj = VfpBuilder.newAdditive(VfpOid.Leavening_Agent);
        VfpObj.Leavening_Agent_Ball_obj = VfpBuilder.newAdditive(VfpOid.Leavening_Agent_Ball);
        VfpObj.Leavening_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Leavening_Agent_Pantry_Block, VfpObj.Leavening_Agent_Ball_obj);
        VfpObj.Drying_Agent_Unprocessed_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Unprocessed);
        VfpObj.Drying_Agent_Unprocessed_Ball_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Unprocessed_Ball);
        VfpObj.Drying_Agent_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent);
        VfpObj.Drying_Agent_Ball_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Ball);
        VfpObj.Drying_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Drying_Agent_Pantry_Block, VfpObj.Drying_Agent_Ball_obj);
        this._saltHelper.makeObjects(runtime);
        this._carbHelper.makeObjects(runtime);
        VfpObj.Milk_Portion_obj = new MilkPortion();
        this._rennetHelper.makeObjects(runtime);
        VfpObj.Heat_Portion_obj = VfpBuilder.newMisc(VfpOid.Portion_Heat);
        VfpObj.Lava_Sand_Portion_obj = VfpBuilder.newMisc(VfpOid.Lava_Sand);
        VfpObj.Lava_Sand_Pack_obj = VfpBuilder.newMisc(VfpOid.Pack_Lava_Sand);
        VfpObj.Lava_Sand_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Lava_Sand_Block, Blocks.field_150354_m, VfpObj.Lava_Sand_Pack_obj);
        this._waterHelper.makeObjects(runtime);
        VfpObj.Bucket_Potable_Water_obj = new BucketOfPotableWater();
        this._jujuHelper.makeObjects(runtime);
        VfpObj.Cocoa_Seedmush_obj = VfpBuilder.newCompostableItem(VfpOid.Seedmush_Cocoa, 0.35f);
        VfpObj.Raw_Caffeine_obj = VfpBuilder.newItem(VfpOid.Raw_Caffeine).setContainerItem(VfpObj.Empty_Bottle_obj);
        VfpObj.Fizzing_Agent_obj = VfpBuilder.newAdditive(VfpOid.Fizzing_Agent);
        VfpObj.Fizzing_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Fizzing_Agent_Pantry_Block, Blocks.field_150354_m, VfpObj.Fizzing_Agent_obj);
        VfpObj.Whisk_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Whisk);
        VfpObj.Rolling_Pin_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Rolling_Pin);
        VfpObj.Fermenting_Bucket_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Fermenting_Bucket);
        FoodPowder.makeObjects();
    }

    @Override
    public void makeObjectsFinalPass(IModRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.makeObjectsFinalPass(runtime);
        }
    }

    @Override
    public void linkObjects(IModRuntime runtime) {
        VfpObj.Lava_Sand_BlockItem_obj = VfpObj.Lava_Sand_Block_obj.func_199767_j();
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkObjects(runtime);
        }
    }

    @Override
    public void linkLikeFoods(IModRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkLikeFoods(runtime);
        }
    }

    @Override
    public void addDictionaryEntries(IModRuntime runtime) {
        Item[] seeds;
        VfpConfig config = (VfpConfig)runtime.getConfig();
        RID.addToGroup((String)"carrots:bit_measure", (Item)VfpObj.Bit_Pipette_obj);
        RID.addToGroup((String)"carrots:additives/scaffold_item", (Item)VfpObj.Dried_Seeds_obj);
        RID.addToGroup((String)"carrots:whisks", (Item)VfpObj.Whisk_obj);
        RID.addToGroup((String)"carrots:portions_small_sugar", (Item)VfpObj.Portion_Sugar_obj);
        RID.addToGroup((String)"carrots:fermenting_bucket", (Item)VfpObj.Fermenting_Bucket_obj);
        RID.addToGroup((String)"foods/apples", (Item)Items.field_151034_e);
        RID.addToGroup((String)"carrots:portions_small_heat", (Item)VfpObj.Heat_Portion_obj);
        RID.addToGroup((String)"carrots:portions_heat", (Item)VfpObj.Lava_Sand_Portion_obj);
        RID.addToGroup((String)"carrots:portions_large_heat", (Item)Items.field_151129_at);
        RID.addToGroup((String)"dusts/lava", (Item)VfpObj.Lava_Sand_Portion_obj);
        RID.addToGroup((String)"carrots:portions_small_water", (Item)VfpObj.Water_Portion_obj);
        RID.addToGroup((String)"carrots:portions_large_water", (Item)VfpObj.Water_Bucket_obj);
        if (!config.useTreatedWaterRecipes()) {
            RID.addToGroup((String)"carrots:portions_large_potable_water", (Item)VfpObj.Water_Bucket_obj);
        }
        RID.addToGroup((String)"carrots:portions_large_water", (Item)VfpObj.Bucket_Potable_Water_obj);
        RID.addToGroup((String)"carrots:portions_large_potable_water", (Item)VfpObj.Bucket_Potable_Water_obj);
        RID.addToGroup((String)"empty_bottles", (Item)VfpObj.Empty_Bottle_obj);
        RID.addToGroup((String)"water_bottles", (ItemStack)VfpObj.Water_Bottle_obj);
        RID.addToGroup((String)"carrots:curatives/foods", (Item)VfpObj.Milk_Portion_obj);
        RID.addToGroup((String)"carrots:curatives/foods", (Item)VfpObj.Bucket_Potable_Water_obj);
        RID.addToGroup((String)"carrots:additives/fermenting", (ItemStack)new ItemStack((IItemProvider)VfpObj.Starter_Yeast_obj));
        RID.addToGroup((String)"carrots:additives/fermenting", (Block)Blocks.field_150338_P);
        RID.addToGroup((String)"carrots:additives/fermenting", (Block)Blocks.field_150337_Q);
        for (Item seed : seeds = new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU}) {
            RID.addToGroup((String)"carrots:additives/scaffold_item", (Item)seed);
            RID.addToGroup((String)"seeds/dryable", (Item)seed);
        }
        RID.addToGroup((String)"storage_blocks/leavening_agent", (Block)VfpObj.Leavening_Agent_Pantry_Block_obj);
        RID.addToGroup((String)"ingots/leavening_agent", (Item)VfpObj.Leavening_Agent_Ball_obj);
        RID.addToGroup((String)"carrots:additives/leavening", (Item)VfpObj.Leavening_Agent_obj);
        RID.addToGroup((String)"poisonous_potatoes", (Item)Items.field_151170_bI);
        RID.addToGroup((String)"carrots:additives/drying", (Item)VfpObj.Drying_Agent_obj);
        RID.addToGroup((String)"ingots/drying_agent", (Item)VfpObj.Drying_Agent_Ball_obj);
        RID.addToGroup((String)"storage_blocks/drying_agent", (Block)VfpObj.Drying_Agent_Pantry_Block_obj);
        RID.addToGroup((String)"ingredients/caffeine", (Item)VfpObj.Raw_Caffeine_obj);
        RID.addToGroup((String)"bowls", (Item)Items.field_151054_z);
        RID.addToGroup((String)"ingredients/sweeteners", (Item)Items.field_151102_aT);
        RID.addToGroup((String)"ingredients/egg", (Item)Items.field_151110_aK);
        RID.addToGroup((String)"carrots:portions_raw_egg", (Item)Items.field_151110_aK);
        RID.addToGroup((String)"ingredients/ink", (Item)Items.field_196136_br);
        RID.addToGroup((String)"foods/wild_greens", (ItemStack)new ItemStack((IItemProvider)Items.field_221676_az));
        RID.addToGroup((String)"foods/wild_greens", (ItemStack)new ItemStack((IItemProvider)Items.field_221674_ay));
        RID.addToGroup((String)"foods/beets", (Item)Items.field_185164_cV);
        RID.addToGroup((String)"foods/potatoes", (Item)Items.field_151168_bH);
        RID.addToGroup((String)"foods/carrots", (Item)Items.field_151172_bF);
        RID.addToGroup((String)"rotten_flesh", (Item)Items.field_151078_bh);
        RID.addToGroup((String)"ingredients/cereal", (Item)Items.field_151015_O);
        RID.addToGroup((String)"foods/cookies", (Item)Items.field_151106_aX);
        RID.addToGroup((String)"ingredients/fish_chowder_main", (ItemStack)LikeFood.salmon.sample(1));
        RID.addToGroup((String)"ingredients/fish_chowder_filler", (ItemStack)LikeFood.fish.sample(1));
        RID.addToGroup((String)"ingredients/fish_sausage_main", (ItemStack)LikeFood.uncooked_fish.sample(1));
        RID.addToGroup((String)"carrots:portions_small_milk", (Item)VfpObj.Milk_Portion_obj);
        RID.addToGroup((String)"carrots:portions_large_milk", (Item)Items.field_151117_aB);
        ItemStack arrow = new ItemStack((IItemProvider)Items.field_151032_g);
        if (!arrow.func_190926_b()) {
            RID.addToGroup((String)"minecraft:arrows", (ItemStack)arrow);
        }
        RID.addToGroup((String)"carrots:water_treatments", (Item)VfpObj.Heat_Portion_obj);
        FoodPowder.addDictionaryEntries();
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.addDictionaryEntries(runtime);
        }
        this.identifyDictMushrooms(config);
        this.identifyDictMeats(config);
        this.identifyDictKebabItems(config);
        this.identifyDictEdibleFlowers(config);
    }

    @Override
    public void addLootEntries(IModRuntime runtime) {
        Loot.addFishedUpJunk((String)"vanillafoodpantry", (String)VfpOid.Bit_Pipette.fmlid(), (Item)VfpObj.Bit_Pipette_obj);
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.addLootEntries(runtime);
        }
    }

    @Override
    public void setRecipeRewards(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        int additive_count = VfpCapacity.ADDITIVE_BATCH.count();
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Leavening_Agent_obj, additive_count), VfpOid.Leavening_Agent.craftingXp());
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Drying_Agent_Unprocessed_obj, additive_count), VfpOid.Drying_Agent_Unprocessed.craftingXp());
        if (config.includePotionBrewing()) {
            BrewEffect.addWaterConversionFor((Item)VfpObj.Cocoa_Seedmush_obj, (Potion)VfpPotions.STRONG_STIMULANT);
            BrewEffect.addRecipeFor((Item)VfpObj.Cocoa_Seedmush_obj, (Potion)VfpPotions.STRONG_STIMULANT);
        }
        this._waterHelper.setRecipeRewards(runtime);
        this._saltHelper.setRecipeRewards(runtime);
        this._carbHelper.setRecipeRewards(runtime);
        FoodPowder.setRecipeRewards(runtime);
        this._rennetHelper.setRecipeRewards(runtime);
        this._jujuHelper.setRecipeRewards(runtime);
    }

    @Override
    public void sendApiMessages(IModRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.sendApiMessages(runtime);
        }
    }

    @Override
    public void finish(IModRuntime runtime) {
        FoodPowder.finishConfigFinally(runtime);
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.finish(runtime);
        }
    }

    private void identifyDictMushrooms(VfpConfig config) {
        RID.addToGroup((String)"foods/raw_mushrooms", (Block)Blocks.field_150338_P);
        RID.addToGroup((String)"ingredients/mushroom", (Block)Blocks.field_150338_P);
        RID.addToGroup((String)"foods/raw_mushrooms", (Block)Blocks.field_150337_Q);
        RID.addToGroup((String)"ingredients/mushroom", (Block)Blocks.field_150337_Q);
    }

    private void identifyDictMeats(VfpConfig config) {
        RID.addToGroup((String)"foods/raw_chickens", (Item)Items.field_151076_bf);
        RID.addToGroup((String)"foods/cooked_chickens", (Item)Items.field_151077_bg);
        RID.addToGroup((String)"foods/raw_red_meats", (Item)Items.field_151082_bd);
        RID.addToGroup((String)"foods/cooked_red_meats", (Item)Items.field_151083_be);
        RID.addToGroup((String)"foods/cooked_beefsteaks", (Item)Items.field_151083_be);
        RID.addToGroup((String)"foods/raw_red_meats", (Item)Items.field_179561_bm);
        RID.addToGroup((String)"foods/cooked_red_meats", (Item)Items.field_179557_bn);
        RID.addToGroup((String)"foods/cooked_game_meats", (Item)Items.field_151083_be);
        RID.addToGroup((String)"foods/cooked_game_meats", (Item)Items.field_179557_bn);
        RID.addToGroup((String)"foods/cooked_game_meats", (Item)Items.field_179559_bp);
    }

    private void identifyDictKebabItems(VfpConfig config) {
        RID.addToGroup((String)"ingredients/kebabs/veggie_filler", (Block)Blocks.field_150338_P);
        RID.addToGroup((String)"ingredients/kebabs/veggie_filler", (Block)Blocks.field_150337_Q);
        RID.addToGroup((String)"ingredients/kebabs/veggie_filler", (Item)Items.field_151172_bF);
        RID.addToGroup((String)"ingredients/kebabs/veggie_filler", (Item)Items.field_151174_bG);
        RID.addToGroup((String)"ingredients/kebabs/veggie_filler", (Item)Items.field_151034_e);
        RID.addToGroup((String)"ingredients/kebabs/veggie_filler", (Item)Items.field_185164_cV);
        RID.addToGroup((String)"ingredients/kebabs/fruit", (Item)Items.field_151034_e);
        RID.addToGroup((String)"ingredients/kebabs/fruit", (Item)Items.field_221794_dg);
        RID.addToGroup((String)"ingredients/kebabs/main", (Item)Items.field_151174_bG);
        RID.addToGroup((String)"ingredients/kebabs/main", (Item)Items.field_151168_bH);
        RID.addToGroup((String)"ingredients/kebabs/main", (Item)Items.field_151172_bF);
    }

    private void identifyDictEdibleFlowers(VfpConfig config) {
        Item[] flowers;
        for (Item flower : flowers = new Item[]{Items.field_221624_aZ, Items.field_221678_ba, Items.field_221680_bb, Items.field_221682_bc}) {
            RID.addToGroup((String)"foods/flowers", (Item)flower);
            RID.addToGroup((String)"ingredients/flowers", (Item)flower);
        }
        RID.addToGroup((String)"foods/flowers/roses", (Item)Items.field_221912_fn);
        RID.addToGroup((String)"ingredients/rose_flowers", (Item)Items.field_221912_fn);
    }
}

