/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.MushroomBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.DeferredWorkQueue;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.api.ICompostable;
import org.jwaresoftware.mcmods.lib.api.IFertilizer;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpFertilizerItem
extends VfpPlainItem
implements ICompostable,
IFertilizer {
    private static final int _BONEMEAL_DONE_SFX = 2005;
    private static final int _DISPENSE_DONE_SFX = 1000;
    private static final int _DISPENSE_FAIL_SFX = 1001;

    public VfpFertilizerItem(@Nonnull VfpProfile profile) {
        super(profile);
    }

    public VfpFertilizerItem(@Nonnull VfpProfile profile, Item.Properties ip) {
        super(profile, ip);
    }

    public float getCompostChance() {
        return 1.0f;
    }

    protected boolean isUsable(ItemUseContext context) {
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        Direction side = context.func_196000_l();
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        BlockPos hit_pos = context.func_195995_a();
        BlockPos growth_pos = context.func_195995_a().func_177972_a(side);
        if (this.isUsable(context) && player.func_175151_a(growth_pos, side, stack) && this.applyFertilizer(stack, world, hit_pos, growth_pos, context)) {
            this.addUsedStat(player);
            if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                this.reflectAppliedToPlayer(world, hit_pos);
            }
            this.checkApplyAdvancements(world, player, hit_pos, stack);
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    protected void reflectAppliedToPlayer(World world, BlockPos hit_pos) {
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            Effects.playFertilizedSuccessfully((World)world, (BlockPos)hit_pos);
        }
    }

    protected void checkApplyAdvancements(World world, PlayerEntity player, BlockPos hit_pos, ItemStack with) {
    }

    protected boolean applyFertilizer(ItemStack stack, World world, BlockPos hit_pos, BlockPos growth_pos, ItemUseContext context) {
        return VfpFertilizerItem.applyBonemeal(stack, world, hit_pos, growth_pos, context);
    }

    public static final boolean applyBonemeal(ItemStack stack, World world, BlockPos to, BlockPos growth_pos, ItemUseContext context) {
        if (VfpFertilizerItem.applyBonemeal(stack, world, to, context.func_195999_j(), context.func_221531_n())) {
            return true;
        }
        BlockState hit = world.func_180495_p(to);
        boolean solid = Block.func_220056_d((BlockState)hit, (IBlockReader)world, (BlockPos)to, (Direction)context.func_196000_l());
        return solid && BoneMealItem.func_203173_b((ItemStack)context.func_195996_i(), (World)world, (BlockPos)growth_pos, (Direction)context.func_196000_l());
    }

    private static final boolean bonemealAlwaysEffective(World world, BlockState state, IGrowable growable) {
        return growable instanceof MushroomBlock || Whatis.isLikelySapling((World)world, (BlockState)state);
    }

    public static final boolean applyBonemeal(ItemStack stack, World world, BlockPos to, PlayerEntity player, Hand hand_unused) {
        BlockState hit = world.func_180495_p(to);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)world, (BlockPos)to, (BlockState)hit, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        Block block = hit.func_177230_c();
        if (block instanceof IGrowable) {
            IGrowable growable = (IGrowable)block;
            if (growable.func_176473_a((IBlockReader)world, to, hit, SharedGlue.isaClientWorld((IWorldReader)world))) {
                boolean used = true;
                if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                    boolean always = stack.func_77973_b() instanceof IFertilizer && VfpFertilizerItem.bonemealAlwaysEffective(world, hit, growable);
                    used = false;
                    if (always || growable.func_180670_a(world, player.func_70681_au(), to, hit)) {
                        growable.func_176474_b(world, player.func_70681_au(), to, hit);
                        used = true;
                    }
                    if (SharedGlue.getPlayerInSurvival((PlayerEntity)player) && used) {
                        stack.func_190918_g(1);
                    }
                }
                return used;
            }
        } else if (hit.func_203425_a(RID.Tags.OTHER_BONEMEALABLE)) {
            if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                boolean always;
                boolean bl = always = block == Blocks.field_150388_bm || hit.func_203425_a(BlockTags.field_219746_E) || hit.func_203425_a(RID.Tags.VINES);
                if (!always && player.func_70681_au().nextFloat() > 0.72f) {
                    return true;
                }
                ItemStack dropped = ItemStacks.modded_create((BlockState)hit, (int)(1 + (player.func_70681_au().nextFloat() < 0.0625f ? 1 : 0)));
                Block.func_180635_a((World)world, (BlockPos)to, (ItemStack)dropped);
                if (SharedGlue.getPlayerInSurvival((PlayerEntity)player)) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack stack, World world, BlockPos to) {
        return world instanceof ServerWorld ? VfpFertilizerItem.applyBonemeal(stack, world, to, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)), Hand.MAIN_HAND) : false;
    }

    public static final void initDispenseBehavior(Item instance) {
        Validate.notNull((Object)instance, (String)"A non-null fertilizer item is required", (Object[])new Object[0]);
        DeferredWorkQueue.runLater(() -> DispenserBlock.func_199774_a((IItemProvider)instance, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private boolean _dispensed = true;

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                World world = source.func_197524_h();
                if (!VfpFertilizerItem.applyBonemeal(stack, world, blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a))) && !BoneMealItem.func_203173_b((ItemStack)stack, (World)world, (BlockPos)blockpos, null)) {
                    this._dispensed = false;
                } else if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                    world.func_217379_c(2005, blockpos, 0);
                }
                return stack;
            }

            protected void func_82485_a(IBlockSource source) {
                if (this._dispensed) {
                    source.func_197524_h().func_217379_c(1000, source.func_180699_d(), 0);
                } else {
                    source.func_197524_h().func_217379_c(1001, source.func_180699_d(), 0);
                }
            }
        }));
    }
}

