/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpMultiUseJarIngredient
extends VfpPlainItem {
    public static final int DEFAULT_MAX_USES = 5;
    protected final int _MAX_USES;
    protected boolean _useDurabilityBar;
    @Nullable
    protected String _inventory_model;

    public VfpMultiUseJarIngredient(@Nonnull VfpProfile profile, int max_uses, boolean durability, @Nullable Item.Properties ip) {
        super(profile, false, ip);
        Validate.isTrue((max_uses > 1 ? 1 : 0) != 0, (String)"More than one use is required for multiuse jar!", (Object[])new Object[0]);
        this._MAX_USES = max_uses;
        this._useDurabilityBar = durability;
        this._inventory_model = null;
        this.setMaxStackSize(VfpCapacity.LIQUID_STACK.count());
        this.func_185043_a(new ResourceLocation("uses"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack jar, World world, LivingEntity unused) {
                return VfpMultiUseJarIngredient.getUsesLeft(jar);
            }
        });
        this.autoregister();
    }

    public VfpMultiUseJarIngredient(@Nonnull VfpProfile profile) {
        this(profile, 5, false);
    }

    public VfpMultiUseJarIngredient(@Nonnull VfpProfile profile, int max_uses, boolean durability) {
        this(profile, max_uses, durability, null);
    }

    public static VfpMultiUseJarIngredient newPlainJar(@Nonnull VfpProfile profile, int uses) {
        if (uses <= 0) {
            uses = 5;
        }
        return new VfpMultiUseJarIngredient(profile, uses, false);
    }

    public static VfpMultiUseJarIngredient newPlainJar(@Nonnull VfpProfile profile) {
        return new VfpMultiUseJarIngredient(profile);
    }

    public String oid() {
        return this._inventory_model != null ? this._inventory_model : super.oid();
    }

    public final VfpMultiUseJarIngredient setModelLocation(String alt_oid) {
        this._inventory_model = alt_oid;
        return this;
    }

    public static final boolean isa(@Nullable ItemStack stack) {
        return !ItemStacks.isEmpty((ItemStack)stack) && stack.func_77973_b() instanceof VfpMultiUseJarIngredient;
    }

    public final int getMaxUses() {
        return this._MAX_USES;
    }

    static final int getMaxUses(@Nonnull ItemStack jar) {
        return ((VfpMultiUseJarIngredient)jar.func_77973_b()).getMaxUses();
    }

    public static final int getUsesLeft(@Nonnull ItemStack jar) {
        int maxUses = VfpMultiUseJarIngredient.getMaxUses(jar);
        return Instructions.getCheckedCapacity((ItemStack)jar, (int)maxUses, (int)maxUses);
    }

    protected final void setUsesLeft(ItemStack jar, int amount) {
        Instructions.setCapacity((ItemStack)jar, (int)amount);
    }

    protected void initDefaultContents(ItemStack jar) {
        this.setUsesLeft(jar, this.getMaxUses());
    }

    public ItemStack createInstance(Item item, int amount) {
        if (item == null) {
            item = this;
        }
        ItemStack newjar = super.createInstance(item, amount);
        this.initDefaultContents(newjar);
        return newjar;
    }

    public ItemStack getNewEmptyContainer(@Nonnull ItemStack jar) {
        Item emptyJar = VfpObj.Empty_Jar_obj;
        if (super.func_77668_q() != null) {
            emptyJar = super.func_77668_q();
        }
        return ItemStacks.create((Item)emptyJar);
    }

    public void onCookedOrCrafted(ItemStack jar) {
        if (!Instructions.present((ItemStack)jar)) {
            this.initDefaultContents(jar);
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return VfpMultiUseJarIngredient.isa(stack) ? VfpMultiUseJarIngredient.getUsesLeft(stack) > 0 : false;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int left;
        ItemStack out = ItemStacks.NULLSTACK();
        int n = left = VfpMultiUseJarIngredient.isa(stack) ? VfpMultiUseJarIngredient.getUsesLeft(stack) : -1;
        if (left > 1) {
            out = stack.func_77946_l();
            out.func_190920_e(1);
            this.setUsesLeft(out, left - 1);
        } else if (left == 1) {
            out = this.getNewEmptyContainer(stack);
        }
        return out;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack jar, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(jar, world, tooltip, flags);
        if (!this._useDurabilityBar) {
            int left = VfpMultiUseJarIngredient.getUsesLeft(jar);
            Tooltips.addUsesLeftTipLine((int)left, tooltip);
        }
    }

    public boolean showDurabilityBar(ItemStack jar) {
        return this._useDurabilityBar && VfpMultiUseJarIngredient.getUsesLeft(jar) < VfpMultiUseJarIngredient.getMaxUses(jar);
    }

    public double getDurabilityForDisplay(ItemStack jar) {
        double left = VfpMultiUseJarIngredient.getUsesLeft(jar);
        double total = VfpMultiUseJarIngredient.getMaxUses(jar);
        return (total - left) / total;
    }

    public ITextComponent func_200295_i(ItemStack jar) {
        ITextComponent displayName = super.func_200295_i(jar);
        if (this._useDurabilityBar) {
            displayName = new TranslationTextComponent("tooltip.itemsuffix.XofY.int", new Object[]{displayName, VfpMultiUseJarIngredient.getUsesLeft(jar), VfpMultiUseJarIngredient.getMaxUses(jar)});
        }
        return displayName;
    }

    public static void registerUnderAll(Item jar, String ... ingredientNames) {
        Objects.requireNonNull(jar);
        if (ingredientNames != null && ingredientNames.length > 0) {
            for (String ingredientName : ingredientNames) {
                RID.addToGroup((String)ingredientName, (Item)jar);
            }
        }
    }
}

