/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public class VfpPantryMultiItem
extends VfpPantryItem {
    @Nonnull
    protected final VfpVariant _variant;
    private final boolean _inedible;
    @Nullable
    private List<ItemGroup> _tabs;

    protected VfpPantryMultiItem(@Nonnull VfpProfile baseprofile, boolean isWolfFood, @Nonnull VfpVariant variant, @Nullable ItemGroup tab, boolean delayed) {
        super(baseprofile.derivative(variant), variant.food().healAmount(), variant.food().saturationModifier(), isWolfFood, tab, true);
        this._variant = variant;
        this._inedible = this.isInedible(baseprofile, variant);
        if (!delayed) {
            this.completeInit(this._profile);
        }
    }

    public VfpPantryMultiItem(VfpProfile baseprofile, boolean isWolfFood, VfpVariant variant) {
        this(baseprofile, isWolfFood, variant, baseprofile.isEdible() ? null : SharedGlue.CreativeTabs_misc, false);
    }

    @Nonnull
    public final VfpVariant getVariant() {
        return this._variant;
    }

    public float getSaturationModifier(ItemStack stack) {
        return this._inedible ? 0.0f : this._variant.food().saturationModifier();
    }

    protected final int getVariantTotalFoodPoints(ItemStack stack) {
        return this._variant.food().healAmount();
    }

    @Override
    public int getPortionFoodPoints(ItemStack stack) {
        if (this._inedible) {
            return 0;
        }
        int amount = super.getPortionFoodPoints(stack);
        return amount > 0 ? amount : this.getVariantTotalFoodPoints(stack);
    }

    @Override
    public int getTotalFoodPoints(@Nonnull ItemStack stack) {
        if (this._inedible) {
            return 0;
        }
        int amount1 = super.getTotalFoodPoints(stack);
        int amount2 = this.getVariantTotalFoodPoints(stack);
        return Math.max(amount1, amount2);
    }

    @Override
    protected float isHarmfulIfEatenDirectly(ItemStack original, PlayerEntity player) {
        float harmful = super.isHarmfulIfEatenDirectly(original, player);
        if (harmful <= 0.1f && this._variant.isHarmfulIfEatenDirectly()) {
            harmful = 0.25f;
        }
        return harmful;
    }

    protected boolean showSubItem(VfpVariant variant, @Nullable ItemGroup forTab, @Nullable ItemGroup pickedTab) {
        return !this.isHiddenByDefault();
    }

    public Collection<ItemGroup> getCreativeTabs() {
        if (this._tabs == null) {
            this._tabs = VfpUtils.getTabs(this._variant, this.func_77640_w(), this._inedible ? SharedGlue.CreativeTabs_misc : SharedGlue.CreativeTabs_food);
        }
        return this._tabs;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        ItemGroup defaultTab = this.func_77640_w();
        if (tab == SharedGlue.CreativeTabs_search) {
            if (this.showSubItem(this._variant, tab, tab)) {
                items.add((Object)this.createInstance((Item)this));
            }
        } else {
            ItemGroup wantTab = VfpUtils.preferredTab();
            if (wantTab == null) {
                ItemGroup itemGroup = this._variant.tab() != null ? this._variant.tab() : (this._inedible ? defaultTab : (wantTab = LikeFood.something(this._variant.food()) ? SharedGlue.CreativeTabs_food : defaultTab));
            }
            if (wantTab == tab && this.showSubItem(this._variant, tab, wantTab)) {
                items.add((Object)this.createInstance((Item)this));
            }
        }
    }

    protected boolean isInedible(@Nonnull VfpProfile profile, @Nonnull VfpVariant variant) {
        return LikeFood.something(variant.food()) ? false : !profile.isEdible();
    }

    @Override
    protected boolean isEdible(ItemStack stack) {
        if (this._inedible) {
            return false;
        }
        if (stack == null) {
            return true;
        }
        return LikeFood.something(this._variant.food());
    }
}

