/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.ILootedListener;
import org.jwaresoftware.mcmods.lib.api.ISoakable;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableSimpleFood;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public class VfpSoakableFood
extends VfpPantryMultiItem
implements ISoakable,
ILootedListener {
    protected VfpSoakableFood(@Nonnull VfpProfile baseprofile, boolean isWolfFood, @Nonnull VfpVariant variant, ItemGroup tab, boolean delayed) {
        super(baseprofile, isWolfFood, variant, tab, delayed);
    }

    protected VfpSoakableFood(@Nonnull VfpProfile baseprofile, boolean isWolfFood, @Nonnull VfpVariant variant) {
        super(baseprofile, isWolfFood, variant);
    }

    @Override
    protected void completeInit(@Nonnull VfpProfile profile) {
        super.completeInit(profile);
        this.func_185043_a(new ResourceLocation("soaked"), ISoakable.SoakedPropertyGetter.INSTANCE);
    }

    @Override
    public float getCompostChance() {
        return 0.15f;
    }

    public boolean canSoak(ItemStack stack) {
        return this.isEdible(stack);
    }

    public boolean isSoaked(ItemStack stack) {
        return Potions.isa((ItemStack)stack, (boolean)true);
    }

    public List<EffectInstance> getSoakingEffects(ItemStack stack) {
        return Potions.getEffects((ItemStack)stack, (boolean)true);
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return this.isSoaked(stack) ? SharedGlue.SHORT_FOOD_CONSUME_DURATION() : super.func_77626_a(stack);
    }

    @Override
    protected boolean canConsume(ItemStack held, World world, PlayerEntity player) {
        return this.isSoaked(held) || super.canConsume(held, world, player);
    }

    @Override
    protected boolean isInstaConsume(ItemStack held) {
        if (super.isInstaConsume(held)) {
            return true;
        }
        return this.isEdible(held) && VfpConfig.getInstance().allowInstaPotions() && this.isSoaked(held);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (this.isSoaked(original)) {
            Potions.addPotionEffects((LivingEntity)player, (ItemStack)original);
        }
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
    }

    public void notifyLooted(@Nonnull ItemStack reward, World world, PlayerEntity player, float luckLevel, String context) {
        if (reward.func_77973_b() == this) {
            VfpSoakableSimpleFood.checkForSoakedLootItem(reward, this, Effects.field_188425_z);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent displayName = super.func_200295_i(stack);
        if (this.isSoakedOrShouldBeSoaked(stack)) {
            displayName = new TranslationTextComponent("tooltip.itemsuffix.footnoted", new Object[]{displayName, "*"});
        }
        return displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isShowingUiTips(ItemStack stack) {
        return this.isSoaked(stack) ? false : super.isShowingUiTips(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        if (this.isSoaked(stack)) {
            if (this.isMultiuse(stack) || this._debugFlag) {
                tooltip.add(Tooltips.NL());
            }
            Potions.addPotionInformation((Collection)Potions.getEffects((ItemStack)stack, (boolean)false), tooltip, (boolean)flags.func_194127_a());
        }
    }
}

