/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.IStringSerializable;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpVariant
implements IStringSerializable,
Comparable<VfpVariant>,
Named {
    private static int _I = 123 + new Random().nextInt(1024);
    public static final VfpVariant[] EMPTY_ARRAY = new VfpVariant[0];
    protected final int _index;
    protected final String _name;
    protected final LikeFood _food;
    private final VfpCapacity _capacity;
    protected final Object _data;
    private final ItemGroup _tab;
    private final Integer _maxstack;
    private boolean _harmful;

    private static final VfpCapacity capFrom(VfpProfile profile) {
        return profile.capacity() == VfpCapacity.NONE ? null : profile.capacity();
    }

    protected VfpVariant(int index, String name, LikeFood food, VfpCapacity cap, Integer max, Object other, ItemGroup tab) {
        int n;
        Validate.notNull((Object)name, (String)"A non-null registry name is required", (Object[])new Object[0]);
        Validate.isTrue((boolean)name.equals(name.toLowerCase(Locale.US)), (String)"All registry names MUST be lower-case", (Object[])new Object[0]);
        if (index < 0) {
            int n2 = _I;
            n = n2;
            _I = n2 + 1;
        } else {
            n = index;
        }
        this._index = n;
        this._name = name;
        this._food = food == null ? LikeFood.air : food;
        this._capacity = cap;
        this._data = other;
        this._tab = tab;
        this._maxstack = max;
    }

    public VfpVariant(String name, LikeFood food, VfpCapacity cap, Integer max, Object other) {
        this(_I++, name, food, cap, max, other, null);
    }

    public VfpVariant(int index, VfpProfile profile, LikeFood food) {
        this(index, profile.fmlid(), food, VfpVariant.capFrom(profile), null, null, null);
    }

    public VfpVariant(VfpProfile profile, LikeFood food) {
        this(_I++, profile.fmlid(), food, VfpVariant.capFrom(profile), null, null, null);
    }

    public VfpVariant(VfpProfile profile, LikeFood food, ItemGroup tab) {
        this(_I++, profile.fmlid(), food, VfpVariant.capFrom(profile), null, null, tab);
    }

    public VfpVariant(int index, String fmlid, LikeFood food) {
        this(index, fmlid, food, null, null, null, null);
    }

    public VfpVariant(int index, String fmlid, LikeFood food, Object other, ItemGroup tab) {
        this(index, fmlid, food, null, null, other, tab);
    }

    public VfpVariant(String fmlid, LikeFood food, Object other, ItemGroup tab) {
        this(_I++, fmlid, food, null, null, other, tab);
    }

    public VfpVariant(int index, String fmlid, LikeFood food, VfpCapacity cap) {
        this(index, fmlid, food, cap, null, null, null);
    }

    public VfpVariant(int index, String fmlid, LikeFood food, VfpCapacity cap, Integer maxstack) {
        this(index, fmlid, food, cap, maxstack, null, null);
    }

    public VfpVariant(VfpProfile profile, LikeFood food, VfpCapacity cap) {
        this(_I++, profile.fmlid(), food, cap, null, null, null);
    }

    public VfpVariant(int index, String fmlid, int healAmount, float satModifier) {
        this(index, fmlid, new LikeFood(healAmount, satModifier, (Item)null), null, null, null, null);
    }

    public VfpVariant(VfpProfile profile, int healAmount, float satModifier) {
        this(_I++, profile.fmlid(), new LikeFood(healAmount, satModifier, (Item)null), VfpVariant.capFrom(profile), null, null, null);
    }

    public VfpVariant(int index, String fmlid, Object other, Integer maxstack) {
        this(index, fmlid, null, null, maxstack, other, null);
    }

    public VfpVariant(String fmlid, Object other, ItemGroup tab) {
        this(_I++, fmlid, null, null, null, other, tab);
    }

    public VfpVariant(String fmlid, Object other) {
        this(_I++, fmlid, null, null, null, other, null);
    }

    public VfpVariant(int index, String fmlid) {
        this(index, fmlid, null, null, null, null, null);
    }

    public final int index() {
        return this._index;
    }

    public int metadata() {
        return this.index();
    }

    @Nonnull
    public String fmlid() {
        return this._name;
    }

    @Nonnull
    public final String func_176610_l() {
        return this.fmlid();
    }

    @Override
    @Nonnull
    public final String name() {
        return this.func_176610_l();
    }

    public final String toString() {
        return this.func_176610_l();
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder(75);
        sb.append("refid=").append(System.identityHashCode(this)).append("|");
        sb.append("index=").append(this.index()).append(",meta=").append(this.metadata());
        sb.append(",name=").append(this.fmlid()).append(",cap=").append((Object)this.capacity());
        sb.append(",maxs=").append(this.maxstack()).append(",food=").append(this.food());
        sb.append(",data=").append(this._data);
        return sb.toString();
    }

    @Nonnull
    public LikeFood food() {
        return this._food;
    }

    public VfpCapacity capacity() {
        return this._capacity;
    }

    @Nullable
    public <T> T datadata(Class<? extends T> ofType) {
        return ofType.isInstance(this._data) ? (T)ofType.cast(this._data) : null;
    }

    @Nullable
    public ItemGroup tab() {
        return this._tab;
    }

    @Nullable
    public Integer maxstack() {
        return this._maxstack;
    }

    public VfpVariant setHarmful() {
        this._harmful = true;
        return this;
    }

    public boolean isHarmfulIfEatenDirectly() {
        return this._harmful;
    }

    @Override
    public int compareTo(VfpVariant o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        return this.metadata() > o.metadata() ? 1 : (this.metadata() < o.metadata() ? -1 : 0);
    }

    public int hashCode() {
        return 31 * this.fmlid().hashCode() + this.metadata();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().equals(o.getClass())) {
            VfpVariant other = (VfpVariant)VfpVariant.class.cast(o);
            return this.metadata() == other.metadata() && this.fmlid().equals(other.fmlid());
        }
        return false;
    }
}

