/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meals;

import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class MashedTatoes
extends VfpPantryMultiItem {
    private static final int _PLAIN_MASH = 0;
    private static final int _PINK_MASH = 1;
    private static final int _GREEN_MASH = 2;
    private static final int _WILDER_MASH = 3;
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, "mashed_tatoes", new LikeFood("chesy_mash", -1, LikeFood.mashed_potato, LikeFood.cheese_portion)), new VfpVariant(1, "pink_mashed_tatoes", LikeFood.mashed_potato), new VfpVariant(2, "green_mashed_tatoes", LikeFood.mashed_potato), new VfpVariant(3, "wild_mashed_tatoes", new LikeFood(10, 0.9f))};
    static boolean _GOT_WILD_POTATOES = false;
    private static MashedTatoes[] INSTANCES;

    MashedTatoes(VfpVariant variant) {
        super((VfpProfile)VfpOid.Mashed_Tatoes, false, variant);
        this.autoregister();
    }

    @Override
    protected boolean showSubItem(VfpVariant variant, ItemGroup forTab, ItemGroup pickedTab) {
        boolean show = super.showSubItem(variant, forTab, pickedTab);
        if (!VfpConfig.getInstance().showAllItemsInUI() && variant.metadata() == 3) {
            show = show && _GOT_WILD_POTATOES;
        }
        return show;
    }

    private static final ItemStack newMash(int amount, int index) {
        return new ItemStack((IItemProvider)INSTANCES[index], amount);
    }

    @Override
    public ItemStack createInstance(Item item, int amount) {
        return MashedTatoes.newMash(amount, ((MashedTatoes)item)._variant.index());
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            INSTANCES = new MashedTatoes[VARIANT_ARRAY.length];
            for (int i = 0; i < INSTANCES.length; ++i) {
                MashedTatoes.INSTANCES[i] = new MashedTatoes(VARIANT_ARRAY[i]);
            }
        }
    }

    static final void addDictionaryEntries() {
        if (INSTANCES != null) {
            for (int i = 0; i < INSTANCES.length; ++i) {
                ItemStack dish = MashedTatoes.newMash(1, i);
                RID.addToGroup((String)"foods/mashed_potatoes", (ItemStack)dish);
            }
        }
    }

    static final void linkLikeFoods() {
        boolean intermod = VfpConfig.getInstance().includeInterModRecipes();
        boolean bl = _GOT_WILD_POTATOES = intermod && SharedGlue.ingredientDefined((String)"foods/wild_potatoes");
        if (INSTANCES != null) {
            LikeFood.mashed_potato.food().item(MashedTatoes.regular());
        }
    }

    public static final ItemStack regular() {
        return MashedTatoes.newMash(1, 0);
    }

    public static final ItemStack pink() {
        return MashedTatoes.newMash(1, 1);
    }
}

