/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidNonFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class BowlOfMilk
extends VfpLiquidNonFood
implements IEssential,
ICurative {
    public BowlOfMilk() {
        super((VfpProfile)VfpOid.Bowl_Milk, LiquidType.MILK);
        this.autoregister();
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Item getNewEmptyContainer() {
        return Items.field_151054_z;
    }

    @Override
    protected int getRegularItemUseDuration() {
        return SharedGlue.SHORT_FOOD_CONSUME_DURATION();
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack milk) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)milk);
        this.onDrinkDrunk(milk, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_regeneration, (int)15, (int)1);
        super.applyPotionEffectsOnDrunk(original, remaining, world, player);
    }

    @Override
    protected void onDrinkDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            Potions.cureBadPotionEffectsWithMilk((PlayerEntity)player, (boolean)false, (boolean)false, (boolean)false);
        }
        player.func_71024_bL().func_75122_a(LikeFood.milk.healAmount(), LikeFood.milk.saturationModifier());
        super.onDrinkDrunk(original, remaining, world, player);
    }
}

