/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class MilkDrink
extends VfpLiquidMultiItem
implements IVariant {
    private static final int WHITE_MILKDRINK_COLOR = SharedGlue.MapColor_SNOW.field_76291_p;
    private static final int CREAM_MILKDRINK_COLOR = 16775636;
    private static final int CHOCO_MILKDRINK_COLOR = SharedGlue.MapColor_BROWN.field_76291_p;
    private static final int BERRY_MILKDRINK_COLOR = SharedGlue.MapColor_PINK.field_76291_p;
    private static final int _PLAIN = 0;
    private static final int _HEAVY = 1;
    private static final int _FIRST_CUSTOM = 2;
    private static int _CHOCO;
    private static int _MUSCLE;
    private static final int _EFF_REGENX = 1;
    private static final int _EFF_MUSCLE = 16;
    private static final List<Ingredient> VARIANT_FLAVORS;
    private static MilkDrink[] INSTANCES;

    public static final synchronized boolean register(Ingredient flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for a milky drink", (Object[])new Object[0]);
        if (flavor.id() == 0 || flavor.id() == 1) {
            return false;
        }
        return MilkDrink.register(flavor, VARIANT_FLAVORS, "milky drinks");
    }

    public static final synchronized boolean register(FoodPowder.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null food powder is required for a milky drink", (Object[])new Object[0]);
        String name = null;
        name = flavor == FoodPowder.Type.CACTUS ? "klingon" : (flavor == FoodPowder.Type.CREAM ? "sweet" : flavor.name_lowercased());
        Ingredient ingredient = FoodPowder.toIngredient(flavor, FoodPowder.Usage.DRINK_FLAVOR, name);
        boolean done = MilkDrink.register(ingredient, VARIANT_FLAVORS, "milky drinks");
        if (done) {
            if (flavor == FoodPowder.Type.MUSCLE_MIX) {
                ingredient.attributes(17);
                _MUSCLE = VARIANT_FLAVORS.size() - 1;
            } else if (flavor == FoodPowder.Type.APPLE) {
                ingredient.attributes(1);
            } else if (flavor == FoodPowder.Type.COCOA) {
                _CHOCO = VARIANT_FLAVORS.size() - 1;
            }
        }
        return done;
    }

    MilkDrink(VfpVariant variant) {
        super((VfpProfile)VfpOid.MilkDrink, variant, LiquidType.MILK);
        this.setAlwaysEdible();
        this.autoregister();
    }

    @Nonnull
    private Ingredient ingredientFrom() {
        return this._variant.datadata(Ingredient.class);
    }

    public String oid() {
        return VfpOid.MilkDrink.fmlid();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return VfpObj.Our_Empty_Bottle_obj;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return this._variant.index() == 0 ? SharedGlue.SHORT_FOOD_CONSUME_DURATION() : super.func_77626_a(stack);
    }

    @Override
    protected Integer getColorFromIngredient(Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getColorFromIngredient(ingredient, renderPass);
        if (colorValue == null) {
            colorValue = ingredient.name().contains("erry") ? Integer.valueOf(BERRY_MILKDRINK_COLOR) : Integer.valueOf(16775636);
        }
        return colorValue;
    }

    @Override
    protected int getColorFromVariant(int renderPass) {
        int index = this._variant.index();
        if (index == 0) {
            return WHITE_MILKDRINK_COLOR;
        }
        if (index == 1) {
            return 16775636;
        }
        if (index == _CHOCO) {
            return CHOCO_MILKDRINK_COLOR;
        }
        return super.getColorFromVariant(renderPass);
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, PlayerEntity player) {
        boolean has_muscle_effect = false;
        boolean has_regenx_effect = false;
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            Ingredient ingredient = this.ingredientFrom();
            has_regenx_effect = (ingredient.attributes() & 1) == 1;
            has_muscle_effect = (ingredient.attributes() & 0x10) == 16;
            Potions.cureBadPotionEffectsWithMilk((PlayerEntity)player, (boolean)has_muscle_effect, (boolean)has_regenx_effect, (boolean)has_muscle_effect);
        }
        super.onFoodEaten(eaten, remaining, world, player);
        if (has_regenx_effect) {
            Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_regeneration, (int)15, (int)1);
        }
        if (has_muscle_effect) {
            Potions.addMuscleBoostPotionEffect((PlayerEntity)player, (int)-1);
        }
    }

    private static final LikeFood like(int index, Ingredient ingredient) {
        if (index == 0) {
            return LikeFood.milk;
        }
        if (index == 1) {
            return LikeFood.cream;
        }
        String name = ingredient.name().toUpperCase();
        LikeFood baseline = LikeFood.sweet_milk;
        if ("SWEET".equals(name) || FoodPowder.Type.CREAM.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.cream);
        }
        if (FoodPowder.Type.MUSCLE_MIX.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.muscle_boost);
        }
        if (FoodPowder.Type.APPLE.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.apple);
        }
        if (FoodPowder.Type.PUMPKIN.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.melon_slice);
        }
        if ("KLINGON".equals(name) || FoodPowder.Type.CACTUS.name().equals(name) || FoodPowder.Type.BERRY_MIX.name().equals(name) || FoodPowder.Type.MOCHA_MIX.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.veg_portion);
        }
        return baseline;
    }

    public String varid() {
        return this.getVariant().fmlid();
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (int i = 2; i < INSTANCES.length; ++i) {
            all.add(new ItemStack((IItemProvider)INSTANCES[i]));
        }
        return all;
    }

    @Override
    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() ? false : !this.ingredientFrom().isEnabled();
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            INSTANCES = new MilkDrink[VARIANT_FLAVORS.size()];
            String baseName = VfpOid.MilkDrink.fmlid();
            for (int i = 0; i < INSTANCES.length; ++i) {
                Ingredient ingredient = VARIANT_FLAVORS.get(i);
                LikeFood food = MilkDrink.like(i, ingredient);
                MilkDrink.INSTANCES[i] = new MilkDrink(new VfpTransientVariant(i, ingredient.id(), baseName + "_" + ingredient.name(), food, ingredient, null));
            }
        }
    }

    static final void addDictionaryEntries() {
        if (INSTANCES != null) {
            for (int i = 0; i < INSTANCES.length; ++i) {
                Ingredient ingredient = INSTANCES[i].ingredientFrom();
                ItemStack a_milk_drink = new ItemStack((IItemProvider)INSTANCES[i]);
                RID.addToGroup((String)"foods/drinks", (ItemStack)a_milk_drink);
                if ((ingredient.attributes() & 1) != 1) continue;
                RID.addToGroup((String)"carrots:curatives/foods", (ItemStack)a_milk_drink);
            }
        }
    }

    static final void setRecipeRewards() {
        if (INSTANCES != null) {
            for (int i = 2; i < INSTANCES.length; ++i) {
                ItemStack a_milk_drink = new ItemStack((IItemProvider)INSTANCES[i]);
                VfpRewards.addRewardingCraftItem(a_milk_drink, LikeFood.sweet_milk.craftExperience());
            }
        }
    }

    public static final boolean isa(ItemStack stack) {
        return !ItemStacks.isEmpty((ItemStack)stack) && stack.func_77973_b() instanceof MilkDrink;
    }

    public static final ItemStack plain(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[0], amount);
    }

    public static final ItemStack heavy(int amount) {
        return new ItemStack((IItemProvider)INSTANCES[1], amount);
    }

    public static final Item muscle() {
        return INSTANCES[_MUSCLE];
    }

    private static final ItemStack other(int id, int amount) {
        for (int i = 0; i < INSTANCES.length; ++i) {
            Ingredient ingredient = INSTANCES[i].ingredientFrom();
            if (ingredient.id() != id) continue;
            return new ItemStack((IItemProvider)INSTANCES[i], amount);
        }
        return ItemStack.field_190927_a;
    }

    public static final ItemStack other(FoodPowder.Type flavor, int amount) {
        Ingredient powder = FoodPowder.toIngredient(flavor, FoodPowder.Usage.DRINK_FLAVOR, null);
        return powder == null ? ItemStack.field_190927_a : MilkDrink.other(powder.id(), amount);
    }

    static {
        VARIANT_FLAVORS = new ArrayList<Ingredient>(23);
        Ingredient plain_milk = new Ingredient("plain", 0, ItemStackDef.UNUSED);
        plain_milk.attributes(1);
        VARIANT_FLAVORS.add(plain_milk);
        Ingredient heavy_milk = new Ingredient("heavy", 1, ItemStackDef.UNUSED);
        heavy_milk.attributes(1);
        VARIANT_FLAVORS.add(heavy_milk);
    }
}

