/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTables;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.milk.BowlOfMilk;
import org.jwaresoftware.mcmods.vfp.milk.CondensedMilkHelper;
import org.jwaresoftware.mcmods.vfp.milk.CreamSoup;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrink;
import org.jwaresoftware.mcmods.vfp.milk.TeaDrink;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class MilkExtrasBuildHelper
extends VfpBuildHelperSupport {
    private CondensedMilkHelper _condensedHelper = new CondensedMilkHelper();

    @Override
    protected String categoryName() {
        return "MilkExtras";
    }

    @Override
    public void makeObjects(IModRuntime runtime) {
        VfpObj.Cloth_Bag_obj = VfpBuilder.newMisc(VfpOid.Cloth_Bag);
        MilkDrink.register(FoodPowder.Type.COCOA);
        MilkDrink.register(FoodPowder.Type.CREAM);
        MilkDrink.register(FoodPowder.Type.PUMPKIN);
        MilkDrink.register(FoodPowder.Type.CACTUS);
        MilkDrink.register(FoodPowder.Type.APPLE);
        MilkDrink.register(FoodPowder.Type.MUSCLE_MIX);
        MilkDrink.register(FoodPowder.Type.BLUEBERRY);
        MilkDrink.register(FoodPowder.Type.STRAWBERRY);
        MilkDrink.register(FoodPowder.Type.PEANUTS);
        MilkDrink.register(FoodPowder.Type.MOCHA_MIX);
        MilkDrink.register(FoodPowder.Type.BERRY_MIX);
        VfpObj.CheeseBall_obj = VfpBuilder.newFood(VfpOid.Cheese_Ball, LikeFood.cheese_portion);
        VfpObj.Cheese_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Cheese_Pantry_Block, VfpObj.CheeseBall_obj);
        VfpObj.Butter_obj = VfpBuilder.newFood(VfpOid.Homemade_Butter, LikeFood.butter);
        VfpObj.Portion_Butter_obj = VfpBuilder.newAdditive(VfpOid.Portion_Butter, SharedGlue.CreativeTabs_materials);
        VfpObj.Butter_Brick_obj = VfpBuilder.newStorageItem(VfpOid.Butter_Brick);
        TeaDrink.register(FoodPowder.Type.BUSHTEA);
        TeaDrink.register(new Ingredient("milky_" + FoodPowder.Type.BUSHTEA.name_lowercased(), FoodPowder.Usage.DRINK_FLAVOR.idFirst() + 0, FoodPowder.getDef(FoodPowder.Type.BUSHTEA, 1), 2), 11060315);
        TeaDrink.register(FoodPowder.Type.DANDTEA);
        TeaDrink.register(new Ingredient("milky_" + FoodPowder.Type.DANDTEA.name_lowercased(), FoodPowder.Usage.DRINK_FLAVOR.idFirst() + 1, FoodPowder.getDef(FoodPowder.Type.DANDTEA, 1), 2), 13943960);
        for (FoodPowder.Type powder : FoodPowder.Type.values()) {
            if (!powder.isSoupFlavor()) continue;
            CreamSoup.register(powder);
        }
        this._condensedHelper.makeObjects(runtime);
    }

    @Override
    public void makeObjectsFinalPass(IModRuntime runtime) {
        VfpObj.Bowl_Milk_obj = new BowlOfMilk();
        MilkDrink.makeObjects();
        TeaDrink.makeObjects();
        CreamSoup.makeObjects();
        this._condensedHelper.makeObjectsFinalPass(runtime);
    }

    @Override
    public void linkObjects(IModRuntime runtime) {
        this._condensedHelper.linkObjects(runtime);
    }

    @Override
    public void linkLikeFoods(IModRuntime runtime) {
        LikeFood.milk.food().item(MilkDrink.plain(1));
        LikeFood.cream.food().item(MilkDrink.heavy(1));
        LikeFood.sweet_milk.food().item(MilkDrink.other(FoodPowder.Type.CREAM, 1));
        LikeFood.cheese_portion.food().item(VfpObj.CheeseBall_obj);
        LikeFood.bush_tea.food().item(TeaDrink.bush(1));
        LikeFood.butter.food().item(VfpObj.Butter_obj);
        LikeFood.butter_dab.food().item(VfpObj.Portion_Butter_obj);
        this._condensedHelper.linkLikeFoods(runtime);
    }

    @Override
    public void addDictionaryEntries(IModRuntime runtime) {
        RID.addToGroup((String)"carrots:cheese_cloth", (Item)VfpObj.Cloth_Bag_obj);
        RID.addToGroup((String)"foods/cheeses", (Item)VfpObj.CheeseBall_obj);
        RID.addToGroup((String)"ingredients/cheese", (Item)VfpObj.CheeseBall_obj);
        RID.addToGroup((String)"carrots:portions_small_butter", (Item)VfpObj.Portion_Butter_obj);
        RID.addToGroup((String)"ingredients/condiments", (Item)VfpObj.Portion_Butter_obj);
        RID.addToGroup((String)"foods/butter", (Item)VfpObj.Butter_obj);
        RID.addToGroup((String)"ingredients/butterstick_oil", (Item)VfpObj.Butter_obj);
        RID.addToGroup((String)"carrots:curatives/foods", (Item)VfpObj.Bowl_Milk_obj);
        RID.addToGroup((String)"carrots:portions_milk", (Item)VfpObj.Bowl_Milk_obj);
        RID.addToGroup((String)"ingredients/bottle_milk", (Item)VfpObj.Bowl_Milk_obj);
        RID.addToGroup((String)"carrots:portions_milk", (ItemStack)MilkDrink.plain(1));
        RID.addToGroup((String)"ingredients/bottle_milk", (ItemStack)MilkDrink.plain(1));
        RID.addToGroup((String)"ingredients/bottle_cream", (ItemStack)MilkDrink.heavy(1));
        MilkDrink.addDictionaryEntries();
        TeaDrink.addDictionaryEntries();
        CreamSoup.addDictionaryEntries();
        this._condensedHelper.addDictionaryEntries(runtime);
    }

    @Override
    public void addLootEntries(IModRuntime runtime) {
        Loot.addLootEntry((String)"vanillafoodpantry", (ResourceLocation)LootTables.field_186422_d, (String)Loot.asMinecraftPool((int)1), (LootEntry.Builder)Loot.createEntryItem((String)"vfp_muscle_milkdrink", (Item)MilkDrink.muscle(), (int)1, (int)2, (int)SharedGlue.JUNK_WEIGHT(), (int)-1));
        this._condensedHelper.addLootEntries(runtime);
    }

    @Override
    public void setRecipeRewards(IModRuntime runtime) {
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.CheeseBall_obj), LikeFood.cheese_portion.craftExperience());
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Butter_obj), LikeFood.butter.craftExperience());
        MilkDrink.setRecipeRewards();
        TeaDrink.setRecipeRewards();
        CreamSoup.setRecipeRewards();
        this._condensedHelper.setRecipeRewards(runtime);
    }

    @Override
    public void finish(IModRuntime runtime) {
        this._condensedHelper.finish(runtime);
    }
}

