/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IRegistriesLoadedListener;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.VanillaFoodPantry;
import org.jwaresoftware.mcmods.vfp.agents.AgentsBuildHelper;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpBrewingItem;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpCraftOnlyItem;
import org.jwaresoftware.mcmods.vfp.common.VfpExtendedPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpExtendedPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainCompostableItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSimpleBowlFood;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableSimpleFood;
import org.jwaresoftware.mcmods.vfp.common.VfpStorageItem;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.configui.VfpConfigChangedListener;
import org.jwaresoftware.mcmods.vfp.eggs.EggExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.meals.MealsBuildHelper;
import org.jwaresoftware.mcmods.vfp.meats.KeepDragonHeadShapedRecipe;
import org.jwaresoftware.mcmods.vfp.meats.MeatExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.milk.MilkExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.misc.MiscBuildHelper;
import org.jwaresoftware.mcmods.vfp.misc.ReheatFoodRecipe;
import org.jwaresoftware.mcmods.vfp.runtime.ModDrops;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelper;
import org.jwaresoftware.mcmods.vfp.runtime.VfpLootLoadedListener;
import org.jwaresoftware.mcmods.vfp.runtime.VfpOreGenerator;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRuntimeSkeleton;
import org.jwaresoftware.mcmods.vfp.runtime.crafting.AllowHotColdFoodConditionSerializer;
import org.jwaresoftware.mcmods.vfp.runtime.crafting.ConfigAllowsConditionSerializer;
import org.jwaresoftware.mcmods.vfp.runtime.crafting.ConfigIsPresentConditionSerializer;
import org.jwaresoftware.mcmods.vfp.runtime.crafting.IsSupercompatibilityModeConditionSerializer;
import org.jwaresoftware.mcmods.vfp.runtime.crafting.KeepEmptyBottlesShapedRecipe;
import org.jwaresoftware.mcmods.vfp.runtime.crafting.KeepEmptyBottlesShapelessRecipe;
import org.jwaresoftware.mcmods.vfp.runtime.crafting.UseAnyWaterConditionSerializer;
import org.jwaresoftware.mcmods.vfp.runtime.crafting.UseTreatedWaterConditionSerializer;
import org.jwaresoftware.mcmods.vfp.sandwiches.DefinedDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.sandwiches.GenericDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.sandwiches.KingDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.sandwiches.SandwichesBuildHelper;
import org.jwaresoftware.mcmods.vfp.sugar.SugarExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.tonics.BasicTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.CompositeTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.PersonalizeTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.SoakFoodShapedRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.SoakFoodShapelessRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.TonicToTippedArrowsRecipe;
import org.jwaresoftware.mcmods.vfp.utensils.AddToBucketJarRecipe;
import org.jwaresoftware.mcmods.vfp.utensils.CutterExtractHeatPortionsRecipe;
import org.jwaresoftware.mcmods.vfp.utensils.CutterItemRepairRecipe;
import org.jwaresoftware.mcmods.vfp.utensils.FillBucketJarRecipe;
import org.jwaresoftware.mcmods.vfp.veggies.VeggiesBuildHelper;
import org.jwaresoftware.mcmods.vfp.wheat.WheatExtrasBuildHelper;

public class VfpBuilder {
    public static final Predicate<Item> XFP_PRESENT = new VfpExtendedPlainItem.IsIngredientPresent(VfpAware.IdDomain.MODID, ModIntegration.EXTENDED_FOODPANTRY.modid());
    private final List<VfpBuildHelper> _subBuilders;

    public static VfpPantryItem newPortion(VfpProfile profile) {
        ItemGroup tab = profile.isEdible() ? null : SharedGlue.CreativeTabs_misc;
        return new VfpPantryItem(profile, LikeFood.air, tab).autoregister();
    }

    public static Item newAdditive(VfpProfile profile, ItemGroup tab) {
        return profile.isEdible() ? new VfpPantryItem(profile, LikeFood.air, tab).autoregister() : (profile.capacity() == VfpCapacity.NONE ? new VfpPlainItem(profile, tab).autoregister() : new VfpStorageItem(profile, tab).autoregister());
    }

    public static Item newAdditive(VfpProfile profile) {
        return VfpBuilder.newAdditive(profile, null);
    }

    public static VfpPantryItem newFood(VfpProfile profile, LikeFood food) {
        return new VfpPantryItem(profile, food, profile.isEdible() ? null : SharedGlue.CreativeTabs_materials).autoregister();
    }

    public static VfpPantryItem newFood(String gid, VfpProfile profile, LikeFood food) {
        return (VfpPantryItem)VfpBuilder.newFood(profile, food).inGroup(gid);
    }

    public static VfpPantryItem newOptionalFood(VfpProfile profile, LikeFood food, Predicate<Item> test) {
        return new VfpExtendedPantryItem(profile, food, test, profile.isEdible() ? null : SharedGlue.CreativeTabs_misc).autoregister();
    }

    public static VfpPantryItem newOptionalFood(VfpProfile profile, LikeFood food, VfpAware.IdDomain domain, String ... choices) {
        return new VfpExtendedPantryItem(profile, food, new VfpExtendedPlainItem.IsIngredientPresent(domain, choices), profile.isEdible() ? null : SharedGlue.CreativeTabs_misc).autoregister();
    }

    public static VfpPantryItem newSimpleBowlFood(VfpProfile profile, LikeFood food) {
        return VfpSimpleBowlFood.newBowl(profile, food);
    }

    public static VfpPantryItem newWolfFood(VfpProfile profile, LikeFood food) {
        return new VfpPantryItem(profile, food, true, profile.isEdible() ? null : SharedGlue.CreativeTabs_misc).autoregister();
    }

    public static VfpPantryItem newSoakableFood(VfpProfile profile, LikeFood food) {
        return new VfpSoakableSimpleFood(profile, food, null).autoregister();
    }

    public static VfpPlainItem newMushBucket(VfpProfile profile, int mush_maxstack) {
        VfpPlainItem item = VfpBuilder.newMisc(profile);
        item.setContainerItem(Items.field_151133_ar).setMaxStackSize(mush_maxstack);
        return item;
    }

    public static VfpPlainItem newMisc(VfpProfile profile) {
        return profile.capacity() == VfpCapacity.NONE ? new VfpPlainItem(profile, SharedGlue.CreativeTabs_misc).autoregister() : new VfpStorageItem(profile, SharedGlue.CreativeTabs_misc).autoregister();
    }

    public static final VfpPlainItem newMisc(String gid, VfpProfile profile) {
        return (VfpPlainItem)VfpBuilder.newMisc(profile).inGroup(gid);
    }

    public static final VfpPlainItem newMisc(String gid, VfpProfile profile, float cc) {
        return new VfpPlainCompostableItem(profile, cc, SharedGlue.CreativeTabs_misc).autoregister();
    }

    public static VfpPlainItem newItem(VfpProfile profile) {
        return new VfpPlainItem(profile).autoregister();
    }

    public static VfpPlainItem newItem(VfpProfile profile, ItemGroup tab) {
        return new VfpPlainItem(profile, tab).autoregister();
    }

    public static VfpPlainItem newCompostableItem(VfpProfile profile, float cc) {
        return new VfpPlainCompostableItem(profile, cc).autoregister();
    }

    public static VfpPlainItem newOptionalItem(VfpProfile profile, boolean hide) {
        return new VfpPlainItem(profile, hide).autoregister();
    }

    public static VfpPlainItem newOptionalItem(VfpProfile profile, Predicate<Item> test) {
        return new VfpExtendedPlainItem(profile, test, SharedGlue.CreativeTabs_misc).autoregister();
    }

    public static VfpPlainItem newOptionalItem(VfpProfile profile, VfpAware.IdDomain domain, String ... choices) {
        return new VfpExtendedPlainItem(profile, new VfpExtendedPlainItem.IsIngredientPresent(domain, choices), SharedGlue.CreativeTabs_misc).autoregister();
    }

    public static VfpCraftOnlyItem newCraftOnlyItem(VfpProfile profile) {
        return new VfpCraftOnlyItem(profile);
    }

    public static VfpPantryBlock newStorageBlock(VfpProfile profile, Block likeBlock, Item constituent) {
        return new VfpPantryBlock(profile, likeBlock, new ItemStackDef(constituent)).autoregister(VfpPantryBlock.class);
    }

    public static VfpPantryBlock newStorageBlock(VfpProfile profile, Block likeBlock, Item constituent, SoundType sound) {
        return new VfpPantryBlock(profile, likeBlock, new ItemStackDef(constituent), sound).autoregister(VfpPantryBlock.class);
    }

    public static VfpPantryBlock newStorageBlock(VfpProfile profile, Item constituent) {
        return new VfpPantryBlock(profile, Blocks.field_196556_aL, constituent, SharedGlue.Block_soundType_Cloth).autoregister(VfpPantryBlock.class);
    }

    public static VfpPlainItem newStorageItem(VfpProfile profile) {
        return new VfpStorageItem(profile).autoregister();
    }

    public static VfpBrewingItem newBrewingItem(VfpProfile profile, BrewEffect effect, boolean uncommon) {
        return (VfpBrewingItem)new VfpBrewingItem(profile, effect).autoregister(VfpBrewingItem.class).setUncommon(uncommon);
    }

    public static VfpBrewingItem newBrewingItem(VfpProfile profile, boolean uncommon) {
        return (VfpBrewingItem)new VfpBrewingItem(profile, null).autoregister(VfpBrewingItem.class).setUncommon(uncommon);
    }

    public static final ItemStack newItemInstance(Item item, int amount) {
        return ItemStacks.create((Item)item, (int)amount);
    }

    public static final ItemStack newItemInstance(Item item) {
        return VfpBuilder.newItemInstance(item, 1);
    }

    public VfpBuilder(VfpRuntimeSkeleton runtime) {
        Validate.isTrue((runtime != null && runtime.getConfig() != null ? 1 : 0) != 0, (String)"sided runtime MUST be initialized", (Object[])new Object[0]);
        this._subBuilders = new ArrayList<VfpBuildHelper>(13);
        this._subBuilders.add(new AgentsBuildHelper());
        this._subBuilders.add(new MilkExtrasBuildHelper());
        this._subBuilders.add(new SugarExtrasBuildHelper());
        this._subBuilders.add(new WheatExtrasBuildHelper());
        this._subBuilders.add(new EggExtrasBuildHelper());
        this._subBuilders.add(new VeggiesBuildHelper());
        this._subBuilders.add(new MeatExtrasBuildHelper());
        this._subBuilders.add(new SandwichesBuildHelper());
        this._subBuilders.add(new MealsBuildHelper());
        this._subBuilders.add(new MiscBuildHelper());
    }

    public final void beforeStartUp(VfpRuntimeSkeleton runtime) {
        VfpConfig config = runtime.getConfig();
        VfpPotions.init(config);
        ModDrops.registerHandlers(config);
        this.registerRecipeSerializers();
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, e -> {
            config.setRecipeFlagsEarly();
            this.initTab();
            this.doBuildObjects1(runtime);
            this.doBuildObjects2(runtime);
            IniRegistries.autoregisterBlocks((String)"vanillafoodpantry", (IForgeRegistry)ForgeRegistries.BLOCKS);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, e -> {
            IniRegistries.autoregisterItems((String)"vanillafoodpantry", (IForgeRegistry)ForgeRegistries.ITEMS);
            this.doRegistryDependentLinks1();
        });
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Effect.class, e -> IniRegistries.autoregisterPotions((String)"vanillafoodpantry", (IForgeRegistry)ForgeRegistries.POTIONS));
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Potion.class, e -> IniRegistries.autoregisterPotionMixes((String)"vanillafoodpantry", (IForgeRegistry)ForgeRegistries.POTION_TYPES));
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, e -> this.doLateRecipeSupport());
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(StatType.class, this::doDefinePlayerStats);
    }

    private void registerRecipeSerializers() {
        ConfigAllowsConditionSerializer.register();
        ConfigIsPresentConditionSerializer.register();
        IsSupercompatibilityModeConditionSerializer.register();
        AllowHotColdFoodConditionSerializer.register();
        UseAnyWaterConditionSerializer.register();
        UseTreatedWaterConditionSerializer.register();
        IRecipeSerializer.func_222156_a((String)KeepEmptyBottlesShapelessRecipe.NAME, (IRecipeSerializer)KeepEmptyBottlesShapelessRecipe.Serializer.INSTANCE);
        IRecipeSerializer.func_222156_a((String)KeepEmptyBottlesShapedRecipe.NAME, (IRecipeSerializer)KeepEmptyBottlesShapedRecipe.Serializer.INSTANCE);
        IRecipeSerializer.func_222156_a((String)FillBucketJarRecipe.NAME, FillBucketJarRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)AddToBucketJarRecipe.NAME, (IRecipeSerializer)AddToBucketJarRecipe.Serializer.INSTANCE);
        IRecipeSerializer.func_222156_a((String)ReheatFoodRecipe.NAME, (IRecipeSerializer)ReheatFoodRecipe.Serializer.INSTANCE);
        IRecipeSerializer.func_222156_a((String)CutterItemRepairRecipe.NAME, (IRecipeSerializer)CutterItemRepairRecipe.Serializer.INSTANCE);
        IRecipeSerializer.func_222156_a((String)CutterExtractHeatPortionsRecipe.NAME, (IRecipeSerializer)CutterExtractHeatPortionsRecipe.Serializer.INSTANCE);
        IRecipeSerializer.func_222156_a((String)KeepDragonHeadShapedRecipe.NAME, KeepDragonHeadShapedRecipe.SERIALIZER);
        DefinedDeckerSandwichRecipe.Serializer.registerAll();
        IRecipeSerializer.func_222156_a((String)GenericDeckerSandwichRecipe.NAME, (IRecipeSerializer)GenericDeckerSandwichRecipe.Serializer.INSTANCE);
        IRecipeSerializer.func_222156_a((String)KingDeckerSandwichRecipe.NAME, KingDeckerSandwichRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)BasicTonicRecipe.NAME, BasicTonicRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)CompositeTonicRecipe.NAME, CompositeTonicRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)PersonalizeTonicRecipe.NAME, PersonalizeTonicRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)SoakFoodShapelessRecipe.NAME, SoakFoodShapelessRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)SoakFoodShapedRecipe.NAME, SoakFoodShapedRecipe.SERIALIZER);
        IRecipeSerializer.func_222156_a((String)TonicToTippedArrowsRecipe.NAME, TonicToTippedArrowsRecipe.SERIALIZER);
    }

    private void initTab() {
        ItemGroup tab;
        VfpConfig config = VfpConfig.getInstance();
        VfpObj.Icon_obj = new VfpPlainItem((VfpProfile)VfpOid.Vfp_Icon, true).autoregister();
        VfpObj.Eek_obj = VfpBuilder.newOptionalItem((VfpProfile)VfpOid.Eek_Vfp, true);
        VfpObj.group = tab = new ItemGroup("VFP"){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)VfpObj.Icon_obj);
            }
        };
        config.setTab(tab);
    }

    private void doBuildObjects1(VfpRuntimeSkeleton runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.makeObjects(runtime);
        }
    }

    private void doBuildObjects2(VfpRuntimeSkeleton runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.makeObjectsFinalPass(runtime);
        }
    }

    public final void earlyStartUp(VfpRuntimeSkeleton runtime) {
        VfpOreGenerator.install();
    }

    public final void midStartUp(VfpRuntimeSkeleton runtime) {
        VfpConfig config = runtime.getConfig();
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.installEventBusHandlers(runtime);
        }
        if (config.includeCraftingXp()) {
            VfpRewards.init(config);
            MinecraftForge.EVENT_BUS.register((Object)VfpRewards.EventsHandler.init(config));
        }
        if (config.includePotionBrewing()) {
            MinecraftForge.EVENT_BUS.register((Object)VfpPotions.EventsHandler.init(config));
        }
        MinecraftForge.EVENT_BUS.register((Object)new VfpConfigChangedListener(runtime));
        this.sendApiMessages(runtime);
    }

    final void doRegistryDependentLinks1() {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkObjects(VanillaFoodPantry.runtime);
        }
    }

    private void doInitLikeFoods(IModRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkLikeFoods(runtime);
        }
    }

    private void doDefineFoodDictionary(IModRuntime runtime) {
        Potions.registerSharedDictIds();
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.addDictionaryEntries(runtime);
        }
    }

    private void doDefineLoot(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        ModDrops.addLootEntries(config);
        if (config.allowLootTableEnrichment()) {
            for (VfpBuildHelper subBuilder : this._subBuilders) {
                subBuilder.addLootEntries(runtime);
            }
        }
        if (Loot.isEnabled((String)"vanillafoodpantry")) {
            MinecraftForge.EVENT_BUS.register((Object)new VfpLootLoadedListener());
        }
    }

    private void doDefinePlayerStats(RegistryEvent.Register<StatType<?>> event) {
        ResourceLocation heated_stat = ModInfo.r("reheated_food");
        Registry.func_218322_a((Registry)Registry.field_212623_l, (ResourceLocation)heated_stat, (Object)heated_stat);
        Stats.field_199092_j.func_199076_b((Object)heated_stat);
        VfpObj.Heated_Food_stat = heated_stat;
        StatType licensed = new StatType(Registry.field_212623_l);
        licensed.setRegistryName(ModInfo.r("licensed"));
        VfpObj.Licensed_stat = licensed;
        event.getRegistry().register((IForgeRegistryEntry)licensed);
    }

    private final void doRegistryDependentLinks2(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        VfpPotions.initFinal(config);
        for (IRegistriesLoadedListener pending : VfpUtils.getBrewingParticipants()) {
            pending.notifyRegistriesReady();
        }
        this.doInitLikeFoods(runtime);
        this.doDefineFoodDictionary(runtime);
        this.doDefineLoot(runtime);
    }

    final void doLateRecipeSupport() {
        IModRuntime runtime = VanillaFoodPantry.runtime;
        this.doRegistryDependentLinks2(runtime);
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.setRecipeRewards(runtime);
        }
    }

    private final void sendApiMessages(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        String _CARROTS_MOD = ModIntegration.CARROTS_LIB.modid();
        String _TICK_ADVANCEMENTS = "tickScorebased";
        InterModComms.sendTo((String)_CARROTS_MOD, (String)"tickScorebased", () -> 120);
        if (config.includePotionBrewing()) {
            String _OMIT_POTION = "omitFromRandomPotions";
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.STRONG_WATER_NATIVE);
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.WOLF_SPIRIT);
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.SUPER_WOLF_SPIRIT);
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.BEAR_SPIRIT);
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.SUPER_BEAR_SPIRIT);
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.UNDYING);
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.LONG_UNDYING);
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.SUGAR_BOMBED);
            InterModComms.sendTo((String)_CARROTS_MOD, (String)"omitFromRandomPotions", () -> VfpPotions.VILLAGE_HEXED);
        }
    }

    public void finishStartUp(VfpRuntimeSkeleton runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.finish(runtime);
        }
    }
}

