/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import java.security.SecureRandom;
import java.util.Random;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.worldgen.OpenOreFeature;
import org.jwaresoftware.mcmods.lib.worldgen.OpenOreFeatureConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;

public final class VfpOreGenerator {
    private static final Random _RANDOM = new SecureRandom();

    public static final void install() {
        DeferredWorkQueue.runLater(VfpOreGenerator::addOresToBiomes);
    }

    public static final void addOresToBiomes() {
        if (VfpConfig.getInstance().isOreGenerationEnabled()) {
            block4: for (Biome biome : ForgeRegistries.BIOMES) {
                switch (biome.func_201856_r()) {
                    case THEEND: {
                        continue block4;
                    }
                    case NETHER: {
                        VfpOreGenerator.addNetherhellSaltOre(biome);
                        continue block4;
                    }
                }
                VfpOreGenerator.addOverworldSaltOre(biome);
                VfpOreGenerator.addOverworldNatronOre(biome);
            }
        }
    }

    private static final void addOverworldSaltOre(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)OpenOreFeature.INSTANCE, (IFeatureConfig)new OpenOreFeatureConfig(VfpObj.RockSalt_OreBlock_obj.func_176223_P(), 4 + _RANDOM.nextInt(11), OpenOreFeatureConfig.IS_STONE), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 5, 5, 210)));
    }

    private static final void addNetherhellSaltOre(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, VfpObj.Nether_RockSalt_OreBlock_obj.func_176223_P(), 5 + _RANDOM.nextInt(6)), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(8, 20, 20, 60)));
    }

    private static final void addOverworldNatronOre(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)OpenOreFeature.INSTANCE, (IFeatureConfig)new OpenOreFeatureConfig(VfpObj.Natron_OreBlock_obj.func_176223_P(), 4 + _RANDOM.nextInt(11), OpenOreFeatureConfig.IS_STONE), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 5, 5, 210)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)OpenOreFeature.INSTANCE, (IFeatureConfig)new OpenOreFeatureConfig(VfpObj.Trona_OreBlock_obj.func_176223_P(), 2 + _RANDOM.nextInt(4), xyz -> xyz.state.func_177230_c() == VfpObj.Natron_OreBlock_obj), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 5, 5, 210)));
    }
}

