/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;

public final class VfpRewards {
    private static boolean _ENABLED = false;
    public static final float NO_XP = 0.0f;
    private static final Map<ItemStack, Float> EXPERIENCE_LIST = new Hashtable<ItemStack, Float>();
    private static int GENEROUS_XP_MIN_BATCH = Integer.MAX_VALUE;
    private static boolean GENEROUS_XP = false;

    static final void init(VfpConfig config) {
        _ENABLED = true;
        if (config.generousCraftingXp()) {
            GENEROUS_XP = true;
            GENEROUS_XP_MIN_BATCH = SharedGlue.TABLE_CRAFT_GRID_SIZE();
        }
    }

    public static final IRecipe addRewardingCraftItem(IRecipe recipe, float experience) {
        ItemStack output;
        if (experience > 0.0f && !ItemStacks.isEmpty((ItemStack)(output = recipe.func_77571_b()))) {
            EXPERIENCE_LIST.put(output.func_77946_l(), Float.valueOf(experience));
        }
        return recipe;
    }

    public static final void addRewardingCraftItem(ItemStack target, float experience) {
        if (experience > 0.0f && !ItemStacks.isEmpty((ItemStack)target)) {
            EXPERIENCE_LIST.put(target.func_77946_l(), Float.valueOf(experience));
        }
    }

    public static final Map<ItemStack, Float> getExperienceMap() {
        return _ENABLED ? Collections.unmodifiableMap(EXPERIENCE_LIST) : Collections.EMPTY_MAP;
    }

    private static boolean equalStacks(ItemStack crafted, ItemStack target) {
        return !ItemStacks.isEmpty((ItemStack)crafted) && target.func_77973_b() == crafted.func_77973_b();
    }

    private static final float getCraftingXpRegistered(ItemStack crafted) {
        for (Map.Entry<ItemStack, Float> next : EXPERIENCE_LIST.entrySet()) {
            if (!VfpRewards.equalStacks(crafted, next.getKey())) continue;
            return next.getValue().floatValue();
        }
        return 0.0f;
    }

    public static final float getCraftingXp(ItemStack crafted) {
        Item item;
        float xp = 0.0f;
        Item item2 = item = ItemStacks.isEmpty((ItemStack)crafted) ? null : crafted.func_77973_b();
        if (item != null && (xp = VfpRewards.getCraftingXpRegistered(crafted)) == 0.0f && item instanceof VfpAware) {
            xp = ((VfpAware)item).vfplink().craftingXp();
        }
        return xp;
    }

    public static final void onCraftingCheckXp(@Nonnull PlayerEntity player, int count, @Nonnull ItemStack crafted) {
        World world = player.func_130014_f_();
        if (!world.field_72995_K) {
            float f = VfpRewards.getCraftingXp(crafted);
            int n = count;
            if (f == 0.0f) {
                n = 0;
            } else if (f < 1.0f) {
                n = 0;
                float chance = player.func_70681_au().nextFloat();
                if (chance < f) {
                    n = 1;
                } else if (GENEROUS_XP && count > GENEROUS_XP_MIN_BATCH && chance < OneXp.Per03.value()) {
                    n = 1;
                }
            } else {
                int n2 = n = GENEROUS_XP ? MathHelper.func_76123_f((float)f) : (int)f;
            }
            while (n > 0) {
                int j = ExperienceOrbEntity.func_70527_a((int)n);
                n -= j;
                SharedGlue.spawnEntityInto((World)world, (Entity)new ExperienceOrbEntity(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v + 0.5, j));
            }
        }
    }

    private VfpRewards() {
    }

    static final class EventsHandler {
        private static EventsHandler instance;

        @Nonnull
        static final EventsHandler init(VfpConfig config) {
            instance = new EventsHandler(config);
            return instance;
        }

        @SubscribeEvent
        public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
            int amountCrafted = ItemStacks.getSize((ItemStack)event.getCrafting());
            if (amountCrafted <= 0) {
                amountCrafted = 1;
            }
            VfpRewards.onCraftingCheckXp(event.getPlayer(), amountCrafted, event.getCrafting());
        }

        private EventsHandler(VfpConfig config) {
        }
    }
}

