/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import java.security.SecureRandom;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemGroup;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;

public abstract class VfpRuntimeSkeleton
implements IModRuntime {
    protected static final Logger _modLogInstance = ModInfo.LOG;
    protected static final Random _modPRNG = new SecureRandom();
    protected VfpConfig _mainConfig = VfpConfig.getInstance();
    protected VfpBuilder _vfpBuilder;
    private MinecraftServer _serverServer;

    protected VfpRuntimeSkeleton() {
    }

    public Logger getLog() {
        return _modLogInstance;
    }

    public Random getPRNG() {
        return _modPRNG;
    }

    public final VfpConfig getConfig() {
        return this._mainConfig;
    }

    public void setRuntimeServer(MinecraftServer ms) {
        this.getLog().info("SetRTServer {}...", (Object)this.getId());
        this._serverServer = ms;
    }

    @Nullable
    public MinecraftServer getRuntimeServer() {
        return this._serverServer;
    }

    public final ItemGroup getOwnedTab() {
        return this._mainConfig.getTab();
    }

    public final void setOwnedTab(ItemGroup tab) {
        this._mainConfig.setTab(tab);
    }

    public void reloadConfig() {
        this._mainConfig.changed();
    }

    public void beforeStartUp() {
        this.getLog().info("Starting[B] {}...", (Object)this.getId());
        this._vfpBuilder = new VfpBuilder(this);
        this._vfpBuilder.beforeStartUp(this);
    }

    public void earlyStartUp(ModLifecycleEvent e) {
        this.getLog().info("Starting[1] {}...", (Object)this.getId());
        this._vfpBuilder.earlyStartUp(this);
    }

    public void midStartUp(ModLifecycleEvent e) {
        this.getLog().info("Starting[2] {}...", (Object)this.getId());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this._vfpBuilder.midStartUp(this);
    }

    public void lateStartUp(ModLifecycleEvent e) {
        this.getLog().info("Starting[3] {}...", (Object)this.getId());
    }

    public void afterStartUp() {
        this.getLog().info("Starting[E] {}...", (Object)this.getId());
        this._vfpBuilder.finishStartUp(this);
    }

    public void shutDown() {
        this.getLog().info("Stopping {}...", (Object)this.getId());
    }
}

