/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sandwiches;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.FoodPortion;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;
import org.jwaresoftware.mcmods.vfp.sandwiches.GenericDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.sandwiches.Sandwich;
import org.jwaresoftware.mcmods.vfp.wheat.Bread;
import org.jwaresoftware.mcmods.vfp.wheat.Minibread;

public final class DeckerSandwich
extends VfpPantryMultiItem {
    static final String _NBT_KLINGON = "vfp:klingon";
    static final String _NBT_MUSCLE = "vfp:muscle";
    private static final int _GENERIC = 0;
    private static final int _KINGED = 1;
    private static final int _CHIKIN = 2;
    private static final int _OSTEAK = 3;
    private static final int _CSTEAK = 4;
    private static final int _MUTTON = 5;
    private static final int _FISH = 6;
    private static final int _VEGGIE = 7;
    private static final int _CUBAN = 8;
    private static final int _LUMBERJACK = 9;
    static final VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, VfpOid.Decker_Generic.fmlid(), LikeFood.decker), new VfpVariant(1, VfpOid.Decker_Kinged.fmlid(), LikeFood.decker), new VfpVariant(2, VfpOid.Decker_Chicken.fmlid(), LikeFood.decker), new VfpVariant(3, VfpOid.Decker_Steak.fmlid(), LikeFood.decker), new VfpVariant(4, VfpOid.Decker_Cheesesteak.fmlid(), LikeFood.decker), new VfpVariant(5, VfpOid.Decker_Mutton.fmlid(), LikeFood.decker), new VfpVariant(6, VfpOid.Decker_Fish.fmlid(), LikeFood.decker), new VfpVariant(7, VfpOid.Decker_Veggie.fmlid(), LikeFood.decker), new VfpVariant(8, VfpOid.Decker_Cuban.fmlid(), LikeFood.decker), new VfpVariant(9, VfpOid.Decker_Lumberjack.fmlid(), LikeFood.decker)};
    static final NonNullList<ItemStack> SAMPLES_ARRAY = NonNullList.func_191197_a((int)VARIANT_ARRAY.length, (Object)ItemStack.field_190927_a);
    private static DeckerSandwich[] INSTANCES;
    private static final String _DELIM = "_||_";
    private static final int _MAX_INGREDIENTS;
    private static final int _BONUS_EFFORT_THRESHOLD = 4;

    DeckerSandwich(VfpVariant variant) {
        super((VfpProfile)VfpOid.Decker, false, variant);
        this.func_185043_a(new ResourceLocation("muscle"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack decker, World world, LivingEntity unused) {
                return ItemStacks.hasFlag((ItemStack)decker, (String)DeckerSandwich._NBT_MUSCLE, (boolean)false) ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("klingon"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack decker, World world, LivingEntity unused) {
                return DeckerSandwich.isGenericDecker(decker) && ItemStacks.hasFlag((ItemStack)decker, (String)DeckerSandwich._NBT_KLINGON, (boolean)false) ? 1.0f : 0.0f;
            }
        });
        this.autoregister();
    }

    static final boolean isGenericDecker(ItemStack decker) {
        return ((DeckerSandwich)decker.func_77973_b())._variant.index() == 0;
    }

    @Override
    protected int getDefaultPortionFoodPoints() {
        return LikeFood.TYPICAL_FOOD_PORTION.healAmount();
    }

    @Override
    public float getSaturationModifier(ItemStack stack) {
        float saturation = super.getSaturationModifier(stack);
        CompoundNBT instr = Instructions.get((ItemStack)stack);
        if (instr != null && instr.func_150297_b("FoodSaturation", 5)) {
            saturation = instr.func_74760_g("FoodSaturation");
        }
        return saturation;
    }

    @Override
    public float getCompostChance() {
        return 0.85f;
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, PlayerEntity player) {
        super.onFoodEaten(eaten, remaining, world, player);
        if (SharedGlue.isaServerWorld((IWorldReader)world) && ItemStacks.hasFlag((ItemStack)eaten, (String)_NBT_MUSCLE, (boolean)false)) {
            Potions.onMuscleFoodEaten((PlayerEntity)player, (int)-1);
        }
    }

    private boolean includeIngredientsInTooltip(boolean advancedTips) {
        return VfpConfig.getInstance().isDebugMode() || advancedTips || VfpConfig.getInstance().showDeckerIngredients();
    }

    private void addIngredientsInformation_(ItemStack decker, World world, List<ITextComponent> tooltip, boolean advanced) {
        String uitip;
        CompoundNBT instr = null;
        instr = Instructions.get((ItemStack)decker);
        if (instr != null && !(uitip = instr.func_74779_i("UiTip")).isEmpty()) {
            String[] lines = StringUtils.splitByWholeSeparator((String)uitip, (String)_DELIM, (int)17);
            for (int i = 0; i < lines.length; ++i) {
                ITextComponent ingredient_string = Strings.deserialize((String)lines[i]);
                if (ingredient_string == null) continue;
                tooltip.add(new StringTextComponent(" + ").func_150257_a(ingredient_string).func_211708_a(TextFormatting.DARK_GRAY));
            }
        }
    }

    @Override
    protected void addFoodPointsInformation_(ItemStack decker, World world, List<ITextComponent> tooltip, boolean advanced) {
        super.addFoodPointsInformation_(decker, world, tooltip, true);
        if (this.includeIngredientsInTooltip(advanced)) {
            this.addIngredientsInformation_(decker, world, tooltip, advanced);
        }
        if (ItemStacks.hasFlag((ItemStack)decker, (String)_NBT_MUSCLE, (boolean)false)) {
            tooltip.add(new StringTextComponent(" ! ").func_211708_a(TextFormatting.DARK_GREEN).func_150257_a(new TranslationTextComponent("item.vfp.decker.muscleboost", new Object[0]).func_211708_a(TextFormatting.DARK_GREEN)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isShowingUiTips(ItemStack decker) {
        return ItemStacks.isFlaggedAsSample((ItemStack)decker);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack decker, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (ItemStacks.isFlaggedAsSample((ItemStack)decker)) {
            Tooltips.addSampleTipLine(tooltip);
            Tooltips.addDocTipDefault((ModIntegration)ModInfo.ID, (ItemStack)decker, tooltip);
            if (this.includeIngredientsInTooltip(flags.func_194127_a())) {
                this.addIngredientsInformation_(decker, world, tooltip, true);
            }
            this.addDebugInformation(decker, tooltip, flags);
        } else {
            super.func_77624_a(decker, world, tooltip, flags);
        }
    }

    @Override
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        ItemStack sample;
        if (!this.isHiddenByDefault() && this.func_194125_a(tab) && !(sample = (ItemStack)SAMPLES_ARRAY.get(this._variant.index())).func_190926_b()) {
            items.add((Object)ItemStacks.copy1((ItemStack)sample));
        }
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            INSTANCES = new DeckerSandwich[VARIANT_ARRAY.length];
            for (int i = 0; i < INSTANCES.length; ++i) {
                DeckerSandwich.INSTANCES[i] = new DeckerSandwich(VARIANT_ARRAY[i]);
            }
        }
    }

    static final void addDictionaryEntries() {
        if (INSTANCES != null) {
            for (int i = 0; i < INSTANCES.length; ++i) {
                if (i == 1) continue;
                RID.addToGroup((String)"foods/sandwiches", (Item)INSTANCES[i]);
            }
        }
    }

    private static void buildSamples() {
        ItemStack french_bread = LikeFood.french_bread.sample(1);
        ItemStack steak = LikeFood.beef.sample(1);
        SAMPLES_ARRAY.set(2, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.chicken.sample(1), new ItemStack((IItemProvider)VfpObj.Portion_Roasted_Veg_obj)), VfpOid.Decker_Chicken, LikeFood.chicken.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(3, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj)), VfpOid.Decker_Steak, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(4, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), LikeFood.cheese_portion.sample(1), new ItemStack((IItemProvider)VfpObj.Sauteed_Alliums_Mushrooms_obj)), VfpOid.Decker_Cheesesteak, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(5, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.mutton.sample(1), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj)), VfpOid.Decker_Mutton, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(8, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.pork.sample(1), LikeFood.salt_pork.sample(1), LikeFood.cheese_portion.sample(1), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj)), VfpOid.Decker_Cuban, -1, -1, LikeFood.meat_pie.saturationModifier())));
        SAMPLES_ARRAY.set(6, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.salmon.sample(1), new ItemStack((IItemProvider)VfpObj.Portion_Roasted_Veg_obj)), VfpOid.Decker_Fish, LikeFood.salmon.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(7, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.roast_veg_medley.sample(1), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj)), VfpOid.Decker_Veggie, LikeFood.potato.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(9, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), LikeFood.mashed_potato.sample(), LikeFood.fried_egg.sample(), LikeFood.fried_egg.sample(), new ItemStack((IItemProvider)VfpObj.Edible_Cactus_Roasted_obj)), VfpOid.Decker_Lumberjack, -1, -1, LikeFood.golden_carrot.saturationModifier())));
        SAMPLES_ARRAY.set(0, (Object)DeckerSandwich.marksample(DeckerSandwich.create((IItemHandler)new FixedIItemHandler(LikeFood.sandwich_bread.sample(), LikeFood.roast_veg_medley.sample(), LikeFood.cheese_portion.sample(), new ItemStack((IItemProvider)VfpObj.Caramelized_Alliums_obj), new ItemStack((IItemProvider)VfpObj.Roasted_Sunflower_Seeds_obj)), VfpOid.Decker_Generic, 0, -1, 0.0f)));
        SAMPLES_ARRAY.set(1, (Object)DeckerSandwich.marksample(DeckerSandwich.kingme(new FixedIItemHandler(Minibread.cookedEgg(1), new ItemStack((IItemProvider)VfpObj.Bat_CheeseBurger_obj), Sandwich.spamAndEgg(1)))));
    }

    static final void setRecipeRewards() {
        GenericDeckerSandwichRecipe.initFinalize();
        DeckerSandwich.buildSamples();
        VfpRewards.addRewardingCraftItem((ItemStack)SAMPLES_ARRAY.get(7), VfpOid.Decker_Veggie.craftingXp());
        VfpRewards.addRewardingCraftItem((ItemStack)SAMPLES_ARRAY.get(4), VfpOid.Decker_Cheesesteak.craftingXp());
        VfpRewards.addRewardingCraftItem((ItemStack)SAMPLES_ARRAY.get(8), VfpOid.Decker_Cuban.craftingXp());
        VfpRewards.addRewardingCraftItem((ItemStack)SAMPLES_ARRAY.get(9), VfpOid.Decker_Lumberjack.craftingXp());
    }

    public static final ItemStack empty() {
        return INSTANCES != null ? new ItemStack((IItemProvider)INSTANCES[0]) : new ItemStack((IItemProvider)Items.field_151025_P);
    }

    static final int getIngredientFoodTotal(Item food, ItemStack ingredient) {
        int ingredientTotal = food instanceof VfpPantryItem ? ((VfpPantryItem)food).getAvailableFoodPoints(ingredient) : food.func_219967_s().func_221466_a();
        return ingredientTotal;
    }

    private static final void addIngredients(ItemStack deckerSandwich, List<IngredientStats> ingredients, int foodTotal, int fpBonus, float saValue, int muscleBoost, boolean klingon) {
        Collections.sort(ingredients);
        if (fpBonus > 0) {
            IngredientStats stat = new IngredientStats(fpBonus);
            ingredients.add(stat);
        }
        float saturation = 0.0f;
        StringBuilder sb = new StringBuilder(150);
        for (IngredientStats ingredient : ingredients) {
            if (sb.length() > 0) {
                sb.append(_DELIM);
            }
            sb.append(Strings.serialize((ITextComponent)ingredient._foodDisplayName));
            saturation += (float)ingredient._foodPoints / (float)foodTotal * ingredient._foodSaturation;
        }
        if (saValue > 0.0f) {
            saturation = saValue;
        } else {
            if (saturation < LikeFood.decker.saturationModifier()) {
                saturation = LikeFood.decker.saturationModifier();
            }
            if (muscleBoost > 0) {
                saturation += LikeFood.muscle_boost.saturationModifier() * (float)muscleBoost;
            }
        }
        Instructions.get((ItemStack)deckerSandwich).func_74776_a("FoodSaturation", saturation);
        Instructions.get((ItemStack)deckerSandwich).func_74778_a("UiTip", sb.toString());
        if (klingon) {
            ItemStacks.setFlag((ItemStack)deckerSandwich, (String)_NBT_KLINGON, (boolean)true);
        }
        if (muscleBoost > 0) {
            ItemStacks.setFlag((ItemStack)deckerSandwich, (String)_NBT_MUSCLE, (boolean)true);
        }
    }

    public static final ItemStack create(IItemHandler grid, @Nonnull String oid, int recipeBonus, int maxValue, float saturationValue) {
        Validate.notNull((Object)grid, (String)"A valid non-null IItemHandler is required", (Object[])new Object[0]);
        recipeBonus = MathHelper.func_76125_a((int)recipeBonus, (int)0, (int)LikeFood.beef.healAmount());
        ItemStack deckerSandwich = ItemStacks.NULLSTACK();
        int foodTotal = 0;
        ArrayList<IngredientStats> stats = new ArrayList<IngredientStats>(_MAX_INGREDIENTS + 2);
        int effortBonus = 0;
        int muscleBoost = 0;
        boolean klingon = false;
        ITextComponent customName = null;
        int n = grid.getSlots();
        for (int i = 0; i < n; ++i) {
            int ingredientTotal;
            Item food;
            ItemStack ingredient = grid.getStackInSlot(i);
            if (ingredient.func_190926_b()) continue;
            Item item = ingredient.func_77973_b();
            if (item == VfpObj.Dollop_Muscle_obj) {
                ++muscleBoost;
            }
            if ((food = FoodPortion.toFood(ingredient)) == null) {
                if (item != VfpObj.Sandwich_Press_Plate_obj || !ingredient.func_82837_s()) continue;
                customName = ingredient.func_200301_q();
                continue;
            }
            if (Bread.isKlingon(ingredient)) {
                klingon = true;
            }
            if ((ingredientTotal = DeckerSandwich.getIngredientFoodTotal(food, ingredient)) <= 0) continue;
            foodTotal += ingredientTotal;
            IngredientStats stat = new IngredientStats(ingredient, food);
            stat._foodPoints = ingredientTotal;
            stats.add(stat);
            if (stats.size() == _MAX_INGREDIENTS) break;
        }
        if (foodTotal > 0) {
            int index = 0;
            for (int i = 0; i < INSTANCES.length; ++i) {
                if (!oid.equals(VARIANT_ARRAY[i].fmlid())) continue;
                index = i;
                break;
            }
            if (stats.size() > 4) {
                effortBonus = stats.size() - 3;
                foodTotal += effortBonus;
            }
            if (maxValue < 1) {
                maxValue = MAX_TOTAL_FOOD_VALUE_ALLOWED;
            }
            foodTotal = MathHelper.func_76125_a((int)foodTotal, (int)LikeFood.decker.healAmount(), (int)maxValue);
            deckerSandwich = DeckerSandwich.createMultiuseInstance((Item)INSTANCES[index], 1, foodTotal + recipeBonus, LikeFood.TYPICAL_FOOD_PORTION.healAmount());
            DeckerSandwich.addIngredients(deckerSandwich, stats, foodTotal, effortBonus, saturationValue, muscleBoost, klingon);
            if (customName != null) {
                deckerSandwich.func_200302_a(customName);
            }
        }
        return deckerSandwich;
    }

    private static final ItemStack create(IItemHandler grid, VfpOid what, int recipeBonus, int maxValue, float saturationValue) {
        return DeckerSandwich.create(grid, what.fmlid(), recipeBonus, maxValue, saturationValue);
    }

    public static final ItemStack create(IItemHandler grid) {
        return DeckerSandwich.create(grid, VfpOid.Decker_Generic, 0, -1, 0.0f);
    }

    static final ItemStack marksample(ItemStack stack) {
        ItemStacks.setSampleFlag((ItemStack)stack);
        return stack;
    }

    public static final ItemStack kingme(IItemHandler grid) {
        return DeckerSandwich.create(grid, VfpOid.Decker_Kinged, 0, LikeFood.TOWERING_MEGAWICH.healAmount(), 0.0f);
    }

    static final NonNullList<ItemStack> deckerSamples() {
        NonNullList samples = NonNullList.func_191196_a();
        for (ItemStack sample : SAMPLES_ARRAY) {
            if (ItemStacks.isEmpty((ItemStack)sample)) continue;
            samples.add((Object)ItemStacks.copy1((ItemStack)sample));
        }
        return samples;
    }

    static {
        _MAX_INGREDIENTS = SharedGlue.TABLE_CRAFT_GRID_SIZE();
    }

    static final class FixedIItemHandler
    implements IItemHandler {
        private final ItemStack[] _items;

        FixedIItemHandler(ItemStack ... items) {
            this._items = items;
        }

        public int getSlotLimit(int slot) {
            return SharedGlue.MAX_STACK_SIZE();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlots() {
            return this._items.length;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < 0 || slot > this._items.length ? ItemStack.field_190927_a : this._items[slot];
        }
    }

    private static final class IngredientStats
    implements Comparable<IngredientStats> {
        public ITextComponent _foodDisplayName;
        public int _foodPoints;
        public float _foodSaturation;

        IngredientStats(int foodpoints) {
            this._foodDisplayName = new TranslationTextComponent("item.vfp.decker.bonus", new Object[0]);
            this._foodPoints = foodpoints;
            this._foodSaturation = 10.0f / (float)foodpoints;
        }

        IngredientStats(ItemStack stack, Item food) {
            this._foodDisplayName = stack.func_200301_q();
            this._foodSaturation = food.func_219967_s().func_221469_b();
        }

        @Override
        public int compareTo(IngredientStats o) {
            if (o == null) {
                throw new NullPointerException();
            }
            return this._foodDisplayName.func_150254_d().compareTo(o._foodDisplayName.func_150254_d());
        }
    }
}

