/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sandwiches;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class Sandwich
extends VfpPantryMultiItem {
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, VfpOid.Buttered_Bread.fmlid(), LikeFood.buttered_bread), new VfpVariant(1, VfpOid.Fried_Egg_Sandwich.fmlid(), LikeFood.fryegg_sandwich), new VfpVariant(2, VfpOid.Double_Fried_Egg_Sandwich.fmlid(), LikeFood.fry2egg_sandwich), new VfpVariant(3, VfpOid.Ham_Egg_Sandwich.fmlid(), LikeFood.hamegg_sandwich), new VfpVariant(4, VfpOid.Cheese_Sandwich.fmlid(), LikeFood.cheese_sandwich), new VfpVariant(5, VfpOid.Spam_Egg_Sandwich.fmlid(), LikeFood.hamegg_sandwich), new VfpVariant(6, VfpOid.Creamed_Spam_Eggs_Toast.fmlid(), LikeFood.hamegg_sandwich), new VfpVariant(7, VfpOid.Cyclops_Sandwich.fmlid(), LikeFood.cyclops_sandwich), new VfpVariant(8, VfpOid.Fish_Sausage_Mashwrap.fmlid(), LikeFood.fish_sausage_wrap), new VfpVariant(9, VfpOid.Sunbutter_AppleSlices_Sandwich.fmlid(), LikeFood.sunbutter_fruit_sandwich), new VfpVariant(10, VfpOid.Chocolate_Sunbutter_Sandwich.fmlid(), LikeFood.sunbutter_sandwich), new VfpVariant(11, VfpOid.Crafty_Preserves_Sunbutter_Sandwich.fmlid(), LikeFood.sunbutter_fruit_sandwich), new VfpVariant(12, VfpOid.JellyJam_Sandwich.fmlid(), LikeFood.jellyjam_sandwich), new VfpVariant(13, VfpOid.Cheese_JellyJam_Sandwich.fmlid(), LikeFood.cheese_jellyjam_sandwich)};
    private static Sandwich[] INSTANCES;

    Sandwich(VfpVariant variant) {
        super((VfpProfile)VfpOid.Sandwich, false, variant);
        this.autoregister();
    }

    @Override
    public float getCompostChance() {
        return 0.65f;
    }

    private static final ItemStack createSandwich(int amount, int index) {
        return INSTANCES[index].createInstance((Item)INSTANCES[index], amount);
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            INSTANCES = new Sandwich[VARIANT_ARRAY.length];
            for (int i = 0; i < INSTANCES.length; ++i) {
                Sandwich.INSTANCES[i] = new Sandwich(VARIANT_ARRAY[i]);
                Sandwich.VARIANT_ARRAY[i] = null;
            }
        }
    }

    static final void addDictionaryEntries() {
        if (INSTANCES != null) {
            for (int i = 0; i < INSTANCES.length; ++i) {
                if (i == 0) {
                    RID.addToGroup((String)"carrots:portions_bread", (ItemStack)Sandwich.createSandwich(1, i));
                    continue;
                }
                RID.addToGroup((String)"foods/sandwiches", (ItemStack)Sandwich.createSandwich(1, i));
            }
        }
    }

    static final void linkLikeFoods() {
        LikeFood.fryegg_sandwich.food().item(Sandwich.createSandwich(1, 1));
        LikeFood.hamegg_sandwich.food().item(Sandwich.createSandwich(1, 3));
        LikeFood.cheese_sandwich.food().item(Sandwich.createSandwich(1, 4));
        LikeFood.jellyjam_sandwich.food().item(Sandwich.createSandwich(1, 12));
    }

    static final void setRecipeRewards() {
        if (INSTANCES == null) {
            return;
        }
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 1), LikeFood.sandwich.craftExperience());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 2), LikeFood.sandwich.craftExperience());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 3), LikeFood.sandwich.craftExperience());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 4), LikeFood.sandwich.craftExperience());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 5), VfpOid.Spam_Egg_Sandwich.craftingXp());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 6), VfpOid.Creamed_Spam_Eggs_Toast.craftingXp());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 7), VfpOid.Cyclops_Sandwich.craftingXp());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 8), VfpOid.Fish_Sausage_Mashwrap.craftingXp());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 9), VfpOid.Sunbutter_AppleSlices_Sandwich.craftingXp());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 10), VfpOid.Chocolate_Sunbutter_Sandwich.craftingXp());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 11), VfpOid.Crafty_Preserves_Sunbutter_Sandwich.craftingXp());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 12), VfpOid.JellyJam_Sandwich.craftingXp());
        VfpRewards.addRewardingCraftItem(Sandwich.createSandwich(1, 13), VfpOid.Cheese_JellyJam_Sandwich.craftingXp());
    }

    public static final ItemStack spamAndEgg(int amount) {
        return INSTANCES != null ? Sandwich.createSandwich(amount, 4) : new ItemStack((IItemProvider)Items.field_151025_P);
    }

    public static final ItemStack sunButterAndApples(int amount) {
        return INSTANCES != null ? Sandwich.createSandwich(amount, 8) : new ItemStack((IItemProvider)Items.field_151025_P);
    }

    public static final ItemStack sunButterAndJelly(int amount) {
        return INSTANCES != null ? Sandwich.createSandwich(amount, 10) : new ItemStack((IItemProvider)Items.field_151025_P);
    }

    public static final ItemStack cheese(int amount) {
        return INSTANCES != null ? Sandwich.createSandwich(amount, 3) : new ItemStack((IItemProvider)Items.field_151025_P);
    }
}

