/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IRegistriesLoadedListener;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;

public final class GoldenSugar
extends VfpPantryItem
implements IRegistriesLoadedListener {
    private static int POTION_EFFECT_DURATION_SECS = 480;

    GoldenSugar() {
        super(VfpOid.Golden_Sugar, new LikeFood(0, LikeFood.hardened_sugar, LikeFood.hardened_sugar, LikeFood.golden_boost), null);
        this.autoregister();
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, PlayerEntity player) {
        super.onFoodEaten(eaten, remaining, world, player);
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            int duration_secs = this.getPotionEffectDurationSecs(true);
            Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_digSpeed, (int)duration_secs, (int)1);
            Potions.addPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_jump, (int)duration_secs, (int)1);
        }
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? POTION_EFFECT_DURATION_SECS : super.getPotionEffectDurationSecs(good);
    }

    public void notifyRegistriesReady() {
        if (VfpConfig.getInstance().includePotionBrewing()) {
            BrewEffect.addWaterConversionFor((Item)this, (Potion)VfpPotions.SUGAR_BOMBED);
            BrewEffect.addRecipeFor((Item)this, (Potion)VfpPotions.SUGAR_BOMBED);
        }
    }
}

