/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.impl.fluid.BucketProperties;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalBottleItem;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class Bottle
extends UniversalBottleItem
implements VfpAware,
IMultiColored {
    protected final VfpProfile _profile;

    public Bottle(@Nonnull VfpProfile oid, boolean hidden, BucketProperties bp) {
        super(oid.fmlid(), hidden, bp);
        this._profile = oid;
        this.func_185043_a(new ResourceLocation("carrots:empty"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack bottle, World world, LivingEntity unused) {
                return ((Bottle)bottle.func_77973_b()).isEmpty(bottle) ? 1.0f : 0.0f;
            }
        });
        VfpUtils.autoregisterItem((Item)this, this._profile);
    }

    public Bottle() {
        this(VfpOid.Full_Bottle, true, new BucketProperties().zeroed().group(VfpObj.group).emptyBucket(() -> new ItemStack((IItemProvider)VfpObj.Empty_Bottle_obj)));
    }

    public final String itemid_prefix() {
        return this._profile.itemid_prefix();
    }

    @Override
    public final VfpProfile vfplink() {
        return this._profile;
    }

    public int getColorFrom(ItemStack bottle, int tintIndex) {
        int color_num = 0xFFFFFF;
        if (tintIndex <= 0) {
            int custom = Instructions.getColorRgb((ItemStack)bottle, (int)color_num);
            color_num = custom != color_num ? custom : super.getColorFrom(bottle, tintIndex);
        }
        return color_num;
    }

    protected void initSamplingContents(ItemStack bottle, Fluid of) {
        Fluids.setBucketFluid((ItemStack)bottle, (FluidStack)Fluids.bottleOf((Fluid)of), (boolean)true);
    }

    public ITextComponent func_200295_i(ItemStack bottle) {
        FluidStack f = Fluids.sameOrNull((FluidStack)this.getFluid(bottle));
        return f != null ? new TranslationTextComponent("item.vfp.full_bottle_of", new Object[]{f.getDisplayName(), f.getAmount()}) : new TranslationTextComponent("item.vfp.empty_bottle", new Object[0]);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (tab == ItemGroup.field_78027_g) {
            ItemStack sampling = new ItemStack((IItemProvider)this);
            this.initSamplingContents(sampling, Fluids.honey());
            items.add((Object)sampling);
            sampling = new ItemStack((IItemProvider)this);
            this.initSamplingContents(sampling, Fluids.seedoil());
            items.add((Object)sampling);
            sampling = new ItemStack((IItemProvider)this);
            this.initSamplingContents(sampling, Fluids.experience());
            items.add((Object)sampling);
        }
    }
}

