/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.api.IBucketful;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.impl.fluid.PortionedItemStackFluidHandler;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalBucketItem;
import org.jwaresoftware.mcmods.vfp.common.VfpMultiUseJarIngredient;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class BucketJar
extends VfpMultiUseJarIngredient
implements IMultiColored,
IBucketful {
    static final int _1USE_mB = 1;

    public BucketJar() {
        super((VfpProfile)VfpOid.Full_Bucket_Jar, 1000, true);
        this.func_185043_a(new ResourceLocation("milk"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack jar, World world, LivingEntity unused) {
                return Fluids.isMilk((FluidStack)Fluids.getBucketFluid((ItemStack)jar)) ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public ItemStack getNewEmptyContainer(@Nonnull ItemStack jar) {
        return ItemStacks.create((Item)VfpObj.Empty_Bucket_Jar_obj);
    }

    public int getColorFrom(ItemStack jar, int tintIndex) {
        int color_num = 0xFFFFFF;
        if (tintIndex <= 0) {
            int custom = Instructions.getColorRgb((ItemStack)jar, (int)color_num);
            color_num = custom != color_num ? custom : UniversalBucketItem.getColorFrom((FluidStack)Fluids.getBucketFluid((ItemStack)jar));
        }
        return color_num;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack jar, CompoundNBT nbt) {
        return new PortionedItemStackFluidHandler(jar, VfpObj.Empty_Bucket_Jar_obj, 1000, 1, false, PortionedItemStackFluidHandler.IS_JARABLE_FLUID);
    }

    public void onFluidChanged(ItemStack jar) {
        int fluidAmount = Fluids.getBucketFluidAmount((ItemStack)jar);
        this.setUsesLeft(jar, fluidAmount / 1);
    }

    private void setContents(ItemStack jar, FluidStack to) {
        Fluids.setBucketFluid((ItemStack)jar, (FluidStack)to, (boolean)true);
        this.onFluidChanged(jar);
    }

    @Override
    protected void initDefaultContents(ItemStack jar) {
        super.initDefaultContents(jar);
        this.setContents(jar, Fluids.bucketOf((Fluid)Fluids.water()));
    }

    @Override
    public final ItemStack getContainerItem(ItemStack jar) {
        return this.getNewEmptyContainer(jar);
    }

    @Override
    public ITextComponent func_200295_i(ItemStack jar) {
        FluidStack f = Fluids.sameOrNull((FluidStack)Fluids.getBucketFluid((ItemStack)jar));
        return f != null ? new TranslationTextComponent("item.vfp.full_bucket_jar_with", new Object[]{f.getDisplayName(), f.getAmount()}) : new TranslationTextComponent("item.vfp.empty_bucket_jar", new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack jar, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        FluidStack f = Fluids.sameOrNull((FluidStack)Fluids.getBucketFluid((ItemStack)jar));
        if (f != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.vfp.full_bucket_jar_amount_detail", new Object[]{BucketJar.getUsesLeft(jar), this.getMaxUses()}));
        }
        super.func_77624_a(jar, world, tooltip, flags);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        int n = items.size();
        super.func_150895_a(tab, items);
        if (items.size() > n) {
            ItemStack sample = this.createInstance((Item)this);
            this.setContents(sample, new FluidStack((Fluid)Fluids.water(), 100));
            items.add((Object)sample);
            sample = this.createInstance((Item)this);
            this.setContents(sample, Fluids.bucketOf((Fluid)Fluids.milk()));
            items.add((Object)sample);
            sample = this.createInstance((Item)this);
            this.setContents(sample, Fluids.bottleOf((Fluid)Fluids.seedoil(), (int)3));
            items.add((Object)sample);
            sample = this.createInstance((Item)this);
            this.setContents(sample, Fluids.bottleOf((Fluid)Fluids.honey(), (int)2));
            items.add((Object)sample);
            sample = this.createInstance((Item)this);
            this.setContents(sample, Fluids.bottleOf((Fluid)Fluids.experience()));
            items.add((Object)sample);
        }
    }
}

