/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpToolItem;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.utensils.WorkedFlintTier;

public final class FlintButcherAxe
extends VfpToolItem {
    private static final VfpProfile _PROFILE = VfpOid.Flint_Butcher_Axe;
    static final float _TOOL_DAMAGE = 7.0f;
    private static final Set<Block> TOOL_EFFECTIVE_ON_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150423_aK, Blocks.field_196625_cS, Blocks.field_150440_ba, Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_196553_aF, Blocks.field_222405_kQ, Blocks.field_196628_cT});
    private static final Material[] TOOL_EFFECTIVE_ON_MATERIALS = new Material[]{Material.field_151569_G, Material.field_151585_k, Material.field_151582_l, Material.field_151584_j, Material.field_151572_C, Material.field_151570_A, Material.field_215713_z, Material.field_215712_y, Material.field_204868_h, Material.field_203243_f, Material.field_151570_A, Material.field_151580_n, Material.field_151583_m, Material.field_151591_t};

    public FlintButcherAxe() {
        super(_PROFILE, 7.0f, -3.1f, WorkedFlintTier.INSTANCE, false, TOOL_EFFECTIVE_ON_BLOCKS, VfpUtils.newproperties(VfpUtils.bestTab(_PROFILE, SharedGlue.CreativeTabs_tools)).addToolType(ToolType.AXE, SharedGlue.STONE_TOOL_LEVEL()).addToolType(ToolType.get((String)SharedGlue.KNIFE_TOOLNAME()), SharedGlue.IRON_TOOL_LEVEL()).addToolType(ToolType.get((String)SharedGlue.MACHETE_TOOLNAME()), SharedGlue.IRON_TOOL_LEVEL()));
        this.autoregister();
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_196553_aF || block == Blocks.field_150420_aW || block == Blocks.field_150419_aX) {
            return true;
        }
        if (block.getHarvestLevel(state) > SharedGlue.STONE_TOOL_LEVEL()) {
            return false;
        }
        Material material = state.func_185904_a();
        for (Material next : TOOL_EFFECTIVE_ON_MATERIALS) {
            if (!next.equals(material)) continue;
            return true;
        }
        return super.canHarvestBlock(stack, state);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        if (block == Blocks.field_196553_aF) {
            return SharedGlue.MAX_TOOL_EFFICIENCY();
        }
        if (material == Material.field_151575_d && block instanceof HugeMushroomBlock) {
            material = Material.field_151572_C;
        }
        for (Material next : TOOL_EFFECTIVE_ON_MATERIALS) {
            if (!next.equals(material)) continue;
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean canCraftWith(ItemStack axe) {
        return true;
    }

    public boolean func_77644_a(ItemStack axe, LivingEntity target, LivingEntity attacker) {
        int amount = SharedGlue.isaAnimal((Entity)target) && SharedGlue.isaRealPlayer((Entity)attacker) ? 1 : 2;
        axe.func_222118_a(amount, attacker, a -> a.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }
}

