/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.block;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.block.BaseBlockTE;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.init.WaterworksBlocks;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksItems;
import org.terpo.waterworks.inventory.WaterworksInventoryHelper;
import org.terpo.waterworks.tileentity.TileEntityGroundwaterPump;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class BlockGroundwaterPump
extends BaseBlockTE<TileEntityGroundwaterPump> {
    private static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.8125, 0.875);
    private static final AxisAlignedBB collisionBox = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.8125, 0.875);
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockGroundwaterPump() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Object tileEntity;
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND && (tileEntity = this.getTE(worldIn, pos)) instanceof TileEntityGroundwaterPump) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_77973_b() == WaterworksItems.pipe_wrench) {
                this.turnPumpModel(worldIn, pos, state);
                return true;
            }
            if (!heldItem.func_190926_b() && !playerIn.func_70093_af() && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && FluidHelper.interactWithFluidHandler(worldIn, pos, playerIn, hand, facing, tileEntity, heldItem)) {
                return true;
            }
            playerIn.openGui((Object)Waterworks.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        int dir = placer.func_174811_aO().func_176736_b();
        worldIn.func_180501_a(pos, this.func_176203_a(dir), 2);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGroundwaterPump();
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean func_149740_M(IBlockState bs) {
        return true;
    }

    public int func_180641_l(IBlockState bs, World world, BlockPos pos) {
        TileWaterworks te = (TileWaterworks)((Object)this.getTE(world, pos));
        if (te != null) {
            return te.getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Object tileEntity = this.getTE(world, pos);
        if (tileEntity instanceof TileWaterworks) {
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            WaterworksInventoryHelper.dropItemsFromInventory(world, pos, handler);
        }
        BlockGroundwaterPump.breakPipes(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private static void breakPipes(World world, BlockPos pos) {
        BlockPos position;
        IBlockState state;
        int count = 0;
        for (int y = pos.func_177956_o() - 1; y >= 0 && (state = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()))).func_177230_c().equals(WaterworksBlocks.waterPipe); --y) {
            world.func_175655_b(position, false);
            ++count;
        }
        if (count > 0) {
            BlockGroundwaterPump.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(WaterworksBlocks.waterPipe, count));
            if (WaterworksConfig.pump.groundwaterPumpSafety) {
                world.func_175656_a(pos.func_177977_b(), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
            }
        }
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boundingBox;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        BaseBlockTE.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)collisionBox);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private void turnPumpModel(World worldIn, BlockPos pos, IBlockState state) {
        int meta = this.func_176201_c(state);
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        facing = facing.func_176746_e();
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing), 2);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        return facing.func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING});
    }
}

