/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.block;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.terpo.waterworks.block.BaseBlockTE;
import org.terpo.waterworks.init.WaterworksItems;
import org.terpo.waterworks.tileentity.BaseTileEntity;
import org.terpo.waterworks.tileentity.TileEntityRainCollector;
import org.terpo.waterworks.tileentity.TileEntityRainCollectorController;

public class BlockRainCollector
extends BaseBlockTE<BaseTileEntity> {
    public BlockRainCollector() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"tooltip.rain_collector", (Object[])new Object[0]));
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRainCollector();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        Object tileEntity;
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND && (tileEntity = this.getTE(worldIn, pos)) instanceof TileEntityRainCollector && (heldItem = playerIn.func_184586_b(hand)).func_77973_b() == WaterworksItems.pipe_wrench) {
            String out;
            TileEntityRainCollector collector = (TileEntityRainCollector)((Object)tileEntity);
            if (collector.hasController()) {
                BlockPos controllerPos = collector.getController().func_174877_v();
                out = "Found Controller at " + controllerPos.func_177958_n() + "," + controllerPos.func_177956_o() + "," + controllerPos.func_177952_p();
            } else {
                out = "No Controller found";
            }
            playerIn.func_145747_a((ITextComponent)new TextComponentString(out));
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_149740_M(IBlockState bs) {
        return true;
    }

    public int func_180641_l(IBlockState bs, World world, BlockPos pos) {
        TileEntityRainCollectorController controller;
        Object te = this.getTE(world, pos);
        if (te instanceof TileEntityRainCollector && (controller = ((TileEntityRainCollector)((Object)te)).getController()) != null) {
            return controller.getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Object tileEntity = this.getTE(world, pos);
        if (tileEntity instanceof TileEntityRainCollector) {
            ((TileEntityRainCollector)((Object)tileEntity)).informAboutBlockBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149716_u() {
        return true;
    }
}

