/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.block;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.block.BaseBlockTE;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.init.WaterworksItems;
import org.terpo.waterworks.inventory.WaterworksInventoryHelper;
import org.terpo.waterworks.tileentity.TileEntityRainCollectorController;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class BlockRainCollectorController
extends BaseBlockTE<TileWaterworks> {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)4);

    public BlockRainCollectorController() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"tooltip.rain_collector_controller", (Object[])new Object[0]));
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRainCollectorController();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Object tileEntity;
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND && (tileEntity = this.getTE(worldIn, pos)) instanceof TileEntityRainCollectorController) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_77973_b() == WaterworksItems.pipe_wrench) {
                int collectors = ((TileEntityRainCollectorController)((Object)tileEntity)).findRainCollectors();
                String out = collectors - 1 + " Collectors found";
                playerIn.func_145747_a((ITextComponent)new TextComponentString(out));
                return true;
            }
            if (!heldItem.func_190926_b() && !playerIn.func_70093_af() && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && FluidHelper.interactWithFluidHandler(worldIn, pos, playerIn, hand, facing, tileEntity, heldItem)) {
                return true;
            }
            playerIn.openGui((Object)Waterworks.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return true;
    }

    public boolean func_149740_M(IBlockState bs) {
        return true;
    }

    public int func_180641_l(IBlockState bs, World world, BlockPos pos) {
        TileWaterworks te = (TileWaterworks)((Object)this.getTE(world, pos));
        if (te != null) {
            return te.getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Object tileEntity = this.getTE(world, pos);
        if (tileEntity instanceof TileWaterworks) {
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            WaterworksInventoryHelper.dropItemsFromInventory(world, pos, handler);
        }
        if (tileEntity instanceof TileEntityRainCollectorController) {
            ((TileEntityRainCollectorController)((Object)tileEntity)).resetController();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149716_u() {
        return true;
    }
}

