/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.energy;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;
import org.terpo.waterworks.tileentity.TileEntityGroundwaterPump;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class WaterworksBattery
extends EnergyStorage {
    private final TileWaterworks tile;
    int lastTick = 0;

    public WaterworksBattery(int capacity, int maxReceive, int maxExtract, TileWaterworks tE) {
        super(capacity, maxReceive, maxExtract);
        this.tile = tE;
        this.lastTick = this.tile.getCurrentTick();
    }

    public int extractInternal(int energyAmount, boolean simulate) {
        if (!simulate && energyAmount <= this.energy) {
            this.energy -= energyAmount;
            this.onContentsChanged();
            return energyAmount;
        }
        return 0;
    }

    public boolean hasEnoughEnergy(int energyAmount) {
        return this.getEnergyStored() >= energyAmount;
    }

    public int receiveEnergy(int maximumReceive, boolean simulate) {
        this.onContentsChanged();
        return super.receiveEnergy(maximumReceive, simulate);
    }

    protected void onContentsChanged() {
        if (this.tile instanceof TileEntityGroundwaterPump && this.tile.getCurrentTick() - this.lastTick > 20) {
            ((TileEntityGroundwaterPump)this.tile).sendEnergyPacket();
            this.lastTick = this.tile.getCurrentTick();
        }
    }

    public void setEnergyAmount(int energyAmount) {
        this.energy = energyAmount > this.capacity ? this.capacity : energyAmount;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("energyStored", this.energy);
        return compound;
    }

    public WaterworksBattery readFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("energyStored")) {
            this.energy = compound.func_74762_e("energyStored");
        }
        return this;
    }
}

