/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.entity.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.terpo.waterworks.init.WaterworksConfig;

public class EntityFireworkRocketRain
extends Entity {
    protected static DataParameter<ItemStack> RAINROCKET_ITEM = EntityDataManager.func_187226_a(EntityFireworkRocketRain.class, (DataSerializer)DataSerializers.field_187196_f);
    protected static DataParameter<Integer> RAINROCKET_ITEM_INT = EntityDataManager.func_187226_a(EntityFireworkRocketRain.class, (DataSerializer)DataSerializers.field_187192_b);
    private int fireworkAge;
    private int lifetime;
    private EntityLivingBase entityPlacer;
    private int rainDuration;

    public EntityFireworkRocketRain(World worldIn) {
        super(worldIn);
        this.rainDuration = WaterworksConfig.rockets.rainDuration;
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityFireworkRocketRain(World worldIn, double x, double y, double z, ItemStack givenItem) {
        super(worldIn);
        this.rainDuration = WaterworksConfig.rockets.rainDuration;
        this.fireworkAge = 0;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(x, y, z);
        int i = 1;
        if (!givenItem.func_190926_b() && givenItem.func_77942_o()) {
            this.field_70180_af.func_187227_b(RAINROCKET_ITEM, (Object)givenItem.func_77946_l());
            NBTTagCompound nbttagcompound = givenItem.func_77978_p();
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Fireworks");
            i += nbttagcompound1.func_74771_c("Flight");
        }
        this.field_70159_w = this.field_70146_Z.nextGaussian() * 0.001;
        this.field_70179_y = this.field_70146_Z.nextGaussian() * 0.001;
        this.field_70181_x = 0.05;
        this.lifetime = 10 * i + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
        if (givenItem.func_77942_o()) {
            NBTTagCompound tag = givenItem.func_77978_p();
            int rainMultiplier = -1;
            if (tag.func_74764_b("RAIN")) {
                rainMultiplier = tag.func_74762_e("RAIN");
            }
            if (rainMultiplier != -1) {
                this.rainDuration = WaterworksConfig.rockets.rainDuration * rainMultiplier;
                if (!worldIn.field_72995_K) {
                    EntityFireworkRocketRain.announceRocket(this.rainDuration);
                }
            }
        }
    }

    public EntityFireworkRocketRain(World worldIn, ItemStack itemStack, EntityLivingBase entityLivingbase) {
        this(worldIn, entityLivingbase.field_70165_t, entityLivingbase.field_70163_u, entityLivingbase.field_70161_v, itemStack);
        this.field_70180_af.func_187227_b(RAINROCKET_ITEM_INT, (Object)entityLivingbase.func_145782_y());
        this.entityPlacer = entityLivingbase;
    }

    private static void announceRocket(int time) {
        int days = time / 24000;
        int hours = time % 24000 / 1000;
        int min = time % 24000 % 1000 / 17;
        String announcement = "Rain Rocket was launched. Bad weather for the next " + time + " Ticks (" + days + " Days " + hours + " Hours " + min + " Minutes)";
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(announcement));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RAINROCKET_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(RAINROCKET_ITEM_INT, (Object)0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0 && !this.getRocketIntValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return super.func_145770_h(x, y, z) && !this.getRocketIntValue();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.getRocketIntValue()) {
            Entity entity;
            if (this.entityPlacer == null && (entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(RAINROCKET_ITEM_INT)).intValue())) instanceof EntityLivingBase) {
                this.entityPlacer = (EntityLivingBase)entity;
            }
            if (this.entityPlacer != null) {
                if (this.entityPlacer.func_184613_cA()) {
                    Vec3d vec3d = this.entityPlacer.func_70040_Z();
                    this.entityPlacer.field_70159_w += vec3d.field_72450_a * 0.1 + (vec3d.field_72450_a * 1.5 - this.entityPlacer.field_70159_w) * 0.5;
                    this.entityPlacer.field_70181_x += vec3d.field_72448_b * 0.1 + (vec3d.field_72448_b * 1.5 - this.entityPlacer.field_70181_x) * 0.5;
                    this.entityPlacer.field_70179_y += vec3d.field_72449_c * 0.1 + (vec3d.field_72449_c * 1.5 - this.entityPlacer.field_70179_y) * 0.5;
                }
                this.func_70107_b(this.entityPlacer.field_70165_t, this.entityPlacer.field_70163_u, this.entityPlacer.field_70161_v);
                this.field_70159_w = this.entityPlacer.field_70159_w;
                this.field_70181_x = this.entityPlacer.field_70181_x;
                this.field_70179_y = this.entityPlacer.field_70179_y;
            }
        } else {
            this.field_70159_w *= 1.15;
            this.field_70179_y *= 1.15;
            this.field_70181_x += 0.04;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.fireworkAge == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.fireworkAge;
        if (this.field_70170_p.field_72995_K && this.fireworkAge % 2 < 2) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t, this.field_70163_u - 0.3, this.field_70161_v, this.field_70146_Z.nextGaussian() * 0.05, -this.field_70181_x * 0.5, this.field_70146_Z.nextGaussian() * 0.05, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K && this.fireworkAge > this.lifetime) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)17);
            this.damageEntities();
            this.func_70106_y();
        }
    }

    private void damageEntities() {
        NBTTagList nbttaglist;
        float f = 0.0f;
        ItemStack itemstack = (ItemStack)this.field_70180_af.func_187225_a(RAINROCKET_ITEM);
        NBTTagCompound nbttagcompound = itemstack.func_190926_b() ? null : itemstack.func_179543_a("Fireworks");
        NBTTagList nBTTagList = nbttaglist = nbttagcompound != null ? nbttagcompound.func_150295_c("Explosions", 10) : null;
        if (nbttaglist != null && !nbttaglist.func_82582_d()) {
            f = 5 + nbttaglist.func_74745_c() * 2;
        }
        if (f > 0.0f) {
            if (this.entityPlacer != null) {
                this.entityPlacer.func_70097_a(DamageSource.field_191552_t, (float)(5 + (nbttaglist != null ? nbttaglist.func_74745_c() : 1) * 2));
            }
            Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(5.0))) {
                if (entitylivingbase == this.entityPlacer || !(this.func_70068_e((Entity)entitylivingbase) <= 25.0)) continue;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, new Vec3d(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + (double)entitylivingbase.field_70131_O * 0.5 * (double)i, entitylivingbase.field_70161_v), false, true, false);
                    if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f * (float)Math.sqrt((5.0 - (double)this.func_70032_d((Entity)entitylivingbase)) / 5.0);
                entitylivingbase.func_70097_a(DamageSource.field_191552_t, f1);
            }
        }
    }

    public boolean getRocketIntValue() {
        return (Integer)this.field_70180_af.func_187225_a(RAINROCKET_ITEM_INT) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 17 && this.field_70170_p.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.field_70180_af.func_187225_a(RAINROCKET_ITEM);
            NBTTagCompound nbttagcompound = itemstack.func_190926_b() ? null : itemstack.func_179543_a("Fireworks");
            this.field_70170_p.func_92088_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, nbttagcompound);
        }
        super.func_70103_a(id);
    }

    public static void registerFixesFireworkRocket(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackData(EntityFireworkRocketRain.class, new String[]{"FireworksItem"}));
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Life", this.fireworkAge);
        compound.func_74768_a("LifeTime", this.lifetime);
        ItemStack itemstack = (ItemStack)this.field_70180_af.func_187225_a(RAINROCKET_ITEM);
        if (!itemstack.func_190926_b()) {
            compound.func_74782_a("FireworksItem", (NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        ItemStack itemstack;
        this.fireworkAge = compound.func_74762_e("Life");
        this.lifetime = compound.func_74762_e("LifeTime");
        NBTTagCompound nbttagcompound = compound.func_74775_l("FireworksItem");
        if (nbttagcompound != null && !(itemstack = new ItemStack(nbttagcompound)).func_190926_b()) {
            this.field_70180_af.func_187227_b(RAINROCKET_ITEM, (Object)itemstack);
        }
    }

    public boolean func_70075_an() {
        return false;
    }

    public void func_70106_y() {
        WorldInfo worldInfo = this.func_130014_f_().func_72912_H();
        worldInfo.func_176142_i(0);
        worldInfo.func_76080_g(this.rainDuration);
        worldInfo.func_76090_f(this.rainDuration);
        worldInfo.func_76084_b(true);
        if (this.field_70146_Z.nextInt(10) > 6) {
            worldInfo.func_76069_a(true);
        } else {
            worldInfo.func_76069_a(false);
        }
        this.field_70128_L = true;
    }
}

