/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.terpo.waterworks.energy.WaterworksBattery;
import org.terpo.waterworks.fluid.WaterworksTank;
import org.terpo.waterworks.gui.GuiContainerBase;
import org.terpo.waterworks.tileentity.TileEntityGroundwaterPump;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class GuiFluidContainer
extends GuiContainerBase {
    protected WaterworksTank fluidTank;
    protected WaterworksBattery battery;

    public GuiFluidContainer(Container inventorySlotsIn, TileWaterworks te) {
        super(inventorySlotsIn);
        this.fluidTank = te.getFluidTank();
        if (te instanceof TileEntityGroundwaterPump) {
            this.battery = ((TileEntityGroundwaterPump)te).getBattery();
        }
    }

    protected void drawTank(int tankPosX, int tankSizeX, int tankPosY, int tankSizeY) {
        if (this.fluidTank != null) {
            int fillHeight = this.fluidTank.getFluidAmount() * tankSizeY / this.fluidTank.getCapacity();
            if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() != null) {
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(this.fluidTank.getFluid().getFluid().getStill().toString());
                this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                this.func_175175_a(this.getGuiLeft() + tankPosX, this.getGuiTop() + tankPosY + tankSizeY - fillHeight, sprite, tankSizeX, fillHeight);
            }
        }
    }

    protected void drawBattery(int batteryPosX, int batterySizeX, int batteryPosY, int batterySizeY) {
        if (this.battery != null) {
            int fillHeight = this.battery.getEnergyStored() * batterySizeY / this.battery.getMaxEnergyStored();
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("waterworks:textures/blocks/energy_overlay.png"));
            this.func_73729_b(this.getGuiLeft() + batteryPosX, this.getGuiTop() + batteryPosY + batterySizeY - fillHeight, 0, 0, batterySizeX, fillHeight);
        }
    }

    protected void drawTankTooltip(int mouseX, int mouseY, int xStartTank, int xSizeTank, int yStartTank, int ySizeTank) {
        String fluidInfo = this.fluidTank.getFluid() != null ? " (" + this.fluidTank.getFluid().getLocalizedName() + ")" : "";
        String tooltip = this.fluidTank.getFluidAmount() + "/" + this.fluidTank.getCapacity() + " mB" + fluidInfo;
        ArrayList<String> toolTipText = new ArrayList<String>();
        toolTipText.add(tooltip);
        if (this.getGuiLeft() + xStartTank <= mouseX && mouseX < this.getGuiLeft() + xStartTank + xSizeTank && mouseY >= this.getGuiTop() + yStartTank && mouseY < this.getGuiTop() + yStartTank + ySizeTank) {
            this.func_146283_a(toolTipText, mouseX - this.getGuiLeft() + 10, mouseY - this.getGuiTop());
        }
    }

    protected void drawBatteryTooltip(int mouseX, int mouseY, int xStartBattery, int xSizeTankBattery, int yStartBattery, int ySizeBattery) {
        String tooltip = this.battery.getEnergyStored() + "/" + this.battery.getMaxEnergyStored() + " RF";
        if (this.getGuiLeft() + xStartBattery <= mouseX && mouseX < this.getGuiLeft() + xStartBattery + xSizeTankBattery && mouseY >= this.getGuiTop() + yStartBattery && mouseY < this.getGuiTop() + yStartBattery + ySizeBattery) {
            ArrayList<String> toolTipText = new ArrayList<String>();
            toolTipText.add(tooltip);
            this.func_146283_a(toolTipText, mouseX - this.getGuiLeft() + 10, mouseY - this.getGuiTop());
        }
    }
}

