/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.helper;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.terpo.waterworks.fluid.WaterworksTank;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class FluidHelper {
    public static boolean interactWithFluidHandler(World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, TileEntity tileEntity, ItemStack heldItem) {
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing)) {
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (heldItem.func_77973_b().equals(Items.field_151069_bo)) {
            return FluidHelper.fillWaterBottle(worldIn, pos, playerIn, heldItem, hand, (TileWaterworks)tileEntity);
        }
        return false;
    }

    public static boolean fillWaterBottle(World worldIn, BlockPos pos, EntityPlayer playerIn, ItemStack itemstack, EnumHand hand, TileWaterworks tileEntity) {
        WaterworksTank tank = tileEntity.getFluidTank();
        if (tank.getFluidAmount() >= 1000 && tank.getFluid() != null && FluidRegistry.WATER.equals(tank.getFluid().getFluid())) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                tank.drainInternal(1000, true);
                ItemStack stackWaterBottle = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerIn.func_184611_a(hand, stackWaterBottle);
                } else if (!playerIn.field_71071_by.func_70441_a(stackWaterBottle)) {
                    playerIn.func_71019_a(stackWaterBottle, false);
                } else if (playerIn instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)playerIn).func_71120_a(playerIn.field_71069_bz);
                }
            }
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static FluidStack getFluidResource(String fluidName, int amount) {
        return new FluidStack(FluidRegistry.isFluidRegistered((String)fluidName) ? FluidRegistry.getFluid((String)fluidName) : FluidRegistry.WATER, amount);
    }

    public static FluidStack recalculateFillrate(FluidStack stack, int newFillrate, String fluidName) {
        if (stack != null) {
            return new FluidStack(stack, newFillrate);
        }
        return FluidHelper.getFluidResource(fluidName, newFillrate);
    }
}

