/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.init;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.block.BlockGroundwaterPump;
import org.terpo.waterworks.block.BlockRainCollector;
import org.terpo.waterworks.block.BlockRainCollectorController;
import org.terpo.waterworks.block.BlockRainTankWood;
import org.terpo.waterworks.block.BlockWaterPipe;
import org.terpo.waterworks.init.WaterworksBlocks;
import org.terpo.waterworks.init.WaterworksConfig;

public class InitBlocks {
    public static void initBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        if (WaterworksConfig.register.woodenRainTank) {
            WaterworksBlocks.rainTankWood = InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockRainTankWood(), "rain_tank_wood");
        }
        if (WaterworksConfig.register.waterPipe) {
            WaterworksBlocks.waterPipe = InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockWaterPipe(), "water_pipe");
        }
        if (WaterworksConfig.register.rainCollectorMultiblock) {
            WaterworksBlocks.rainCollector = InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockRainCollector(), "rain_collector");
            WaterworksBlocks.rainCollectorController = InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockRainCollectorController(), "rain_collector_controller");
        }
        if (WaterworksConfig.register.groundwaterPump) {
            WaterworksBlocks.groundwaterPump = InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockGroundwaterPump(), "groundwater_pump");
        }
    }

    public static Block registerBlock(IForgeRegistry<Block> registry, Block block, String name) {
        return InitBlocks.registerBlock(registry, block, name, Waterworks.CREATIVE_TAB);
    }

    public static Block registerBlock(IForgeRegistry<Block> registry, Block block, String name, CreativeTabs tab) {
        ((Block)block.setRegistryName("waterworks", name)).func_149663_c(name).func_149647_a(tab);
        registry.register((IForgeRegistryEntry)block);
        return block;
    }

    public static void initItemBlocks(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        if (WaterworksConfig.register.woodenRainTank) {
            InitBlocks.registerItemBlock((IForgeRegistry<Item>)registry, WaterworksBlocks.rainTankWood);
        }
        if (WaterworksConfig.register.waterPipe) {
            InitBlocks.registerItemBlock((IForgeRegistry<Item>)registry, WaterworksBlocks.waterPipe);
        }
        if (WaterworksConfig.register.rainCollectorMultiblock) {
            InitBlocks.registerItemBlock((IForgeRegistry<Item>)registry, WaterworksBlocks.rainCollector);
            InitBlocks.registerItemBlock((IForgeRegistry<Item>)registry, WaterworksBlocks.rainCollectorController);
        }
        if (WaterworksConfig.register.groundwaterPump) {
            InitBlocks.registerItemBlock((IForgeRegistry<Item>)registry, WaterworksBlocks.groundwaterPump);
        }
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        registry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }
}

