/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.init;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.terpo.waterworks.entity.item.EntityFireworkRocketAntiRain;
import org.terpo.waterworks.entity.item.EntityFireworkRocketRain;
import org.terpo.waterworks.init.WaterworksConfig;

public class InitEntities {
    public static int entityId = 1;

    private static <E extends Entity> EntityEntryBuilder<E> createEntityEntryBuilder(String name) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        ResourceLocation registryName = new ResourceLocation("waterworks", name);
        return builder.id(registryName, entityId++).name(registryName.toString());
    }

    public static void init(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        InitEntities.registerEntities((IForgeRegistry<EntityEntry>)registry);
    }

    public static void registerEntities(IForgeRegistry<EntityEntry> registry) {
        ArrayList<EntityEntry> entityEntries = new ArrayList<EntityEntry>();
        if (WaterworksConfig.register.rainRocket) {
            entityEntries.add(InitEntities.createEntityEntryBuilder("firework_rocket_rain").entity(EntityFireworkRocketRain.class).tracker(64, 3, true).build());
        }
        if (WaterworksConfig.register.antiRainRocket) {
            entityEntries.add(InitEntities.createEntityEntryBuilder("firework_rocket_anti_rain").entity(EntityFireworkRocketAntiRain.class).tracker(64, 3, true).build());
        }
        if (entityEntries.size() > 0) {
            registry.registerAll((IForgeRegistryEntry[])entityEntries.toArray(new EntityEntry[entityEntries.size()]));
        }
    }
}

