/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.init;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksItems;
import org.terpo.waterworks.item.ItemFireworkAntiRain;
import org.terpo.waterworks.item.ItemFireworkRain;
import org.terpo.waterworks.item.ItemMaterials;
import org.terpo.waterworks.item.ItemPipeWrench;

public class InitItems {
    public static void init(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        InitItems.registerItems((IForgeRegistry<Item>)registry);
    }

    public static Item registerItem(IForgeRegistry<Item> registry, Item item, String name) {
        return InitItems.registerItem(registry, item, name, Waterworks.CREATIVE_TAB);
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        WaterworksItems.pipe_wrench = InitItems.registerItem(registry, new ItemPipeWrench(), "pipe_wrench");
        if (WaterworksConfig.register.rainRocket) {
            WaterworksItems.firework_rain = InitItems.registerItem(registry, (Item)new ItemFireworkRain(), "firework_rain");
        }
        if (WaterworksConfig.register.antiRainRocket) {
            WaterworksItems.firework_anti_rain = InitItems.registerItem(registry, (Item)new ItemFireworkAntiRain(), "firework_anti_rain");
        }
        WaterworksItems.materials = InitItems.registerItem(registry, new ItemMaterials(), "materials");
    }

    private static Item registerItem(IForgeRegistry<Item> registry, Item item, String name, CreativeTabs tab) {
        ((Item)item.setRegistryName("waterworks", name)).func_77655_b(name).func_77637_a(tab);
        registry.register((IForgeRegistryEntry)item);
        return item;
    }
}

