/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.init;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.terpo.waterworks.Waterworks;

@Config(modid="waterworks")
@Config.LangKey(value="waterworks.config.title")
public class WaterworksConfig {
    public static final RainCollection rainCollection = new RainCollection();
    public static final GroundwaterPump pump = new GroundwaterPump();
    public static final Rockets rockets = new Rockets();
    public static final WaterworksRegister register = new WaterworksRegister();
    public static final WaterworksRecipes recipes = new WaterworksRecipes();

    public static void verifyFluidNameConfig() {
        if (!FluidRegistry.isFluidRegistered((String)WaterworksConfig.rainCollection.woodenRainTankCollectedFluidName)) {
            Waterworks.LOGGER.error("The configured fluid for the Wooden Rain Tank is not registered. Waterworks uses water.");
        }
        if (!FluidRegistry.isFluidRegistered((String)WaterworksConfig.rainCollection.rainCollectorCollectedFluidName)) {
            Waterworks.LOGGER.error("The configured fluid for the Rain Collector Multiblock is not registered. Waterworks uses water.");
        }
        if (!FluidRegistry.isFluidRegistered((String)WaterworksConfig.pump.groundwaterPumpFluidName)) {
            Waterworks.LOGGER.error("The configured fluid for the Groundwater Pump is not registered. Waterworks uses water.");
        }
        if (WaterworksConfig.rainCollection.logFluids) {
            Waterworks.LOGGER.info("Logging all registered fluids.");
            FluidRegistry.getRegisteredFluids().entrySet().forEach(e -> {
                String fluidRegistryName = (String)e.getKey();
                String modId = FluidRegistry.getModId((FluidStack)new FluidStack((Fluid)e.getValue(), 1000));
                Waterworks.LOGGER.info("\"" + fluidRegistryName + "\" by " + modId);
            });
        }
    }

    @Mod.EventBusSubscriber(modid="waterworks")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("waterworks")) {
                ConfigManager.sync((String)"waterworks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class WaterworksRecipes {
        @Config.Comment(value={"If true, the Rain Rocket has a recipe"})
        public boolean recipeRainRocket = true;
        @Config.Comment(value={"If true, the Anti Rain Rocket has a recipe"})
        public boolean recipeAntiRainRocket = true;
    }

    public static class WaterworksRegister {
        @Config.Comment(value={"If true, the Rain Rocket is registered"})
        public boolean rainRocket = true;
        @Config.Comment(value={"If true, the Anti Rain Rocket is registered"})
        public boolean antiRainRocket = true;
        @Config.Comment(value={"If true, the Groundwater Pump is registered"})
        public boolean groundwaterPump = true;
        @Config.Comment(value={"If true, the Rain Collector and Rain Collector Controller are registered"})
        public boolean rainCollectorMultiblock = true;
        @Config.Comment(value={"If true, the Water Pipe is registered"})
        public boolean waterPipe = true;
        @Config.Comment(value={"If true, the Wooden Rain Tank is registered"})
        public boolean woodenRainTank = true;
    }

    public static class Rockets {
        @Config.Comment(value={"Rain duration with x1 multiplier."})
        @Config.RangeInt(min=1, max=12000)
        public int rainDuration = 3000;
        @Config.Comment(value={"Maximum rain multiplier."})
        @Config.RangeInt(min=1, max=24)
        public int rainMaxMultiplier = 8;
        @Config.Comment(value={"Clear sky duration with x1 multiplier."})
        @Config.RangeInt(min=100, max=6000)
        public int clearSkyDuration = 4000;
        @Config.Comment(value={"Maximum clear sky multiplier."})
        @Config.RangeInt(min=1, max=36)
        public int clearSkyMaxMultiplier = 12;
        @Config.Comment(value={"Maximum days of clear sky that will added to the calculated time."})
        @Config.RangeInt(min=0, max=7)
        public int clearSkyMaxRandomAdditionalDays = 3;
        @Config.Comment(value={"Turn this to false to disable JEI description for the Rockets."})
        public boolean fireworkRocketsDescription = true;
        @Config.Comment(value={"JEI: Adds a small description for firework star."})
        public boolean fireworkChargeDescription = true;
        @Config.Comment(value={"JEI: Adds a small description for fireworks."})
        public boolean fireworksDescription = true;
    }

    public static class GroundwaterPump {
        @Config.Comment(value={"The fillrate in mB/second for the Groundwater Pump."})
        @Config.RangeInt(min=1, max=8000)
        public int groundwaterPumpFillrate = 500;
        @Config.Comment(value={"The fluid name that will be collected by the Groundwater Pump."})
        public String groundwaterPumpFluidName = "water";
        @Config.Comment(value={"The capacity in mB for the Groundwater Pump."})
        @Config.RangeInt(min=8000, max=1024000)
        public int groundwaterPumpCapacity = 32000;
        @Config.Comment(value={"Pump energy base usage in forge energy units. Needed for each pump operation."})
        @Config.RangeInt(min=20, max=1024000)
        public int groundwaterPumpEnergyBaseUsage = 1600;
        @Config.Comment(value={"Additional to base usage. Each used pipe will multiplied with this value."})
        @Config.RangeInt(min=0, max=1024000)
        public int groundwaterPumpEnergyPipeMultiplier = 20;
        @Config.Comment(value={"Pump energy capacity in forge energy units."})
        @Config.RangeInt(min=8000, max=1024000)
        public int groundwaterPumpEnergyCapacity = 16000;
        @Config.Comment(value={"Pump energy input rate in forge energy units."})
        @Config.RangeInt(min=20, max=1024000)
        public int groundwaterPumpEnergyInput = 500;
        @Config.Comment(value={"Energy used to place a pipe."})
        @Config.RangeInt(min=0, max=1024000)
        public int groundwaterPumpEnergyPipePlacement = 2500;
        @Config.Comment(value={"Should the Groundwater Pump spawn a slab to close the hole?"})
        public boolean groundwaterPumpSafety = true;
        @Config.Comment(value={"Turn this to false if your world does not generate Bedrock. (Skyblock)"})
        public boolean groundwaterPumpCheckBedrock = true;
        @Config.Comment(value={"Turn this to false to disable JEI description for the Groundwater Pump."})
        public boolean groundwaterPumpDescription = true;
    }

    public static class RainCollection {
        @Config.Comment(value={"The fillrate in mB/second for the Wooden Rain Tank."})
        @Config.RangeInt(min=1, max=8000)
        public int woodenRainTankFillrate = 10;
        @Config.Comment(value={"The fluid name that will be collected by the Rain Tank."})
        public String woodenRainTankCollectedFluidName = "water";
        @Config.Comment(value={"The fluid name that will be collected by the Rain Collector Multiblock."})
        public String rainCollectorCollectedFluidName = "water";
        @Config.Comment(value={"Log all registered fluids."})
        public boolean logFluids = false;
        @Config.Comment(value={"The capacity in mB for the Wooden Rain Tank."})
        @Config.RangeInt(min=1000, max=1024000)
        public int woodenRainTankCapacity = 8000;
        @Config.Comment(value={"Amount of water per second per connected block."})
        @Config.RangeInt(min=1, max=8000)
        public int rainCollectorFillrate = 20;
        @Config.Comment(value={"The capacity in mB for the Rain Collector Multiblock."})
        @Config.RangeInt(min=8000, max=1024000)
        public int rainCollectorCapacity = 32000;
        @Config.Comment(value={"Search radius of the Rain Collector Controller"})
        @Config.RangeInt(min=0, max=7)
        public int rainCollectorRange = 2;
        @Config.Comment(value={"Turn this to false to disable JEI description for the Wooden Rain Tank."})
        public boolean woodenRainTankDescription = true;
        @Config.Comment(value={"Turn this to false to disable JEI description for the Rain Collector Multiblock."})
        public boolean rainCollectorDescription = true;
        @Config.Comment(value={"Turn this to false to disable JEI description for the Wrench."})
        public boolean wrenchDescription = true;
    }
}

