/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.terpo.waterworks.helper.GeneralItemStackHandler;
import org.terpo.waterworks.inventory.SlotDefinition;

public class FluidSlotItemHandler
extends SlotItemHandler {
    private final int index;
    private SlotDefinition slotDefinition = null;

    public FluidSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition, SlotDefinition slotDefinition) {
        super(itemHandler, index, xPosition, yPosition);
        this.index = index;
        this.slotDefinition = slotDefinition;
    }

    public boolean func_75214_a(ItemStack stack) {
        if (!this.isSlotValid()) {
            return false;
        }
        if (!stack.func_190926_b()) {
            return this.isFilteredItemValid(stack);
        }
        return super.func_75214_a(stack);
    }

    protected boolean isFilteredItemValid(ItemStack stack) {
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || this.additionalFilters(stack);
    }

    protected boolean additionalFilters(ItemStack stack) {
        return false;
    }

    protected boolean isSlotValid() {
        return this.slotDefinition != SlotDefinition.O;
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        IItemHandler handler = this.getItemHandler();
        if (handler instanceof GeneralItemStackHandler) {
            return ((GeneralItemStackHandler)handler).extractItemByPlayer(this.index, 1, true) != null;
        }
        return !handler.extractItem(this.index, 1, false).func_190926_b();
    }

    public ItemStack func_75209_a(int amount) {
        IItemHandler handler = this.getItemHandler();
        if (handler instanceof GeneralItemStackHandler) {
            return ((GeneralItemStackHandler)handler).extractItemByPlayer(this.index, amount, false);
        }
        return handler.extractItem(this.index, amount, false);
    }
}

